/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.javascript;

import com.e3roid.E3Activity;
import com.e3roid.lifecycle.E3LifeCycle;
import com.e3roid.script.ScriptEngine;
import com.e3roid.script.ScriptException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class JavaScriptEngine
implements ScriptEngine,
E3LifeCycle {
    private Context context;
    private Scriptable scriptable;
    private Object jsValue;
    private boolean reloadOnResume = false;

    public JavaScriptEngine(InputStream in, String source) {
        this.jsValue = this.evaluate(new InputStreamReader(in), source);
    }

    public Object evaluate(Reader reader, String source) {
        try {
            this.loadContext();
            Object object = this.context.evaluateReader(this.scriptable, reader, source, 1, null);
            return object;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public <T> T call(String name, Object ... args) {
        Object fObj = this.scriptable.get(name, this.scriptable);
        if (fObj instanceof Function) {
            Function f = (Function)fObj;
            return (T)f.call(this.context, this.scriptable, this.scriptable, args);
        }
        throw new ScriptException(String.valueOf(name) + " is undefined or not a function.");
    }

    public Object get(String name) {
        return this.scriptable.get(name, this.scriptable);
    }

    public static JavaScriptEngine loadFromAsset(String filename, E3Activity container) {
        try {
            return JavaScriptEngine.load(container.getAssets().open(filename), filename, container);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public static JavaScriptEngine loadFromData(String filename, E3Activity container) {
        try {
            return JavaScriptEngine.load(container.openFileInput(filename), filename, container);
        }
        catch (FileNotFoundException e) {
            throw new ScriptException(e);
        }
    }

    public static JavaScriptEngine load(InputStream in, String source, E3Activity container) {
        JavaScriptEngine engine = new JavaScriptEngine(in, source);
        container.getEngine().addLifeCycle(engine);
        return engine;
    }

    public Object getEvaluatedValue() {
        return this.jsValue;
    }

    public Scriptable getScriptable() {
        return this.scriptable;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean unload(E3Activity container) {
        this.exitContext();
        return container.getEngine().removeLifeCycle(this);
    }

    public boolean exitContext() {
        if (Context.getCurrentContext() != null) {
            Context.exit();
            this.context = null;
            return true;
        }
        return false;
    }

    public void loadContext() {
        if (this.context == null) {
            this.context = Context.enter();
            this.context.setOptimizationLevel(-1);
            this.scriptable = this.context.initStandardObjects();
        }
    }

    public void reloadOnResume(boolean reload) {
        this.reloadOnResume = reload;
    }

    @Override
    public void onResume() {
        this.loadContext();
    }

    @Override
    public void onPause() {
        if (this.reloadOnResume) {
            this.exitContext();
        }
    }

    @Override
    public void onDispose() {
        this.exitContext();
    }
}

