/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import android.content.Context;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.lib.BaseLib;
import org.luaj.vm2.lib.IoLib;

public class AndroidIoLib
extends IoLib {
    private final Context context;
    private final int mode;

    public AndroidIoLib(Context context, int mode) {
        this.context = context;
        this.mode = mode;
    }

    @Override
    protected IoLib.File wrapStdin() throws IOException {
        return new FileImpl(BaseLib.instance.STDIN);
    }

    @Override
    protected IoLib.File wrapStdout() throws IOException {
        return new FileImpl(BaseLib.instance.STDOUT);
    }

    @Override
    protected IoLib.File openFile(String filename, boolean readMode, boolean appendMode, boolean updateMode, boolean binaryMode) throws IOException {
        FileImpl file = null;
        int scope = 0;
        if (this.mode == 2) {
            scope = 1;
        } else if (this.mode == 3) {
            scope = 2;
        }
        if (readMode && this.mode == 0) {
            file = new FileImpl(this.context.getAssets().open(filename));
        } else if (readMode) {
            file = new FileImpl(this.context.openFileInput(filename));
        } else if (appendMode) {
            file = new FileImpl(this.context.openFileOutput(filename, scope | 0x8000));
        } else if (updateMode) {
            file = new FileImpl(this.context.openFileOutput(filename, scope));
        } else {
            AndroidIoLib.notimplemented();
        }
        return file;
    }

    @Override
    protected IoLib.File openProgram(String prog, String mode) throws IOException {
        Process p = Runtime.getRuntime().exec(prog);
        return "w".equals(mode) ? new FileImpl(p.getOutputStream()) : new FileImpl(p.getInputStream());
    }

    @Override
    protected IoLib.File tmpFile() throws IOException {
        File f = File.createTempFile(".lua.", ".bin");
        f.deleteOnExit();
        return new FileImpl(new RandomAccessFile(f, "rw"));
    }

    private static void notimplemented() {
        throw new LuaError("not implemented");
    }

    private final class FileImpl
    extends IoLib.File {
        private final RandomAccessFile file;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed;
        private boolean nobuffer;

        private FileImpl(RandomAccessFile file, InputStream is, OutputStream os) {
            super(AndroidIoLib.this);
            this.closed = false;
            this.nobuffer = false;
            this.file = file;
            this.is = is != null ? (is.markSupported() ? is : new BufferedInputStream(is)) : null;
            this.os = os;
        }

        private FileImpl(RandomAccessFile f) {
            this(f, null, null);
        }

        private FileImpl(InputStream i) {
            this(null, i, null);
        }

        private FileImpl(OutputStream o) {
            this(null, null, o);
        }

        @Override
        public String tojstring() {
            return "file (" + this.hashCode() + ")";
        }

        @Override
        public boolean isstdfile() {
            return this.file == null;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.file != null) {
                this.file.close();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        @Override
        public void write(LuaString s) throws IOException {
            if (this.os != null) {
                this.os.write(s.m_bytes, s.m_offset, s.m_length);
            } else if (this.file != null) {
                this.file.write(s.m_bytes, s.m_offset, s.m_length);
            } else {
                AndroidIoLib.notimplemented();
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        @Override
        public boolean isclosed() {
            return this.closed;
        }

        @Override
        public int seek(String option, int pos) throws IOException {
            if (this.file != null) {
                if ("set".equals(option)) {
                    this.file.seek(pos);
                } else if ("end".equals(option)) {
                    this.file.seek(this.file.length() + (long)pos);
                } else {
                    this.file.seek(this.file.getFilePointer() + (long)pos);
                }
                return (int)this.file.getFilePointer();
            }
            AndroidIoLib.notimplemented();
            return 0;
        }

        @Override
        public void setvbuf(String mode, int size) {
            this.nobuffer = "no".equals(mode);
        }

        @Override
        public int remaining() throws IOException {
            return this.file != null ? (int)(this.file.length() - this.file.getFilePointer()) : -1;
        }

        @Override
        public int peek() throws IOException {
            if (this.is != null) {
                this.is.mark(1);
                int c = this.is.read();
                this.is.reset();
                return c;
            }
            if (this.file != null) {
                long fp = this.file.getFilePointer();
                int c = this.file.read();
                this.file.seek(fp);
                return c;
            }
            AndroidIoLib.notimplemented();
            return 0;
        }

        @Override
        public int read() throws IOException {
            if (this.is != null) {
                return this.is.read();
            }
            if (this.file != null) {
                return this.file.read();
            }
            AndroidIoLib.notimplemented();
            return 0;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.file != null) {
                return this.file.read(bytes, offset, length);
            }
            if (this.is != null) {
                return this.is.read(bytes, offset, length);
            }
            AndroidIoLib.notimplemented();
            return length;
        }
    }
}

