/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import java.io.File;
import java.io.IOException;
import org.luaj.vm2.lib.OsLib;

public class AndroidOsLib
extends OsLib {
    public static int EXEC_IOEXCEPTION = 1;
    public static int EXEC_INTERRUPTED = -2;
    public static int EXEC_ERROR = -3;

    @Override
    protected int execute(String command) {
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(command);
        try {
            p.waitFor();
            int n = p.exitValue();
            p.destroy();
            return n;
        }
        catch (Throwable throwable) {
            try {
                p.destroy();
                throw throwable;
            }
            catch (IOException ioe) {
                return EXEC_IOEXCEPTION;
            }
            catch (InterruptedException e) {
                return EXEC_INTERRUPTED;
            }
            catch (Throwable t) {
                return EXEC_ERROR;
            }
        }
    }

    @Override
    protected void remove(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    protected void rename(String oldname, String newname) throws IOException {
        File f = new File(oldname);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.renameTo(new File(newname))) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    protected String tmpname() {
        try {
            File f = File.createTempFile(TMP_PREFIX, TMP_SUFFIX);
            return f.getName();
        }
        catch (IOException ioe) {
            return super.tmpname();
        }
    }
}

