/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import com.e3roid.script.lua.LuajavaLib;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;

public class CoerceJavaToLua {
    static final Map<Class<?>, Coercion> COERCIONS = new HashMap();

    static {
        Coercion boolCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Boolean b = (Boolean)javaValue;
                return b != false ? LuaValue.TRUE : LuaValue.FALSE;
            }
        };
        Coercion intCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Number n = (Number)javaValue;
                return LuaInteger.valueOf(n.intValue());
            }
        };
        Coercion charCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Character c = (Character)javaValue;
                return LuaInteger.valueOf(c.charValue());
            }
        };
        Coercion doubleCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Number n = (Number)javaValue;
                return LuaDouble.valueOf(n.doubleValue());
            }
        };
        Coercion stringCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return LuaString.valueOf(javaValue.toString());
            }
        };
        COERCIONS.put(Boolean.class, boolCoercion);
        COERCIONS.put(Byte.class, intCoercion);
        COERCIONS.put(Character.class, charCoercion);
        COERCIONS.put(Short.class, intCoercion);
        COERCIONS.put(Integer.class, intCoercion);
        COERCIONS.put(Float.class, doubleCoercion);
        COERCIONS.put(Double.class, doubleCoercion);
        COERCIONS.put(String.class, stringCoercion);
    }

    public static LuaValue coerce(Object o) {
        if (o == null) {
            return LuaValue.NIL;
        }
        Class<?> clazz = o.getClass();
        Coercion c = COERCIONS.get(clazz);
        if (c != null) {
            return c.coerce(o);
        }
        return LuajavaLib.toUserdata(o, clazz);
    }

    public static interface Coercion {
        public LuaValue coerce(Object var1);
    }
}

