/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import com.e3roid.script.lua.LuajavaLib;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class CoerceLuaToJava {
    static final Map<Class<?>, Coercion> COERCIONS = new HashMap();

    static {
        Coercion boolCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return value.toboolean() ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case 0: 
                    case 1: {
                        return 0;
                    }
                    case -2: 
                    case 3: {
                        return 1;
                    }
                }
                return 4;
            }
        };
        Coercion byteCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Byte((byte)value.toint());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion charCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Character((char)value.toint());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion shortCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Short((short)value.toint());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion intCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Integer(value.toint());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                    case 0: 
                    case 1: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion longCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Long(value.tolong());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion floatCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Float(value.tofloat());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: 
                    case 3: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion doubleCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return new Double(value.todouble());
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case -2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return 4;
            }
        };
        Coercion stringCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                return value.tojstring();
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case 7: {
                        return 0;
                    }
                }
                return 1;
            }
        };
        Coercion objectCoercion = new Coercion(){

            @Override
            public Object coerce(LuaValue value) {
                switch (value.type()) {
                    case 7: {
                        return value.optuserdata(Object.class, null);
                    }
                    case 4: {
                        return value.tojstring();
                    }
                    case -2: {
                        return new Integer(value.toint());
                    }
                    case 3: {
                        return new Double(value.todouble());
                    }
                    case 1: {
                        return value.toboolean() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 0: {
                        return null;
                    }
                }
                return value;
            }

            @Override
            public int score(int paramType) {
                switch (paramType) {
                    case 4: {
                        return 0;
                    }
                }
                return 16;
            }
        };
        COERCIONS.put(Boolean.TYPE, boolCoercion);
        COERCIONS.put(Boolean.class, boolCoercion);
        COERCIONS.put(Byte.TYPE, byteCoercion);
        COERCIONS.put(Byte.class, byteCoercion);
        COERCIONS.put(Character.TYPE, charCoercion);
        COERCIONS.put(Character.class, charCoercion);
        COERCIONS.put(Short.TYPE, shortCoercion);
        COERCIONS.put(Short.class, shortCoercion);
        COERCIONS.put(Integer.TYPE, intCoercion);
        COERCIONS.put(Integer.class, intCoercion);
        COERCIONS.put(Long.TYPE, longCoercion);
        COERCIONS.put(Long.class, longCoercion);
        COERCIONS.put(Float.TYPE, floatCoercion);
        COERCIONS.put(Float.class, floatCoercion);
        COERCIONS.put(Double.TYPE, doubleCoercion);
        COERCIONS.put(Double.class, doubleCoercion);
        COERCIONS.put(String.class, stringCoercion);
        COERCIONS.put(Object.class, objectCoercion);
    }

    static int scoreParam(int paramType, Class<?> c) {
        if (paramType == 7 && !c.isArray()) {
            return 0;
        }
        Coercion co = COERCIONS.get(c);
        if (co != null) {
            int b = LuajavaLib.paramBaseTypeFromParamType(paramType);
            int d = LuajavaLib.paramDepthFromParamType(paramType);
            return co.score(b) * d;
        }
        if (c.isArray()) {
            Class<?> typ = c.getComponentType();
            int d = LuajavaLib.paramDepthFromParamType(paramType);
            if (d > 0) {
                return CoerceLuaToJava.scoreParam(LuajavaLib.paramComponentTypeOfParamType(paramType), typ);
            }
            return 16 + (CoerceLuaToJava.scoreParam(paramType, typ) << 8);
        }
        return 4096;
    }

    static Object coerceArg(LuaValue a, Class<?> c) {
        if (a.isuserdata(c)) {
            return a.touserdata(c);
        }
        Coercion co = COERCIONS.get(c);
        if (co != null) {
            return co.coerce(a);
        }
        if (c.isArray()) {
            boolean istable = a.istable();
            int n = istable ? a.length() : 1;
            Class<?> typ = c.getComponentType();
            Object arr = Array.newInstance(typ, n);
            int i = 0;
            while (i < n) {
                LuaValue ele;
                LuaValue luaValue = ele = istable ? a.checktable().get(i + 1) : a;
                if (ele != null) {
                    Array.set(arr, i, CoerceLuaToJava.coerceArg(ele, typ));
                }
                ++i;
            }
            return arr;
        }
        if (a.isnil()) {
            return null;
        }
        throw new LuaError("no coercion found for " + a.getClass() + " to " + c);
    }

    static Object[] coerceArgs(Varargs suppliedArgs, Class[] parameterTypes, boolean isvarargs) {
        int nsupplied = suppliedArgs.narg();
        int n = parameterTypes.length;
        int nplain = Math.min(isvarargs ? n - 1 : n, nsupplied);
        Object[] args = new Object[n];
        int i = 0;
        while (i < nplain) {
            args[i] = CoerceLuaToJava.coerceArg(suppliedArgs.arg(i + 1), parameterTypes[i]);
            ++i;
        }
        if (isvarargs) {
            int nvar = Math.max(0, nsupplied - nplain);
            Class<?> typevar = parameterTypes[n - 1].getComponentType();
            Object array = Array.newInstance(typevar, nvar);
            int index = 0;
            while (index < nvar) {
                Object value = CoerceLuaToJava.coerceArg(suppliedArgs.arg(nplain + index + 1), typevar);
                Array.set(array, index, value);
                ++index;
            }
            args[n - 1] = array;
        }
        return args;
    }

    static int scoreParamTypes(long paramssig, Class[] paramTypes) {
        int njava = paramTypes.length;
        int nargs = LuajavaLib.paramsCountFromSig(paramssig);
        int score = njava == nargs ? 0 : (njava > nargs ? 16384 : 32768);
        int i = 0;
        while (i < nargs && i < njava) {
            int paramType = LuajavaLib.paramTypeFromSig(paramssig, i);
            Class c = paramTypes[i];
            int s = CoerceLuaToJava.scoreParam(paramType, c);
            score += s;
            ++i;
        }
        return score;
    }

    public static interface Coercion {
        public Object coerce(LuaValue var1);

        public int score(int var1);
    }
}

