/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.e3roid.E3Activity;
import com.e3roid.E3Engine;
import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.BitmapTexture;
import com.e3roid.script.lua.LuaScriptEngine;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;
import org.luaj.vm2.LuaError;

public class LuaScriptCanvas
extends Sprite {
    private final LuaScriptEngine luaEngine;
    private final E3Activity context;
    private final boolean supportsOnLoadEngine;
    private Canvas canvas;
    private Bitmap bitmap;
    private BitmapTexture texture;
    private boolean sizeChanged = false;

    public LuaScriptCanvas(LuaScriptEngine engine, E3Activity context) {
        this(engine, 0, 0, context);
    }

    public LuaScriptCanvas(LuaScriptEngine engine, int x, int y, E3Activity context) {
        this(engine, x, y, context.getWidth(), context.getHeight(), context);
    }

    public LuaScriptCanvas(LuaScriptEngine engine, int x, int y, int width, int height, E3Activity context) {
        this.context = context;
        this.luaEngine = engine;
        this.supportsOnLoadEngine = engine.has("onLoadEngine");
        if (!engine.has("onDraw")) {
            throw new LuaError("function onDraw(GL10) must be defined in Lua script.");
        }
        this.setPosition(x, y);
        this.setSize(width, height);
        this.createTexture();
        this.createBuffers();
    }

    protected void createTexture() {
        if (this.sizeChanged) {
            this.bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.texture = new BitmapTexture(this.bitmap, this.getWidth(), this.getHeight(), (Context)this.context);
            this.texture.recycleBitmap(false);
            this.canvas = new Canvas(this.bitmap);
        } else {
            this.texture.setBitmap(this.bitmap);
        }
        this.updateTexture(this.texture);
    }

    @Override
    public void onLoadEngine(E3Engine engine) {
        if (this.supportsOnLoadEngine) {
            this.luaEngine.call("onLoadEngine", this, this.context);
        }
        super.onLoadEngine(engine);
    }

    @Override
    public void onDraw(GL10 gl) {
        if (((Boolean)this.luaEngine.call("onDraw", this, this.context)).booleanValue()) {
            this.createTexture();
            this.texture.loadTexture(gl, true);
            if (this.sizeChanged) {
                this.loadVertexBuffer((GL11)gl);
                this.loadTextureBuffer((GL11)gl);
                this.sizeChanged = false;
            }
        }
        super.onDraw(gl);
    }

    @Override
    public void onDispose() {
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.sizeChanged = true;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

