/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import android.content.Context;
import com.e3roid.script.ScriptEngine;
import com.e3roid.script.lua.AndroidPlatform;
import com.e3roid.script.lua.LuajavaLib;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaScriptEngine
implements ScriptEngine {
    private final LuaValue engineValue;

    public LuaScriptEngine(LuaValue luaValue) {
        this.engineValue = luaValue;
    }

    @Override
    public <T> T call(String name, Object ... args) {
        LuaValue[] argsValue = new LuaValue[args.length];
        int i = 0;
        while (i < args.length) {
            argsValue[i] = LuaScriptEngine.toLuaValue(args[i]);
            ++i;
        }
        LuaValue value = this.engineValue.get(name).invoke(argsValue).arg1();
        return LuaScriptEngine.inferValue(value);
    }

    public boolean has(String name) {
        return this.engineValue.get(name) != LuaValue.NIL;
    }

    public static <T> T inferValue(LuaValue value) {
        Object tValue = null;
        tValue = value.isint() ? Integer.valueOf(value.toint()) : (value.isnumber() ? Double.valueOf(value.todouble()) : (value.isboolean() ? Boolean.valueOf(value.toboolean()) : (value.isstring() ? value.tojstring() : (value.isuserdata() ? value.touserdata() : value))));
        return (T)tValue;
    }

    public static LuaValue toLuaValue(Object obj) {
        LuaValue argValue = null;
        argValue = obj.getClass() == String.class ? LuaValue.valueOf((String)obj) : (obj.getClass() == Boolean.class ? LuaValue.valueOf((Boolean)obj) : (obj.getClass() == Double.class ? LuaValue.valueOf((Double)obj) : (obj.getClass() == Integer.class ? LuaValue.valueOf((Integer)obj) : LuajavaLib.toUserdata(obj, obj.getClass()))));
        return argValue;
    }

    public static LuaScriptEngine loadFromAsset(String filename, Context context) {
        return LuaScriptEngine.load(filename, 0, context);
    }

    public static LuaScriptEngine loadFromData(String filename, Context context) {
        return LuaScriptEngine.load(filename, 1, context);
    }

    public static LuaScriptEngine load(String filename, int mode, Context context) {
        LuaTable luaValue = AndroidPlatform.standardGlobals(context, mode);
        luaValue.get("dofile").call(LuaValue.valueOf(filename));
        return new LuaScriptEngine(luaValue);
    }

    public static LuaScriptEngine loadForDebug(String filename, int mode, Context context) {
        LuaTable luaValue = AndroidPlatform.debugGlobals(context, mode);
        luaValue.get("dofile").call(LuaValue.valueOf(filename));
        return new LuaScriptEngine(luaValue);
    }

    public static LuaScriptEngine loadFromAssetForDebug(String filename, Context context) {
        return LuaScriptEngine.loadForDebug(filename, 0, context);
    }

    public static LuaScriptEngine loadFromDataForDebug(String filename, Context context) {
        return LuaScriptEngine.loadForDebug(filename, 1, context);
    }
}

