/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.script.lua;

import com.e3roid.script.lua.CoerceJavaToLua;
import com.e3roid.script.lua.CoerceLuaToJava;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class LuajavaLib
extends VarArgFunction {
    static final int INIT = 0;
    static final int BINDCLASS = 1;
    static final int NEWINSTANCE = 2;
    static final int NEW = 3;
    static final int CREATEPROXY = 4;
    static final int LOADLIB = 5;
    static final String[] NAMES = new String[]{"bindClass", "newInstance", "new", "createProxy", "loadLib"};
    static final Map<Class<?>, LuaTable> classMetatables = new HashMap();
    static final int METHOD_MODIFIERS_VARARGS = 128;
    static final LuaValue LENGTH = LuajavaLib.valueOf("length");
    static final Map<Class<?>, Map> consCache = new HashMap();
    static final Map<Class<?>, Constructor[]> consIndex = new HashMap();
    static final Map<Class<?>, Map> methCache = new HashMap();
    static final Map<Class<?>, Map> methIndex = new HashMap();

    @Override
    public Varargs invoke(Varargs args) {
        try {
            switch (this.opcode) {
                case 0: {
                    LuaTable t = new LuaTable();
                    this.bind(t, LuajavaLib.class, NAMES, 1);
                    this.env.set("luajava", (LuaValue)t);
                    PackageLib.instance.LOADED.set("luajava", (LuaValue)t);
                    return t;
                }
                case 1: {
                    Class<?> clazz = Class.forName(args.checkjstring(1));
                    return LuajavaLib.toUserdata(clazz, clazz);
                }
                case 2: 
                case 3: {
                    LuaValue c = args.checkvalue(1);
                    Class clazz = this.opcode == 2 ? Class.forName(c.tojstring()) : (Class)c.checkuserdata(Class.class);
                    Varargs consargs = args.subargs(2);
                    long paramssig = LuajavaLib.paramsSignatureOf(consargs);
                    Constructor<?> con = LuajavaLib.resolveConstructor(clazz, paramssig);
                    boolean isvarargs = (con.getModifiers() & 0x80) != 0;
                    Object[] cargs = CoerceLuaToJava.coerceArgs(consargs, con.getParameterTypes(), isvarargs);
                    Object o = con.newInstance(cargs);
                    return LuajavaLib.toUserdata(o, clazz);
                }
                case 4: {
                    int niface = args.narg() - 1;
                    if (niface <= 0) {
                        throw new LuaError("no interfaces");
                    }
                    final LuaTable lobj = args.checktable(niface + 1);
                    Class[] ifaces = new Class[niface];
                    int i = 0;
                    while (i < niface) {
                        ifaces[i] = Class.forName(args.checkjstring(i + 1));
                        ++i;
                    }
                    InvocationHandler handler = new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            LuaValue[] v;
                            int n;
                            String name = method.getName();
                            LuaValue func = lobj.get(name);
                            if (func.isnil()) {
                                return null;
                            }
                            boolean isvarargs = (method.getModifiers() & 0x80) != 0;
                            int n2 = n = args != null ? args.length : 0;
                            if (isvarargs) {
                                Object o = args[--n];
                                int m = Array.getLength(o);
                                v = new LuaValue[n + m];
                                int i = 0;
                                while (i < n) {
                                    v[i] = CoerceJavaToLua.coerce(args[i]);
                                    ++i;
                                }
                                i = 0;
                                while (i < m) {
                                    v[i + n] = CoerceJavaToLua.coerce(Array.get(o, i));
                                    ++i;
                                }
                            } else {
                                v = new LuaValue[n];
                                int i = 0;
                                while (i < n) {
                                    v[i] = CoerceJavaToLua.coerce(args[i]);
                                    ++i;
                                }
                            }
                            LuaValue result = func.invoke(v).arg1();
                            return CoerceLuaToJava.coerceArg(result, method.getReturnType());
                        }
                    };
                    Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces, handler);
                    return LuaValue.userdataOf(proxy);
                }
                case 5: {
                    String classname = args.checkjstring(1);
                    String methodname = args.checkjstring(2);
                    Class<?> clazz = Class.forName(classname);
                    Method method = clazz.getMethod(methodname, new Class[0]);
                    Object result = method.invoke(clazz, new Object[0]);
                    if (result instanceof LuaValue) {
                        return (LuaValue)result;
                    }
                    return NIL;
                }
            }
            throw new LuaError("not yet supported: " + this);
        }
        catch (LuaError e) {
            throw e;
        }
        catch (InvocationTargetException ite) {
            throw new LuaError(ite.getTargetException());
        }
        catch (Exception e) {
            throw new LuaError(e);
        }
    }

    public static long paramsSignatureOf(Varargs args) {
        long sig = 0L;
        int narg = args.narg();
        int n = Math.min(narg, 9);
        int i = 1;
        while (i <= n) {
            LuaValue a = args.arg(i);
            sig |= (long)(LuajavaLib.paramTypeOf(a) << i * 6);
            ++i;
        }
        return sig | (long)Math.min(narg, 63);
    }

    public static int paramTypeOf(LuaValue arg) {
        int type = arg.type();
        int tabledepth = 0;
        if (type == 5) {
            tabledepth = 1;
            while ((type = (arg = arg.get(1)).type()) == 5 && tabledepth < 3) {
                ++tabledepth;
            }
        }
        if (type == 3 && arg.isinttype()) {
            type = -2;
        }
        if (type == 7) {
            Class<?> c = arg.touserdata().getClass();
            while (c.isArray() && tabledepth < 3) {
                c = c.getComponentType();
                ++tabledepth;
            }
        }
        return type & 0xF | tabledepth << 4;
    }

    public static int paramsCountFromSig(long paramssig) {
        return (int)paramssig & 0x3F;
    }

    public static int paramTypeFromSig(long paramssig, int argindex) {
        return (int)(paramssig >> 6 * (argindex + 1)) & 0x3F;
    }

    public static int paramBaseTypeFromParamType(int paramType) {
        int t = paramType & 0xF;
        return t == 14 ? -2 : t;
    }

    public static int paramDepthFromParamType(int paramType) {
        return paramType >> 4 & 3;
    }

    public static int paramComponentTypeOfParamType(int paramType) {
        int b = LuajavaLib.paramBaseTypeFromParamType(paramType);
        int d = LuajavaLib.paramDepthFromParamType(paramType);
        d = d > 0 ? d - 1 : 0;
        return d << 4 | b & 0xF;
    }

    public static LuaUserdata toUserdata(Object instance, final Class<?> clazz) {
        LuaTable mt = classMetatables.get(clazz);
        if (mt == null) {
            mt = new LuaTable();
            mt.set(LuaValue.INDEX, (LuaValue)new TwoArgFunction(){
                private Map<?, ?> methods;

                @Override
                public LuaValue call(LuaValue table, LuaValue key) {
                    Object instance = table.touserdata();
                    if (key.isinttype() && clazz.isArray()) {
                        int index = key.toint() - 1;
                        if (index >= 0 && index < Array.getLength(instance)) {
                            return CoerceJavaToLua.coerce(Array.get(instance, index));
                        }
                        return NIL;
                    }
                    String s = key.tojstring();
                    try {
                        Field f = clazz.getField(s);
                        Object o = f.get(instance);
                        return CoerceJavaToLua.coerce(o);
                    }
                    catch (NoSuchFieldException nsfe) {
                        LMethod m;
                        if (clazz.isArray() && key.equals(LENGTH)) {
                            return LuaValue.valueOf(Array.getLength(instance));
                        }
                        if (this.methods == null) {
                            this.methods = new HashMap();
                        }
                        if ((m = (LMethod)this.methods.get(s)) == null) {
                            m = new LMethod(clazz, s);
                        }
                        return m;
                    }
                    catch (Exception e) {
                        throw new LuaError(e);
                    }
                }
            });
            mt.set(LuaValue.NEWINDEX, (LuaValue)new ThreeArgFunction(){

                @Override
                public LuaValue call(LuaValue table, LuaValue key, LuaValue val) {
                    Object instance = table.touserdata();
                    if (key.isinttype() && clazz.isArray()) {
                        Object v = CoerceLuaToJava.coerceArg(val, clazz.getComponentType());
                        int index = key.toint() - 1;
                        if (index < 0 || index >= Array.getLength(instance)) {
                            throw new LuaError("array bounds exceeded " + index);
                        }
                        Array.set(instance, index, v);
                        return NIL;
                    }
                    String s = key.tojstring();
                    try {
                        Field f = clazz.getField(s);
                        Object v = CoerceLuaToJava.coerceArg(val, f.getType());
                        f.set(table.checkuserdata(Object.class), v);
                    }
                    catch (Exception e) {
                        throw new LuaError(e);
                    }
                    return NONE;
                }
            });
            classMetatables.put(clazz, mt);
        }
        return LuaValue.userdataOf(instance, mt);
    }

    static Constructor<?> resolveConstructor(Class<?> clazz, long paramssig) {
        Constructor c;
        HashMap<Long, Constructor> cache = consCache.get(clazz);
        if (cache == null) {
            cache = new HashMap<Long, Constructor>();
            consCache.put(clazz, cache);
        }
        if ((c = (Constructor)cache.get(paramssig)) != null) {
            return c;
        }
        Constructor[] cons = consIndex.get(clazz);
        if (cons == null) {
            cons = clazz.getConstructors();
            consIndex.put(clazz, cons);
            if (cons == null) {
                throw new IllegalArgumentException("no public constructors");
            }
        }
        int bests = Integer.MAX_VALUE;
        int besti = 0;
        int i = 0;
        int size = cons.length;
        while (i < size) {
            Constructor con = cons[i];
            int s = CoerceLuaToJava.scoreParamTypes(paramssig, con.getParameterTypes());
            if (s < bests) {
                bests = s;
                besti = i;
            }
            ++i;
        }
        c = cons[besti];
        cache.put(paramssig, c);
        return c;
    }

    static Method resolveMethod(Class<?> clazz, String methodName, long paramssig) {
        List list;
        Method m;
        HashMap<Long, Method> cache;
        HashMap nameCache = methCache.get(clazz);
        if (nameCache == null) {
            nameCache = new HashMap();
            methCache.put(clazz, nameCache);
        }
        if ((cache = (HashMap<Long, Method>)nameCache.get(methodName)) == null) {
            cache = new HashMap<Long, Method>();
            nameCache.put(methodName, cache);
        }
        if ((m = (Method)cache.get(paramssig)) != null) {
            return m;
        }
        HashMap<String, ArrayList<Method>> index = methIndex.get(clazz);
        if (index == null) {
            index = new HashMap<String, ArrayList<Method>>();
            methIndex.put(clazz, index);
            Method[] meths = clazz.getMethods();
            int i = 0;
            while (i < meths.length) {
                Method meth = meths[i];
                String s = meth.getName();
                ArrayList<Method> list2 = (ArrayList<Method>)index.get(s);
                if (list2 == null) {
                    list2 = new ArrayList<Method>();
                    index.put(s, list2);
                }
                list2.add(meth);
                ++i;
            }
        }
        if ((list = (List)index.get(methodName)) == null) {
            throw new IllegalArgumentException("no method named '" + methodName + "'");
        }
        int bests = Integer.MAX_VALUE;
        int besti = 0;
        int i = 0;
        int size = list.size();
        while (i < size) {
            Method meth = (Method)list.get(i);
            int s = CoerceLuaToJava.scoreParamTypes(paramssig, meth.getParameterTypes());
            if (s < bests) {
                bests = s;
                besti = i;
            }
            ++i;
        }
        m = (Method)list.get(besti);
        cache.put(paramssig, m);
        return m;
    }

    static final class LMethod
    extends VarArgFunction {
        private final Class<?> clazz;
        private final String s;

        private LMethod(Class<?> clazz, String s) {
            this.clazz = clazz;
            this.s = s;
        }

        @Override
        public String tojstring() {
            return String.valueOf(this.clazz.getName()) + "." + this.s + "()";
        }

        @Override
        public Varargs invoke(Varargs args) {
            try {
                Object instance = args.touserdata(1);
                Varargs methargs = args.subargs(2);
                long paramssig = LuajavaLib.paramsSignatureOf(methargs);
                Method meth = LuajavaLib.resolveMethod(this.clazz, this.s, paramssig);
                boolean isvarargs = (meth.getModifiers() & 0x80) != 0;
                Object[] margs = CoerceLuaToJava.coerceArgs(methargs, meth.getParameterTypes(), isvarargs);
                Object result = meth.invoke(instance, margs);
                return CoerceJavaToLua.coerce(result);
            }
            catch (InvocationTargetException ite) {
                throw new LuaError(ite.getTargetException());
            }
            catch (Exception e) {
                throw new LuaError(e);
            }
        }
    }
}

