/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import com.e3roid.util.Debug;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapUtil {
    public static Bitmap getBitmapFromAsset(String name, Context context) {
        Bitmap bitmap;
        block12: {
            InputStream is = null;
            bitmap = null;
            BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
            bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
            try {
                try {
                    is = name.startsWith("/") ? new FileInputStream(name) : context.getAssets().open(name);
                    bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)bitmapOptions);
                }
                catch (Exception e) {
                    Debug.e("Failed to load bitmap " + name, e);
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromResource(int resourceID, int width, int height, Context context) {
        Drawable drawable = context.getResources().getDrawable(resourceID);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap getTileBitmapFromAsset(String assetName, int tileWidth, int tileHeight, int xindex, int yindex, int border, Context context) {
        return BitmapUtil.getTileBitmap(BitmapUtil.getBitmapFromAsset(assetName, context), tileWidth, tileHeight, xindex, yindex, border, context);
    }

    public static Bitmap getTileBitmap(Bitmap bitmap, int tileWidth, int tileHeight, int xindex, int yindex, int border, Context context) {
        int xstart = border + (tileWidth + border) * xindex;
        int ystart = border + (tileHeight + border) * yindex;
        return Bitmap.createBitmap((Bitmap)bitmap, (int)xstart, (int)ystart, (int)tileWidth, (int)tileHeight);
    }
}

