/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.util;

import android.util.Log;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.connectbot.transport.StreamTransport;

public class Debug {
    public static final String ENGINE_TAG = "E3roid";
    public static Level level = Level.DEBUG;
    private static PipedOutputStream outputStream;
    private static StreamTransport streamTransport;

    public static void setLevel(Level l) {
        level = l;
    }

    public static void v(String message) {
        Debug.v(message, null);
    }

    public static void v(String message, boolean writeOut) {
        Debug.v(message, null, writeOut);
    }

    public static void v(String message, Throwable th) {
        Debug.v(message, th, true);
    }

    public static void v(String message, Throwable th, boolean writeOut) {
        if (Debug.level.lessThanOrEqualTo(Level.VERBOSE)) {
            Log.v((String)ENGINE_TAG, (String)message, (Throwable)th);
            if (writeOut) {
                Debug.writeOut(message, th);
            }
        }
    }

    public static void d(String message) {
        Debug.d(message, null);
    }

    public static void d(String message, boolean writeOut) {
        Debug.d(message, null, writeOut);
    }

    public static void d(String message, Throwable th) {
        Debug.d(message, th, true);
    }

    public static void d(String message, Throwable th, boolean writeOut) {
        if (Debug.level.lessThanOrEqualTo(Level.DEBUG)) {
            Log.d((String)ENGINE_TAG, (String)message, (Throwable)th);
            if (writeOut) {
                Debug.writeOut(message, th);
            }
        }
    }

    public static void i(String message) {
        Debug.i(message, null);
    }

    public static void i(String message, boolean writeOut) {
        Debug.i(message, null, writeOut);
    }

    public static void i(String message, Throwable th) {
        Debug.i(message, th, true);
    }

    public static void i(String message, Throwable th, boolean writeOut) {
        if (Debug.level.lessThanOrEqualTo(Level.INFO)) {
            Log.i((String)ENGINE_TAG, (String)message, (Throwable)th);
            if (writeOut) {
                Debug.writeOut(message, th);
            }
        }
    }

    public static void w(String message) {
        Debug.w(message, null);
    }

    public static void w(String message, boolean writeOut) {
        Debug.w(message, null, writeOut);
    }

    public static void w(String message, Throwable th) {
        Debug.w(message, th, true);
    }

    public static void w(String message, Throwable th, boolean writeOut) {
        if (Debug.level.lessThanOrEqualTo(Level.WARNING)) {
            Log.w((String)ENGINE_TAG, (String)message, (Throwable)th);
            if (writeOut) {
                Debug.writeOut(message, th);
            }
        }
    }

    public static void e(String message) {
        Debug.e(message, null);
    }

    public static void e(String message, boolean writeOut) {
        Debug.e(message, null, writeOut);
    }

    public static void e(Throwable th) {
        Debug.e(th.getClass().getName(), th);
    }

    public static void e(Throwable th, boolean writeOut) {
        Debug.e(th.getClass().getName(), th, writeOut);
    }

    public static void e(String message, Throwable th) {
        Debug.e(message, th, true);
    }

    public static void e(String message, Throwable th, boolean writeOut) {
        if (Debug.level.lessThanOrEqualTo(Level.ERROR)) {
            Log.e((String)ENGINE_TAG, (String)message, (Throwable)th);
            if (writeOut) {
                Debug.writeOut(message, th);
            }
        }
    }

    public static String getStackTraceString(Throwable th) {
        if (th == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        return sw.toString().replace("\n", "\r\n");
    }

    public static void writeOut(String message, Throwable th) {
        if (outputStream != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(message);
            buffer.append("\r\n");
            buffer.append(Debug.getStackTraceString(th));
            try {
                outputStream.write(buffer.toString().getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static StreamTransport connect() throws IOException {
        if (streamTransport != null) {
            return streamTransport;
        }
        if (outputStream == null) {
            outputStream = new PipedOutputStream();
        }
        streamTransport = new StreamTransport(new PipedInputStream(outputStream), null);
        return streamTransport;
    }

    public static void disconnect() {
        if (streamTransport != null) {
            streamTransport.close();
        }
        streamTransport = null;
        outputStream = null;
    }

    public static enum Level {
        NONE,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        VERBOSE;


        private boolean lessThanOrEqualTo(Level level) {
            return this.compareTo(level) >= 0;
        }
    }
}

