/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.util;

import android.os.SystemClock;
import com.e3roid.lifecycle.E3LifeCycle;
import com.e3roid.util.FPSListener;
import java.util.ArrayList;

public class FPSCounter
implements E3LifeCycle {
    public static final int DURATION_MSEC_DEFAULT = 5000;
    private int duration = 5000;
    private int frames = 0;
    private long lastTimeMillis = SystemClock.uptimeMillis();
    private boolean paused = false;
    private float currentFPS = 0.0f;
    private float minFPS = Float.MAX_VALUE;
    private float maxFPS = Float.MIN_VALUE;
    private ArrayList<FPSListener> listeners = new ArrayList();

    public FPSCounter() {
    }

    public FPSCounter(int duration) {
        this.setDurationMsec(duration);
    }

    public float getFPS() {
        return this.currentFPS;
    }

    public void setDurationMsec(int msec) {
        this.duration = msec;
    }

    public void onFrame() {
        if (this.paused) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        ++this.frames;
        long elapsedMillis = now - this.lastTimeMillis;
        this.currentFPS = (float)this.frames * 1000.0f / (float)elapsedMillis;
        if (elapsedMillis >= (long)this.duration) {
            this.minFPS = Math.min(this.minFPS, this.currentFPS);
            this.maxFPS = Math.max(this.maxFPS, this.currentFPS);
            this.invokeListeners(this.currentFPS, this.minFPS, this.maxFPS);
            this.lastTimeMillis = now;
            this.frames = 0;
        }
    }

    private void invokeListeners(float fps, float min, float max) {
        for (FPSListener listener : this.listeners) {
            listener.onFPS(fps, min, max);
        }
    }

    public int getFrameCount() {
        return this.frames;
    }

    public void addListener(FPSListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void onPause() {
        this.paused = true;
    }

    @Override
    public void onResume() {
        this.resetCount();
    }

    @Override
    public void onDispose() {
        this.resetCount();
    }

    public void resetCount() {
        this.paused = false;
        this.lastTimeMillis = SystemClock.uptimeMillis();
        this.frames = 0;
        this.minFPS = 2.1474836E9f;
        this.maxFPS = -2.1474836E9f;
        this.currentFPS = 0.0f;
    }
}

