/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.service;

import android.os.Handler;
import android.os.Message;
import java.util.concurrent.Semaphore;

public class PromptHelper {
    private final Object tag;
    private Handler handler = null;
    private Semaphore promptToken;
    private Semaphore promptResponse;
    public String promptInstructions = null;
    public String promptHint = null;
    public Object promptRequested = null;
    private Object response = null;

    public PromptHelper(Object tag) {
        this.tag = tag;
        this.promptToken = new Semaphore(1);
        this.promptResponse = new Semaphore(0);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setResponse(Object value) {
        this.response = value;
        this.promptRequested = null;
        this.promptInstructions = null;
        this.promptHint = null;
        this.promptResponse.release();
    }

    protected Object popResponse() {
        Object value = this.response;
        this.response = null;
        return value;
    }

    private Object requestPrompt(String instructions, String hint, Object type) throws InterruptedException {
        Object response = null;
        this.promptToken.acquire();
        try {
            this.promptInstructions = instructions;
            this.promptHint = hint;
            this.promptRequested = type;
            if (this.handler != null) {
                Message.obtain((Handler)this.handler, (int)-1, (Object)this.tag).sendToTarget();
            }
            this.promptResponse.acquire();
            response = this.popResponse();
        }
        finally {
            this.promptToken.release();
        }
        return response;
    }

    public String requestStringPrompt(String instructions, String hint) {
        String value = null;
        try {
            value = (String)this.requestPrompt(instructions, hint, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public Boolean requestBooleanPrompt(String instructions, String hint) {
        Boolean value = null;
        try {
            value = (Boolean)this.requestPrompt(instructions, hint, Boolean.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void cancelPrompt() {
        if (!this.promptToken.tryAcquire()) {
            this.response = null;
            this.promptResponse.release();
        } else {
            this.promptToken.release();
        }
    }
}

