/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.service;

import com.e3roid.util.Debug;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.harmony.niochar.charset.additional.IBM437;
import org.connectbot.service.TerminalBridge;
import org.connectbot.service.TerminalBuffer;
import org.connectbot.transport.AbsTransport;

public class Relay
implements Runnable {
    private static final int BUFFER_SIZE = 4096;
    private static boolean useJNI = false;
    private TerminalBridge bridge;
    private Charset currentCharset;
    private CharsetDecoder decoder;
    private AbsTransport transport;
    private TerminalBuffer buffer;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private byte[] byteArray;
    private char[] charArray;
    private boolean started = false;

    public Relay(TerminalBridge bridge, AbsTransport transport, TerminalBuffer buffer, String encoding) {
        this.setCharset(encoding);
        this.bridge = bridge;
        this.transport = transport;
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharset(String encoding) {
        Debug.d("changing charset to " + encoding, false);
        Charset charset = encoding.equals("CP437") ? new IBM437("IBM437", new String[]{"IBM437", "CP437"}) : Charset.forName(encoding);
        if (charset == this.currentCharset || charset == null) {
            return;
        }
        CharsetDecoder newCd = charset.newDecoder();
        newCd.onUnmappableCharacter(CodingErrorAction.REPLACE);
        newCd.onMalformedInput(CodingErrorAction.REPLACE);
        this.currentCharset = charset;
        Relay relay = this;
        synchronized (relay) {
            this.decoder = newCd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.started = true;
        this.byteBuffer = ByteBuffer.allocate(4096);
        this.charBuffer = CharBuffer.allocate(4096);
        boolean[] wideAttribute = new boolean[4096];
        float[] widths = new float[4096];
        this.byteArray = this.byteBuffer.array();
        this.charArray = this.charBuffer.array();
        int bytesRead = 0;
        this.byteBuffer.limit(0);
        try {
            while (this.started) {
                CoderResult result;
                int charWidth = this.bridge.charWidth;
                int bytesToRead = this.byteBuffer.capacity() - this.byteBuffer.limit();
                int offset = this.byteBuffer.arrayOffset() + this.byteBuffer.limit();
                bytesRead = this.transport.read(this.byteArray, offset, bytesToRead);
                if (bytesRead <= 0) continue;
                this.byteBuffer.limit(this.byteBuffer.limit() + bytesRead);
                Relay relay = this;
                synchronized (relay) {
                    result = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
                }
                if (result.isUnderflow() && this.byteBuffer.limit() == this.byteBuffer.capacity()) {
                    this.byteBuffer.compact();
                    this.byteBuffer.limit(this.byteBuffer.position());
                    this.byteBuffer.position(0);
                }
                offset = this.charBuffer.position();
                if (!useJNI) {
                    this.bridge.getPaint().getTextWidths(this.charArray, 0, offset, widths);
                    int i = 0;
                    while (i < offset) {
                        wideAttribute[i] = (int)widths[i] != charWidth;
                        ++i;
                    }
                }
                this.buffer.putString(this.charArray, wideAttribute, 0, this.charBuffer.position());
                this.charBuffer.clear();
                this.bridge.redraw();
            }
        }
        catch (IOException e) {
            Debug.d("Relay stopped", false);
        }
    }

    public void stop() {
        this.started = false;
    }
}

