/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.service;

import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.ClipboardManager;
import com.e3roid.util.Debug;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.connectbot.TerminalContainer;
import org.connectbot.service.FontSizeChangedListener;
import org.connectbot.service.PromptHelper;
import org.connectbot.service.Relay;
import org.connectbot.service.TerminalBuffer;
import org.connectbot.service.TerminalKeyListener;
import org.connectbot.service.TerminalManager;
import org.connectbot.transport.AbsTransport;
import org.connectbot.util.Colors;
import org.connectbot.util.SelectionArea;

public class TerminalBridge
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final int FONT_SIZE_STEP = 2;
    private final int[] color = new int[Colors.defaults.length];
    private final TerminalManager manager;
    private int mDefaultFgColor;
    private int mDefaultBgColor;
    private String encoding;
    private AbsTransport transport;
    private final Paint defaultPaint;
    private Relay relay;
    private Thread relayThread;
    private Bitmap bitmap = null;
    private final TerminalBuffer buffer;
    private TerminalContainer parent = null;
    private final Canvas canvas = new Canvas();
    private boolean forcedSize = false;
    private int columns;
    private int rows;
    private final TerminalKeyListener keyListener;
    private boolean selectingForCopy = false;
    private final SelectionArea selectionArea;
    private ClipboardManager clipboard;
    public int charWidth = -1;
    public int charHeight = -1;
    private int charTop = -1;
    private float fontSize = -1.0f;
    private int id;
    private final List<FontSizeChangedListener> fontSizeChangedListeners;
    private boolean fullRedraw = false;
    private final PromptHelper promptHelper;

    public TerminalBridge() {
        this.buffer = new TerminalBuffer(){

            @Override
            public void write(byte[] b) {
            }

            @Override
            public void write(int b) {
            }

            @Override
            public void debug(String s) {
            }
        };
        this.manager = null;
        this.defaultPaint = new Paint();
        this.selectionArea = new SelectionArea();
        this.fontSizeChangedListeners = new LinkedList<FontSizeChangedListener>();
        this.transport = null;
        this.keyListener = new TerminalKeyListener(this.manager, this, this.buffer, null);
        this.mDefaultFgColor = 0;
        this.mDefaultBgColor = 0;
        this.promptHelper = null;
        this.updateCharset();
    }

    public TerminalBridge(TerminalManager manager, AbsTransport t, int id) throws IOException {
        this.id = id;
        this.manager = manager;
        this.transport = t;
        String string = manager.getStringParameter("terminal_fontsize", null);
        this.fontSize = string != null ? Float.parseFloat(string) : 10.0f;
        this.mDefaultFgColor = manager.getIntParameter("terminal_color_fg", -3355444);
        this.mDefaultBgColor = manager.getIntParameter("terminal_color_bg", -16777216);
        this.promptHelper = new PromptHelper(this);
        this.defaultPaint = new Paint();
        this.defaultPaint.setAntiAlias(true);
        this.defaultPaint.setTypeface(Typeface.MONOSPACE);
        this.defaultPaint.setFakeBoldText(true);
        this.fontSizeChangedListeners = new LinkedList<FontSizeChangedListener>();
        this.setFontSize(this.fontSize);
        this.buffer = new TerminalBuffer(){

            @Override
            public void debug(String s) {
                Debug.d(s, false);
            }

            @Override
            public void write(byte[] b) {
                try {
                    if (b != null && TerminalBridge.this.transport != null) {
                        TerminalBridge.this.transport.write(b);
                    }
                }
                catch (IOException e) {
                    Debug.e("Problem writing outgoing data in Terminal thread", e, false);
                }
            }

            @Override
            public void write(int b) {
                try {
                    if (TerminalBridge.this.transport != null) {
                        TerminalBridge.this.transport.write(b);
                    }
                }
                catch (IOException e) {
                    Debug.e("Problem writing outgoing data in Terminal thread", e, false);
                }
            }
        };
        this.resetColors();
        this.selectionArea = new SelectionArea();
        this.keyListener = new TerminalKeyListener(manager, this, this.buffer, this.encoding);
        this.updateCharset();
        manager.registerOnSharedPreferenceChangeListener(this);
    }

    protected void connect() {
        this.transport.setBridge(this);
        this.transport.setManager(this.manager);
        this.transport.connect();
        this.buffer.reset();
        this.relay = new Relay(this, this.transport, this.buffer, this.encoding);
        this.relayThread = new Thread(this.relay);
        this.relayThread.setDaemon(true);
        this.relayThread.setName("Relay");
        this.relayThread.start();
        this.setFontSize(this.fontSize);
    }

    private void updateCharset() {
        this.encoding = this.manager.getStringParameter("terminal_encoding", Charset.defaultCharset().name());
        if (this.relay != null) {
            this.relay.setCharset(this.encoding);
        }
        this.keyListener.setCharset(this.encoding);
    }

    public void injectString(final String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Thread injectStringThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TerminalBridge.this.transport.write(string.getBytes(TerminalBridge.this.encoding));
                }
                catch (Exception e) {
                    Debug.e("Couldn't inject string to remote host: ", e, false);
                }
            }
        });
        injectStringThread.setName("InjectString");
        injectStringThread.start();
    }

    public boolean isSessionOpen() {
        if (this.transport != null) {
            return this.transport.isSessionOpen();
        }
        return false;
    }

    public void dispatchDisconnect(boolean immediate) {
        this.relay.stop();
        if (this.relayThread != null && this.relayThread.isAlive()) {
            this.relayThread.interrupt();
        }
        if (immediate) {
            this.manager.closeConnection(this, true);
        } else if (this.transport != null && this.transport.isConnected()) {
            this.manager.closeConnection(this, true);
        } else {
            this.manager.closeConnection(this, false);
        }
    }

    public void setSelectingForCopy(boolean selectingForCopy) {
        this.selectingForCopy = selectingForCopy;
    }

    public boolean isSelectingForCopy() {
        return this.selectingForCopy;
    }

    public SelectionArea getSelectionArea() {
        return this.selectionArea;
    }

    final void setFontSize(float size) {
        if ((double)size <= 0.0) {
            return;
        }
        this.defaultPaint.setTextSize(size);
        this.fontSize = size;
        Paint.FontMetrics fm = this.defaultPaint.getFontMetrics();
        this.charTop = (int)Math.ceil(fm.top);
        float[] widths = new float[1];
        this.defaultPaint.getTextWidths("X", widths);
        this.charWidth = (int)Math.ceil(widths[0]);
        this.charHeight = (int)Math.ceil(fm.descent - fm.top);
        if (this.parent != null) {
            this.parentChanged(this.parent);
        }
        for (FontSizeChangedListener ofscl : this.fontSizeChangedListeners) {
            ofscl.onFontSizeChanged(size);
        }
        this.forcedSize = false;
    }

    public void addFontSizeChangedListener(FontSizeChangedListener listener) {
        this.fontSizeChangedListeners.add(listener);
    }

    public void removeFontSizeChangedListener(FontSizeChangedListener listener) {
        this.fontSizeChangedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void parentChanged(TerminalContainer parent) {
        boolean newBitmap;
        if (this.manager != null && !this.manager.isResizeAllowed()) {
            Debug.d("Resize is not allowed now", false);
            return;
        }
        this.parent = parent;
        int width = parent.getWidth();
        int height = parent.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        this.clipboard = (ClipboardManager)parent.getContext().getSystemService("clipboard");
        this.keyListener.setClipboardManager(this.clipboard);
        if (!this.forcedSize) {
            int newColumns = width / this.charWidth;
            int newRows = height / this.charHeight;
            if (newColumns == this.columns && newRows == this.rows) {
                return;
            }
            this.columns = newColumns;
            this.rows = newRows;
        }
        boolean bl = newBitmap = this.bitmap == null;
        if (this.bitmap != null) {
            boolean bl2 = newBitmap = this.bitmap.getWidth() != width || this.bitmap.getHeight() != height;
        }
        if (newBitmap) {
            this.discardBitmap();
            this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas.setBitmap(this.bitmap);
        }
        this.defaultPaint.setColor(-16777216);
        this.canvas.drawPaint(this.defaultPaint);
        if (this.forcedSize) {
            int borderX = this.columns * this.charWidth + 1;
            int borderY = this.rows * this.charHeight + 1;
            this.defaultPaint.setColor(-7829368);
            this.defaultPaint.setStrokeWidth(0.0f);
            if (width >= borderX) {
                this.canvas.drawLine((float)borderX, 0.0f, (float)borderX, (float)(borderY + 1), this.defaultPaint);
            }
            if (height >= borderY) {
                this.canvas.drawLine(0.0f, (float)borderY, (float)(borderX + 1), (float)borderY, this.defaultPaint);
            }
        }
        try {
            TerminalBuffer borderX = this.buffer;
            synchronized (borderX) {
                this.buffer.setScreenSize(this.columns, this.rows);
            }
            if (this.transport != null) {
                this.transport.setDimensions(this.columns, this.rows, width, height);
            }
        }
        catch (Exception e) {
            Debug.e("Problem while trying to resize screen or PTY", e, false);
        }
        this.fullRedraw = true;
        this.redraw();
        Debug.i(String.format("parentChanged() now width=%d, height=%d", this.columns, this.rows), false);
    }

    public synchronized void parentDestroyed() {
        this.parent = null;
        this.discardBitmap();
    }

    private void discardBitmap() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
        this.bitmap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onDraw() {
        TerminalBuffer terminalBuffer = this.buffer;
        synchronized (terminalBuffer) {
            block6: {
                if (this.buffer.isUpdated() || this.fullRedraw) break block6;
                return false;
            }
            this.defaultPaint.setColor(this.mDefaultBgColor);
            this.canvas.drawPaint(this.defaultPaint);
            int l = 0;
            while (l < this.buffer.getHeight()) {
                if (this.buffer.isUpdated(l)) {
                    this.defaultPaint.setColor(this.mDefaultFgColor);
                    char[] charToDraw = this.buffer.getCharAt(l);
                    this.canvas.drawText(charToDraw, 0, charToDraw.length, 0.0f, (float)(l * this.charHeight - this.charTop), this.defaultPaint);
                }
                ++l;
            }
            this.buffer.setUpdated(false);
        }
        this.fullRedraw = false;
        return true;
    }

    public void redraw() {
        if (this.parent != null) {
            this.parent.postInvalidate();
        }
    }

    public synchronized void resizeComputed(int cols, int rows, int width, int height) {
        int direction;
        float size = 8.0f;
        float step = 8.0f;
        float limit = 0.125f;
        while ((direction = this.fontSizeCompare(size, cols, rows, width, height)) < 0) {
            size += step;
        }
        if (direction == 0) {
            Debug.d(String.format("Fontsize: found match at %f", Float.valueOf(size)), false);
            return;
        }
        size -= (step /= 2.0f);
        while ((direction = this.fontSizeCompare(size, cols, rows, width, height)) != 0 && step >= limit) {
            step /= 2.0f;
            if (direction > 0) {
                size -= step;
                continue;
            }
            size += step;
        }
        if (direction > 0) {
            size -= step;
        }
        this.columns = cols;
        this.rows = rows;
        this.setFontSize(size);
        this.forcedSize = true;
    }

    private int fontSizeCompare(float size, int cols, int rows, int width, int height) {
        this.defaultPaint.setTextSize(size);
        Paint.FontMetrics fm = this.defaultPaint.getFontMetrics();
        float[] widths = new float[1];
        this.defaultPaint.getTextWidths("X", widths);
        int termWidth = (int)widths[0] * cols;
        int termHeight = (int)Math.ceil(fm.descent - fm.top) * rows;
        Debug.d(String.format("Fontsize: font size %f resulted in %d x %d", Float.valueOf(size), termWidth, termHeight), false);
        if (termWidth > width || termHeight > height) {
            return 1;
        }
        if (termWidth == width || termHeight == height) {
            return 0;
        }
        return -1;
    }

    public void setColor(int index, int red, int green, int blue) {
        if (index < this.color.length && index >= 16) {
            this.color[index] = 0xFF000000 | red << 16 | green << 8 | blue;
        }
    }

    public final void resetColors() {
        System.arraycopy(Colors.defaults, 0, this.color, 0, Colors.defaults.length);
    }

    public TerminalKeyListener getKeyHandler() {
        return this.keyListener;
    }

    public void increaseFontSize() {
        this.setFontSize(this.fontSize + 2.0f);
    }

    public void decreaseFontSize() {
        this.setFontSize(this.fontSize - 2.0f);
    }

    public int getForegroundColor() {
        return this.mDefaultFgColor;
    }

    public int getBackgroundColor() {
        return this.mDefaultBgColor;
    }

    public TerminalBuffer getVDUBuffer() {
        return this.buffer;
    }

    public PromptHelper getPromptHelper() {
        return this.promptHelper;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public AbsTransport getTransport() {
        return this.transport;
    }

    public Paint getPaint() {
        return this.defaultPaint;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if ("terminal_encoding".equals(key)) {
            this.updateCharset();
        } else if ("terminal_fontsize".equals(key)) {
            String string = this.manager.getStringParameter("terminal_fontsize", null);
            this.fontSize = string != null ? Float.parseFloat(string) : 10.0f;
            this.setFontSize(this.fontSize);
            this.fullRedraw = true;
        } else if ("terminal_color_fg".equals(key)) {
            this.mDefaultFgColor = this.manager.getIntParameter("terminal_color_fg", -3355444);
            this.fullRedraw = true;
        } else if ("terminal_color_bg".equals(key)) {
            this.mDefaultBgColor = this.manager.getIntParameter("terminal_color_bg", -16777216);
            this.fullRedraw = true;
        }
    }

    public void setCharset(String encoding) {
        if (this.relay != null) {
            this.relay.setCharset(encoding);
        }
        this.keyListener.setCharset(encoding);
    }

    public void setFontSize(int size) {
        this.fontSize = size;
    }

    public void setBgColor(int color) {
        this.mDefaultBgColor = color;
    }

    public void setFgColor(int color) {
        this.mDefaultFgColor = color;
    }

    public int getId() {
        return this.id;
    }
}

