/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.service;

import java.util.LinkedList;

public abstract class TerminalBuffer {
    public static final int KEY_PAUSE = 1;
    public static final int KEY_F1 = 2;
    public static final int KEY_F2 = 3;
    public static final int KEY_F3 = 4;
    public static final int KEY_F4 = 5;
    public static final int KEY_F5 = 6;
    public static final int KEY_F6 = 7;
    public static final int KEY_F7 = 8;
    public static final int KEY_F8 = 9;
    public static final int KEY_F9 = 10;
    public static final int KEY_F10 = 11;
    public static final int KEY_F11 = 12;
    public static final int KEY_F12 = 13;
    public static final int KEY_UP = 14;
    public static final int KEY_DOWN = 15;
    public static final int KEY_LEFT = 16;
    public static final int KEY_RIGHT = 17;
    public static final int KEY_PAGE_DOWN = 18;
    public static final int KEY_PAGE_UP = 19;
    public static final int KEY_INSERT = 20;
    public static final int KEY_DELETE = 21;
    public static final int KEY_BACK_SPACE = 22;
    public static final int KEY_HOME = 23;
    public static final int KEY_END = 24;
    public static final int KEY_NUM_LOCK = 25;
    public static final int KEY_CAPS_LOCK = 26;
    public static final int KEY_SHIFT = 27;
    public static final int KEY_CONTROL = 28;
    public static final int KEY_ALT = 29;
    public static final int KEY_ENTER = 30;
    public static final int KEY_NUMPAD0 = 31;
    public static final int KEY_NUMPAD1 = 32;
    public static final int KEY_NUMPAD2 = 33;
    public static final int KEY_NUMPAD3 = 34;
    public static final int KEY_NUMPAD4 = 35;
    public static final int KEY_NUMPAD5 = 36;
    public static final int KEY_NUMPAD6 = 37;
    public static final int KEY_NUMPAD7 = 38;
    public static final int KEY_NUMPAD8 = 39;
    public static final int KEY_NUMPAD9 = 40;
    public static final int KEY_DECIMAL = 41;
    public static final int KEY_ADD = 42;
    public static final int KEY_ESCAPE = 43;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int INVERT = 4;
    public static final int LOW = 8;
    public static final int INVISIBLE = 16;
    public static final int FULLWIDTH = 0x8000000;
    public static final int DELETE_IS_DEL = 0;
    public static final int DELETE_IS_BACKSPACE = 1;
    public static final int COLOR_FG_SHIFT = 5;
    public static final int COLOR_BG_SHIFT = 14;
    public static final int COLOR = 8388576;
    public static final int COLOR_FG = 16352;
    public static final int COLOR_BG = 8372224;
    public static final int DEFAULT_TAB_STOP = 4;
    private int width;
    private int height;
    private int tabStop = 4;
    private boolean updated = false;
    private LinkedList<TerminalLine> lines = new LinkedList();

    public TerminalBuffer() {
        this(80, 24);
    }

    public TerminalBuffer(int width, int height) {
        this.setScreenSize(width, height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setScreenSize(int width, int height) {
        int h = this.lines.size() - height;
        if (h > 0) {
            int i = 0;
            while (i < h) {
                this.lines.removeFirst();
                ++i;
            }
        }
        this.width = width;
        this.height = height;
    }

    public void putString(String str) {
        this.putString(str.toCharArray());
    }

    public void putString(char[] chars) {
        this.putString(chars, null, 0, chars.length);
    }

    /*
     * Unable to fully structure code
     */
    public void putString(char[] chars, boolean[] fullWidth, int start, int length) {
        count = 0;
        if (this.lines.size() == 0) {
            this.lines.add(new TerminalLine(this.width));
        } else {
            count = this.lines.getLast().getColumn();
        }
        lastChar = '\u0000';
        i = start;
        while (i < length) {
            block11: {
                c = chars[i];
                if (c == '\u0000') break;
                if (count >= this.width) {
                    this.lines.add(new TerminalLine(this.width));
                    count = 0;
                }
                lastChar = c;
                isWide = false;
                if (fullWidth == null || !fullWidth[i]) break block11;
                isWide = true;
                ++count;
                ** GOTO lbl-1000
            }
            switch (c) {
                case '\r': {
                    break;
                }
                case '\n': {
                    count = this.width + 1;
                    break;
                }
                case '\t': {
                    j = 0;
                    while (j < this.tabStop) {
                        this.putChar(' ', false, this.lines.getLast());
                        ++count;
                        ++j;
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.putChar(c, isWide, this.lines.getLast());
                    ++count;
                }
            }
            ++i;
        }
        if (lastChar == '\n') {
            this.lines.add(new TerminalLine(this.width));
        }
        this.scrollLine();
        this.updated = true;
    }

    protected void addNewLine() {
        this.lines.add(new TerminalLine(this.width));
        this.scrollLine();
        this.updated = true;
    }

    protected void scrollLine() {
        if (this.lines.size() > this.height) {
            int rows = this.lines.size() - this.height;
            int i = 0;
            while (i < rows) {
                this.lines.removeFirst();
                ++i;
            }
        }
    }

    public TerminalLine putChar(char c, boolean isWide, TerminalLine line) {
        if (isWide) {
            line.addChar(c, 0x8000000);
        } else {
            line.addChar(c);
        }
        return line;
    }

    public TerminalLine deleteChar() {
        TerminalLine line = this.lines.getLast();
        line.deleteChar();
        this.updated = true;
        return line;
    }

    public char[] getCharAt(int row) {
        if (row >= this.lines.size()) {
            return new char[0];
        }
        return this.lines.get(row).getChars();
    }

    public char getCharAt(int row, int column) {
        if (row >= this.lines.size()) {
            return ' ';
        }
        return this.lines.get(row).getCharAt(column);
    }

    public int getAttributeAt(int row, int column) {
        if (row >= this.lines.size()) {
            return 0;
        }
        return this.lines.get(row).getAttributeAt(column);
    }

    public String getString(int row) {
        if (row >= this.lines.size()) {
            return "";
        }
        return this.lines.get(row).getString();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isUpdated(int row) {
        return this.lines.size() > row;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public void keyTyped(int keyCode, char keyChar, int modifiers) {
        boolean control = (modifiers & 0x1C) != 0;
        boolean shift = (modifiers & 0x1B) != 0;
        boolean alt = (modifiers & 0x1D) != 0;
        switch (keyCode) {
            case 30: {
                this.addNewLine();
                this.write(10);
                break;
            }
            case 21: {
                this.deleteChar();
                this.write(8);
            }
        }
    }

    public void keyPressed(int keyCode, char keyChar, int modifiers) {
        this.keyTyped(keyCode, keyChar, modifiers);
    }

    public abstract void debug(String var1);

    public abstract void write(byte[] var1);

    public abstract void write(int var1);

    public void reset() {
        this.lines.clear();
    }

    class TerminalLine {
        private int[] charAttributes;
        private char[] charArray;
        private int col = 0;

        public TerminalLine(int width) {
            this.charArray = new char[width];
            this.charAttributes = new int[width];
            this.clear();
        }

        private void clear() {
            int i = 0;
            while (i < TerminalBuffer.this.width) {
                this.charArray[i] = 32;
                this.charAttributes[i] = 0;
                ++i;
            }
        }

        public void addChar(char c, int attr) {
            if (this.col >= this.charArray.length) {
                return;
            }
            this.charArray[this.col] = c;
            this.charAttributes[this.col] = attr;
            ++this.col;
        }

        public void addChar(char c) {
            if (this.col >= this.charArray.length) {
                return;
            }
            this.charArray[this.col] = c;
            ++this.col;
        }

        public void deleteChar() {
            --this.col;
            this.charArray[this.col] = 32;
        }

        public char getCharAt(int index) {
            return this.charArray[index];
        }

        public char[] getChars() {
            return this.charArray;
        }

        public int getAttributeAt(int index) {
            return this.charAttributes[index];
        }

        public void setChar(int index, char c) {
            this.charArray[index] = c;
        }

        public void setAttribute(int index, int attr) {
            this.charAttributes[index] = attr;
        }

        public String getString() {
            return new String(this.charArray);
        }

        public int getColumn() {
            return this.col;
        }
    }
}

