/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.service;

import android.content.SharedPreferences;
import android.os.SystemClock;
import android.text.ClipboardManager;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import com.e3roid.util.Debug;
import java.io.IOException;
import org.connectbot.service.TerminalBridge;
import org.connectbot.service.TerminalBuffer;
import org.connectbot.service.TerminalManager;
import org.connectbot.transport.AbsTransport;
import org.connectbot.util.SelectionArea;

public class TerminalKeyListener
implements View.OnKeyListener,
SharedPreferences.OnSharedPreferenceChangeListener {
    public static final int META_CTRL_ON = 1;
    public static final int META_CTRL_LOCK = 2;
    public static final int META_ALT_ON = 4;
    public static final int META_ALT_LOCK = 8;
    public static final int META_SHIFT_ON = 16;
    public static final int META_SHIFT_LOCK = 32;
    public static final int META_SLASH = 64;
    public static final int META_TAB = 128;
    public static final int META_CTRL_MASK = 3;
    public static final int META_ALT_MASK = 12;
    public static final int META_SHIFT_MASK = 48;
    public static final int META_TRANSIENT = 21;
    private final TerminalManager manager;
    private final TerminalBridge bridge;
    private final TerminalBuffer buffer;
    protected KeyCharacterMap keymap = KeyCharacterMap.load((int)0);
    private String keymode = null;
    private boolean hardKeyboard = false;
    private int metaState = 0;
    private ClipboardManager clipboard = null;
    private boolean selectingForCopy = false;
    private final SelectionArea selectionArea;
    private String encoding;

    public TerminalKeyListener(TerminalManager manager, TerminalBridge bridge, TerminalBuffer buffer, String encoding) {
        this.manager = manager;
        this.bridge = bridge;
        this.buffer = buffer;
        this.encoding = encoding;
        this.selectionArea = new SelectionArea();
        manager.registerOnSharedPreferenceChangeListener(this);
        this.hardKeyboard = manager.getResources().getConfiguration().keyboard == 2;
        this.updateKeymode();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean onKey(View v, int keyCode, KeyEvent event) {
        try {
            boolean printing;
            boolean hardKeyboardHidden = this.manager.isHardKeyboardHidden();
            AbsTransport transport = this.bridge.getTransport();
            if (event.getAction() == 1) {
                if (!this.hardKeyboard || this.hardKeyboard && hardKeyboardHidden) {
                    return false;
                }
                if (transport == null || !transport.isSessionOpen()) {
                    return false;
                }
                if ("Use right-side keys".equals(this.keymode)) {
                    if (keyCode == 58 && (this.metaState & 0x40) != 0) {
                        this.metaState &= 0xFFFFFFAA;
                        transport.write(47);
                        return true;
                    }
                    if (keyCode == 60 && (this.metaState & 0x80) != 0) {
                        this.metaState &= 0xFFFFFF6A;
                        transport.write(9);
                        return true;
                    }
                } else if ("Use left-side keys".equals(this.keymode)) {
                    if (keyCode == 57 && (this.metaState & 0x40) != 0) {
                        this.metaState &= 0xFFFFFFAA;
                        transport.write(47);
                        return true;
                    }
                    if (keyCode == 59 && (this.metaState & 0x80) != 0) {
                        this.metaState &= 0xFFFFFF6A;
                        transport.write(9);
                        return true;
                    }
                }
                return false;
            }
            if (keyCode == 4 && transport != null) {
                this.bridge.dispatchDisconnect(!transport.isSessionOpen());
                return true;
            }
            if (keyCode == 24) {
                this.bridge.increaseFontSize();
                return true;
            }
            if (keyCode == 25) {
                this.bridge.decreaseFontSize();
                return true;
            }
            if (transport == null || !transport.isSessionOpen()) {
                return false;
            }
            boolean bl = printing = this.keymap.isPrintingKey(keyCode) || keyCode == 62;
            if (printing) {
                int curMetaState = event.getMetaState();
                this.metaState &= 0xFFFFFF3F;
                if ((this.metaState & 0x30) != 0) {
                    curMetaState |= 1;
                    this.metaState &= 0xFFFFFFEF;
                    this.bridge.redraw();
                }
                if ((this.metaState & 0xC) != 0) {
                    curMetaState |= 2;
                    this.metaState &= 0xFFFFFFFB;
                    this.bridge.redraw();
                }
                int key = this.keymap.get(keyCode, curMetaState);
                if ((this.metaState & 3) != 0) {
                    this.metaState &= 0xFFFFFFFE;
                    this.bridge.redraw();
                    if ((!this.hardKeyboard || this.hardKeyboard && hardKeyboardHidden) && this.sendFunctionKey(keyCode)) {
                        return true;
                    }
                    if (key >= 97 && key <= 122) {
                        key -= 96;
                    } else if (key >= 65 && key <= 95) {
                        key -= 64;
                    } else if (key == 32) {
                        key = 0;
                    } else if (key == 63) {
                        key = 127;
                    }
                }
                if (this.hardKeyboard && !hardKeyboardHidden && (curMetaState & 1) != 0 && this.sendFunctionKey(keyCode)) {
                    return true;
                }
                if (key < 128) {
                    transport.write(key);
                } else {
                    transport.write(new String(Character.toChars(key)).getBytes(this.encoding));
                }
                return true;
            }
            if (keyCode == 0 && event.getAction() == 2) {
                byte[] input = event.getCharacters().getBytes(this.encoding);
                transport.write(input);
                return true;
            }
            if (this.hardKeyboard && !hardKeyboardHidden && event.getRepeatCount() == 0) {
                if ("Use right-side keys".equals(this.keymode)) {
                    switch (keyCode) {
                        case 58: {
                            this.metaState |= 0x40;
                            return true;
                        }
                        case 60: {
                            this.metaState |= 0x80;
                            return true;
                        }
                        case 59: {
                            this.metaPress(16);
                            return true;
                        }
                        case 57: {
                            this.metaPress(4);
                            return true;
                        }
                    }
                } else if ("Use left-side keys".equals(this.keymode)) {
                    switch (keyCode) {
                        case 57: {
                            this.metaState |= 0x40;
                            return true;
                        }
                        case 59: {
                            this.metaState |= 0x80;
                            return true;
                        }
                        case 60: {
                            this.metaPress(16);
                            return true;
                        }
                        case 58: {
                            this.metaPress(4);
                            return true;
                        }
                    }
                } else {
                    switch (keyCode) {
                        case 57: 
                        case 58: {
                            this.metaPress(4);
                            return true;
                        }
                        case 59: 
                        case 60: {
                            this.metaPress(16);
                            return true;
                        }
                    }
                }
            }
            switch (keyCode) {
                case 27: {
                    String camera = this.manager.getStringParameter("terminal_camera", "Ctrl+A then Space");
                    if ("Ctrl+A then Space".equals(camera)) {
                        transport.write(1);
                        transport.write(32);
                        break;
                    }
                    if ("Ctrl+A".equals(camera)) {
                        transport.write(1);
                        break;
                    }
                    if ("Esc".equals(camera)) {
                        this.buffer.keyTyped(43, ' ', 0);
                        break;
                    }
                    if ("Esc+A".equals(camera)) {
                        this.buffer.keyTyped(43, ' ', 0);
                        transport.write(97);
                    }
                    break;
                }
                case 67: {
                    this.buffer.keyPressed(22, ' ', this.getStateForBuffer());
                    this.metaState &= 0xFFFFFFEA;
                    return true;
                }
                case 66: {
                    this.buffer.keyTyped(30, ' ', 0);
                    this.metaState &= 0xFFFFFFEA;
                    return true;
                }
                case 21: {
                    if (this.selectingForCopy) {
                        this.selectionArea.decrementColumn();
                        this.bridge.redraw();
                    } else {
                        this.buffer.keyPressed(16, ' ', this.getStateForBuffer());
                        this.metaState &= 0xFFFFFFEA;
                    }
                    return true;
                }
                case 19: {
                    if (this.selectingForCopy) {
                        this.selectionArea.decrementRow();
                        this.bridge.redraw();
                    } else {
                        this.buffer.keyPressed(14, ' ', this.getStateForBuffer());
                        this.metaState &= 0xFFFFFFEA;
                    }
                    return true;
                }
                case 20: {
                    if (this.selectingForCopy) {
                        this.selectionArea.incrementRow();
                        this.bridge.redraw();
                    } else {
                        this.buffer.keyPressed(15, ' ', this.getStateForBuffer());
                        this.metaState &= 0xFFFFFFEA;
                    }
                    return true;
                }
                case 22: {
                    if (this.selectingForCopy) {
                        this.selectionArea.incrementColumn();
                        this.bridge.redraw();
                    } else {
                        this.buffer.keyPressed(17, ' ', this.getStateForBuffer());
                        this.metaState &= 0xFFFFFFEA;
                    }
                    return true;
                }
                case 23: {
                    if (this.selectingForCopy) {
                        if (this.selectionArea.isSelectingOrigin()) {
                            this.selectionArea.finishSelectingOrigin();
                        } else if (this.clipboard != null) {
                            String copiedText = this.selectionArea.copyFrom(this.buffer);
                            this.clipboard.setText((CharSequence)copiedText);
                            this.selectingForCopy = false;
                            this.selectionArea.reset();
                        }
                    } else if ((this.metaState & 1) != 0) {
                        this.buffer.keyTyped(43, ' ', 0);
                        this.metaState &= 0xFFFFFFFE;
                    } else {
                        this.metaState |= 1;
                    }
                    this.bridge.redraw();
                    return true;
                }
            }
        }
        catch (IOException e) {
            Debug.e("Problem while trying to handle an onKey() event", e, false);
            try {
                this.bridge.getTransport().flush();
            }
            catch (IOException ioe) {
                Debug.d("Our transport was closed, dispatching disconnect event", false);
                this.bridge.dispatchDisconnect(false);
            }
        }
        catch (NullPointerException npe) {
            Debug.d("Input before connection established ignored.", false);
            return true;
        }
        return false;
    }

    private boolean sendFunctionKey(int keyCode) {
        switch (keyCode) {
            case 8: {
                this.buffer.keyPressed(2, ' ', 0);
                return true;
            }
            case 9: {
                this.buffer.keyPressed(3, ' ', 0);
                return true;
            }
            case 10: {
                this.buffer.keyPressed(4, ' ', 0);
                return true;
            }
            case 11: {
                this.buffer.keyPressed(5, ' ', 0);
                return true;
            }
            case 12: {
                this.buffer.keyPressed(6, ' ', 0);
                return true;
            }
            case 13: {
                this.buffer.keyPressed(7, ' ', 0);
                return true;
            }
            case 14: {
                this.buffer.keyPressed(8, ' ', 0);
                return true;
            }
            case 15: {
                this.buffer.keyPressed(9, ' ', 0);
                return true;
            }
            case 16: {
                this.buffer.keyPressed(10, ' ', 0);
                return true;
            }
            case 7: {
                this.buffer.keyPressed(11, ' ', 0);
                return true;
            }
        }
        return false;
    }

    private void metaPress(int code) {
        if ((this.metaState & code << 1) != 0) {
            this.metaState &= ~(code << 1);
        } else if ((this.metaState & code) != 0) {
            this.metaState &= ~code;
            this.metaState |= code << 1;
        } else {
            this.metaState |= code;
        }
        this.bridge.redraw();
    }

    public void setTerminalKeyMode(String keymode) {
        this.keymode = keymode;
    }

    private int getStateForBuffer() {
        int bufferState = 0;
        if ((this.metaState & 3) != 0) {
            bufferState |= 0x1C;
        }
        if ((this.metaState & 0x30) != 0) {
            bufferState |= 0x1B;
        }
        if ((this.metaState & 0xC) != 0) {
            bufferState |= 0x1D;
        }
        return bufferState;
    }

    public int getMetaState() {
        return this.metaState;
    }

    public void setClipboardManager(ClipboardManager clipboard) {
        this.clipboard = clipboard;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if ("terminal_keymode".equals(key)) {
            this.updateKeymode();
        }
    }

    private void updateKeymode() {
        this.keymode = this.manager.getStringParameter("terminal_keymode", "Use right-side keys");
    }

    public void setCharset(String encoding) {
        this.encoding = encoding;
    }

    public boolean onCommitText(View view, CharSequence text, int newCursorPosition) {
        return this.onKey(view, 0, new KeyEvent(SystemClock.uptimeMillis(), text.toString(), 0, 2));
    }
}

