/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.service;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import com.e3roid.lifecycle.E3LifeCycle;
import com.e3roid.util.Debug;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.connectbot.service.TerminalBridge;
import org.connectbot.transport.AbsTransport;

public class TerminalManager
implements E3LifeCycle {
    private final Map<Integer, WeakReference<TerminalBridge>> mHostBridgeMap = new ConcurrentHashMap<Integer, WeakReference<TerminalBridge>>();
    private final List<TerminalBridge> bridges = new CopyOnWriteArrayList<TerminalBridge>();
    private final Resources mResources;
    private final SharedPreferences mPreferences;
    private boolean hardKeyboardHidden;
    private boolean resizeAllowed = true;
    public static final int DEBUG_TRANSPORT_ID = Integer.MAX_VALUE;
    public static final int SYSTEM_TRANSPORT_ID = 0x7FFFFFFE;
    public static final int SCRIPT_TRANSPORT_ID = 0x7FFFFFFD;

    public TerminalManager(Context context) {
        this.mResources = context.getResources();
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.hardKeyboardHidden = this.mResources.getConfiguration().hardKeyboardHidden == 2;
    }

    private void disconnectAll() {
        TerminalBridge[] bridgesArray = null;
        if (this.bridges.size() > 0) {
            bridgesArray = this.bridges.toArray(new TerminalBridge[this.bridges.size()]);
        }
        if (bridgesArray != null) {
            TerminalBridge[] terminalBridgeArray = bridgesArray;
            int n = bridgesArray.length;
            int n2 = 0;
            while (n2 < n) {
                TerminalBridge bridge = terminalBridgeArray[n2];
                bridge.dispatchDisconnect(true);
                ++n2;
            }
        }
    }

    public TerminalBridge openDebugConnection() throws IllegalArgumentException, IOException, InterruptedException {
        return this.openConnection(Integer.MAX_VALUE, Debug.connect());
    }

    public void closeDebugConnection() {
        Debug.disconnect();
    }

    public TerminalBridge openConnection(int id, AbsTransport transport) throws IllegalArgumentException, IOException, InterruptedException {
        if (this.getConnectedBridge(id) != null) {
            throw new IllegalArgumentException("Connection already open");
        }
        TerminalBridge bridge = new TerminalBridge(this, transport, id);
        bridge.connect();
        WeakReference<TerminalBridge> wr = new WeakReference<TerminalBridge>(bridge);
        this.bridges.add(bridge);
        this.mHostBridgeMap.put(id, wr);
        return bridge;
    }

    public TerminalBridge getConnectedBridge(int id) {
        WeakReference<TerminalBridge> wr = this.mHostBridgeMap.get(id);
        if (wr != null) {
            return (TerminalBridge)wr.get();
        }
        return null;
    }

    public void closeConnection(TerminalBridge bridge, boolean killProcess) {
        if (killProcess) {
            this.bridges.remove(bridge);
            this.mHostBridgeMap.remove(bridge.getId());
        }
    }

    public void setResizeAllowed(boolean resizeAllowed) {
        this.resizeAllowed = resizeAllowed;
    }

    public boolean isResizeAllowed() {
        return this.resizeAllowed;
    }

    public void stop() {
        this.resizeAllowed = false;
        this.disconnectAll();
    }

    public int getIntParameter(String key, int defValue) {
        return this.mPreferences.getInt(key, defValue);
    }

    public String getStringParameter(String key, String defValue) {
        return this.mPreferences.getString(key, defValue);
    }

    public boolean isHardKeyboardHidden() {
        return this.hardKeyboardHidden;
    }

    public void setHardKeyboardHidden(boolean b) {
        this.hardKeyboardHidden = b;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mPreferences.registerOnSharedPreferenceChangeListener(listener);
    }

    public Resources getResources() {
        return this.mResources;
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onDispose() {
        this.stop();
    }
}

