/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.connectbot.transport.AbsTransport;

public class StreamTransport
extends AbsTransport {
    private boolean connected = false;
    private final InputStream in;
    private final OutputStream out;

    public StreamTransport(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.in != null) {
            return this.in.read(buffer, offset, length);
        }
        throw new IOException("session closed");
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        if (this.out != null) {
            this.out.write(buffer);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.out != null) {
            this.out.write(c);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connected = false;
    }

    @Override
    public void setDimensions(int columns, int rows, int width, int height) {
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSessionOpen() {
        return this.connected;
    }
}

