/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.util;

import org.connectbot.service.TerminalBuffer;

public class SelectionArea {
    private int top;
    private int bottom;
    private int left;
    private int right;
    private int maxColumns;
    private int maxRows;
    private boolean selectingOrigin;

    public SelectionArea() {
        this.reset();
    }

    public final void reset() {
        this.right = 0;
        this.bottom = 0;
        this.left = 0;
        this.top = 0;
        this.selectingOrigin = true;
    }

    public void setBounds(int columns, int rows) {
        this.maxColumns = columns - 1;
        this.maxRows = rows - 1;
    }

    private int checkBounds(int value, int max) {
        if (value < 0) {
            return 0;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public boolean isSelectingOrigin() {
        return this.selectingOrigin;
    }

    public void finishSelectingOrigin() {
        this.selectingOrigin = false;
    }

    public void decrementRow() {
        if (this.selectingOrigin) {
            this.setTop(this.top - 1);
        } else {
            this.setBottom(this.bottom - 1);
        }
    }

    public void incrementRow() {
        if (this.selectingOrigin) {
            this.setTop(this.top + 1);
        } else {
            this.setBottom(this.bottom + 1);
        }
    }

    public void setRow(int row) {
        if (this.selectingOrigin) {
            this.setTop(row);
        } else {
            this.setBottom(row);
        }
    }

    private void setTop(int top) {
        this.top = this.bottom = this.checkBounds(top, this.maxRows);
    }

    public int getTop() {
        return Math.min(this.top, this.bottom);
    }

    private void setBottom(int bottom) {
        this.bottom = this.checkBounds(bottom, this.maxRows);
    }

    public int getBottom() {
        return Math.max(this.top, this.bottom);
    }

    public void decrementColumn() {
        if (this.selectingOrigin) {
            this.setLeft(this.left - 1);
        } else {
            this.setRight(this.right - 1);
        }
    }

    public void incrementColumn() {
        if (this.selectingOrigin) {
            this.setLeft(this.left + 1);
        } else {
            this.setRight(this.right + 1);
        }
    }

    public void setColumn(int column) {
        if (this.selectingOrigin) {
            this.setLeft(column);
        } else {
            this.setRight(column);
        }
    }

    private void setLeft(int left) {
        this.left = this.right = this.checkBounds(left, this.maxColumns);
    }

    public int getLeft() {
        return Math.min(this.left, this.right);
    }

    private void setRight(int right) {
        this.right = this.checkBounds(right, this.maxColumns);
    }

    public int getRight() {
        return Math.max(this.left, this.right);
    }

    public String copyFrom(TerminalBuffer vb) {
        int size = (this.getRight() - this.getLeft() + 1) * (this.getBottom() - this.getTop() + 1);
        StringBuffer buffer = new StringBuffer(size);
        int y = this.getTop();
        while (y <= this.getBottom()) {
            int lastNonSpace = buffer.length();
            int x = this.getLeft();
            while (x <= this.getRight()) {
                char c = vb.getCharAt(x, y);
                if (!Character.isDefined(c) || Character.isISOControl(c) && c != '\t') {
                    c = ' ';
                }
                if (c != ' ') {
                    lastNonSpace = buffer.length();
                }
                buffer.append(c);
                ++x;
            }
            if (buffer.length() > lastNonSpace) {
                buffer.delete(lastNonSpace + 1, buffer.length());
            }
            if (y != this.bottom) {
                buffer.append("\n");
            }
            ++y;
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SelectionArea[top=");
        buffer.append(this.top);
        buffer.append(", bottom=");
        buffer.append(this.bottom);
        buffer.append(", left=");
        buffer.append(this.left);
        buffer.append(", right=");
        buffer.append(this.right);
        buffer.append(", maxColumns=");
        buffer.append(this.maxColumns);
        buffer.append(", maxRows=");
        buffer.append(this.maxRows);
        buffer.append(", isSelectingOrigin=");
        buffer.append(this.isSelectingOrigin());
        buffer.append("]");
        return buffer.toString();
    }
}

