/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.DebugLib;

public class LuaError
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String traceback;
    private Throwable cause;

    private static String errorHook(String msg) {
        LuaThread thread = LuaThread.getRunning();
        if (thread.err != null) {
            LuaValue errfunc = thread.err;
            thread.err = null;
            try {
                String string = errfunc.call(LuaValue.valueOf(msg)).tojstring();
                return string;
            }
            catch (Throwable t) {
                return "error in error handling";
            }
            finally {
                thread.err = errfunc;
            }
        }
        return msg;
    }

    public LuaError(Throwable cause) {
        super(LuaError.errorHook(LuaError.addFileLine("vm error: " + cause)));
        this.cause = cause;
        this.traceback = DebugLib.traceback(1);
    }

    public LuaError(String message) {
        super(LuaError.errorHook(LuaError.addFileLine(message)));
        this.traceback = DebugLib.traceback(1);
    }

    public LuaError(String message, int level) {
        super(LuaError.errorHook(LuaError.addFileLine(message, level)));
        this.traceback = DebugLib.traceback(1);
    }

    private static String addFileLine(String message, int level) {
        if (message == null) {
            return null;
        }
        if (level == 0) {
            return message;
        }
        String fileline = DebugLib.fileline(level - 1);
        return fileline != null ? String.valueOf(fileline) + ": " + message : message;
    }

    private static String addFileLine(String message) {
        if (message == null) {
            return null;
        }
        String fileline = DebugLib.fileline();
        return fileline != null ? String.valueOf(fileline) + ": " + message : message;
    }

    @Override
    public void printStackTrace() {
        System.out.println(this.toString());
        if (this.traceback != null) {
            System.out.println(this.traceback);
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

