/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;
import org.luaj.vm2.lib.StringLib;

public class LuaString
extends LuaValue {
    public static LuaValue s_metatable;
    public final byte[] m_bytes;
    public final int m_offset;
    public final int m_length;
    private static final Hashtable index_java;

    static {
        index_java = new Hashtable();
    }

    private static final LuaString index_get(Hashtable indextable, Object key) {
        WeakReference w = (WeakReference)indextable.get(key);
        return w != null ? (LuaString)w.get() : null;
    }

    private static final void index_set(Hashtable indextable, Object key, LuaString value) {
        indextable.put(key, new WeakReference<LuaString>(value));
    }

    public static LuaString valueOf(String string) {
        LuaString s = LuaString.index_get(index_java, string);
        if (s != null) {
            return s;
        }
        char[] c = string.toCharArray();
        byte[] b = new byte[LuaString.lengthAsUtf8(c)];
        LuaString.encodeToUtf8(c, b, 0);
        s = LuaString.valueOf(b, 0, b.length);
        LuaString.index_set(index_java, string, s);
        return s;
    }

    public static LuaString valueOf(byte[] bytes, int off, int len) {
        return new LuaString(bytes, off, len);
    }

    public static LuaString valueOf(char[] bytes) {
        int n = bytes.length;
        byte[] b = new byte[n];
        int i = 0;
        while (i < n) {
            b[i] = (byte)bytes[i];
            ++i;
        }
        return LuaString.valueOf(b, 0, n);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    private LuaString(byte[] bytes, int offset, int length) {
        this.m_bytes = bytes;
        this.m_offset = offset;
        this.m_length = length;
    }

    @Override
    public boolean isstring() {
        return true;
    }

    @Override
    public LuaValue getmetatable() {
        return s_metatable;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String typename() {
        return "string";
    }

    @Override
    public String tojstring() {
        return LuaString.decodeAsUtf8(this.m_bytes, this.m_offset, this.m_length);
    }

    @Override
    public LuaValue get(LuaValue key) {
        return s_metatable != null ? LuaString.gettable(this, key) : StringLib.instance.get(key);
    }

    @Override
    public LuaValue neg() {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? super.neg() : LuaString.valueOf(-d);
    }

    @Override
    public LuaValue add(LuaValue rhs) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(ADD, rhs) : rhs.add(d);
    }

    @Override
    public LuaValue add(double rhs) {
        return LuaString.valueOf(this.checkarith() + rhs);
    }

    @Override
    public LuaValue add(int rhs) {
        return LuaString.valueOf(this.checkarith() + (double)rhs);
    }

    @Override
    public LuaValue sub(LuaValue rhs) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(SUB, rhs) : rhs.subFrom(d);
    }

    @Override
    public LuaValue sub(double rhs) {
        return LuaString.valueOf(this.checkarith() - rhs);
    }

    @Override
    public LuaValue sub(int rhs) {
        return LuaString.valueOf(this.checkarith() - (double)rhs);
    }

    @Override
    public LuaValue subFrom(double lhs) {
        return LuaString.valueOf(lhs - this.checkarith());
    }

    @Override
    public LuaValue mul(LuaValue rhs) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(MUL, rhs) : rhs.mul(d);
    }

    @Override
    public LuaValue mul(double rhs) {
        return LuaString.valueOf(this.checkarith() * rhs);
    }

    @Override
    public LuaValue mul(int rhs) {
        return LuaString.valueOf(this.checkarith() * (double)rhs);
    }

    @Override
    public LuaValue pow(LuaValue rhs) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(POW, rhs) : rhs.powWith(d);
    }

    @Override
    public LuaValue pow(double rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue pow(int rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue powWith(double lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue powWith(int lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue div(LuaValue rhs) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(DIV, rhs) : rhs.divInto(d);
    }

    @Override
    public LuaValue div(double rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue div(int rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue divInto(double lhs) {
        return LuaDouble.ddiv(lhs, this.checkarith());
    }

    @Override
    public LuaValue mod(LuaValue rhs) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(MOD, rhs) : rhs.modFrom(d);
    }

    @Override
    public LuaValue mod(double rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue mod(int rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue modFrom(double lhs) {
        return LuaDouble.dmod(lhs, this.checkarith());
    }

    @Override
    public LuaValue lt(LuaValue rhs) {
        return rhs.strcmp(this) > 0 ? LuaValue.TRUE : FALSE;
    }

    @Override
    public boolean lt_b(LuaValue rhs) {
        return rhs.strcmp(this) > 0;
    }

    @Override
    public boolean lt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue lteq(LuaValue rhs) {
        return rhs.strcmp(this) >= 0 ? LuaValue.TRUE : FALSE;
    }

    @Override
    public boolean lteq_b(LuaValue rhs) {
        return rhs.strcmp(this) >= 0;
    }

    @Override
    public boolean lteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gt(LuaValue rhs) {
        return rhs.strcmp(this) < 0 ? LuaValue.TRUE : FALSE;
    }

    @Override
    public boolean gt_b(LuaValue rhs) {
        return rhs.strcmp(this) < 0;
    }

    @Override
    public boolean gt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gteq(LuaValue rhs) {
        return rhs.strcmp(this) <= 0 ? LuaValue.TRUE : FALSE;
    }

    @Override
    public boolean gteq_b(LuaValue rhs) {
        return rhs.strcmp(this) <= 0;
    }

    @Override
    public boolean gteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue concat(LuaValue rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public Buffer concat(Buffer rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public LuaValue concatTo(LuaNumber lhs) {
        return this.concatTo(lhs.strvalue());
    }

    @Override
    public LuaValue concatTo(LuaString lhs) {
        byte[] b = new byte[lhs.m_length + this.m_length];
        System.arraycopy(lhs.m_bytes, lhs.m_offset, b, 0, lhs.m_length);
        System.arraycopy(this.m_bytes, this.m_offset, b, lhs.m_length, this.m_length);
        return new LuaString(b, 0, b.length);
    }

    @Override
    public int strcmp(LuaValue lhs) {
        return -lhs.strcmp(this);
    }

    @Override
    public int strcmp(LuaString rhs) {
        int i = 0;
        int j = 0;
        while (i < this.m_length && j < rhs.m_length) {
            if (this.m_bytes[this.m_offset + i] != rhs.m_bytes[rhs.m_offset + j]) {
                return this.m_bytes[this.m_offset + i] - rhs.m_bytes[rhs.m_offset + j];
            }
            ++i;
            ++j;
        }
        return this.m_length - rhs.m_length;
    }

    private double checkarith() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            this.aritherror();
        }
        return d;
    }

    @Override
    public int checkint() {
        return (int)this.checkdouble();
    }

    @Override
    public LuaInteger checkinteger() {
        return LuaString.valueOf(this.checkint());
    }

    @Override
    public long checklong() {
        return (long)this.checkdouble();
    }

    @Override
    public double checkdouble() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            this.argerror("number");
        }
        return d;
    }

    @Override
    public LuaNumber checknumber() {
        return LuaString.valueOf(this.checkdouble());
    }

    @Override
    public LuaNumber checknumber(String msg) {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            this.argerror("number");
        }
        return LuaString.valueOf(d);
    }

    @Override
    public LuaValue tonumber() {
        return this.tonumber(10);
    }

    @Override
    public boolean isnumber() {
        double d = this.scannumber(10);
        return !Double.isNaN(d);
    }

    @Override
    public boolean isint() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            return false;
        }
        int i = (int)d;
        return (double)i == d;
    }

    @Override
    public boolean islong() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    @Override
    public byte tobyte() {
        return (byte)this.toint();
    }

    @Override
    public char tochar() {
        return (char)this.toint();
    }

    @Override
    public double todouble() {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? 0.0 : d;
    }

    @Override
    public float tofloat() {
        return (float)this.todouble();
    }

    @Override
    public int toint() {
        return (int)this.tolong();
    }

    @Override
    public long tolong() {
        return (long)this.todouble();
    }

    @Override
    public short toshort() {
        return (short)this.toint();
    }

    @Override
    public double optdouble(double defval) {
        return this.checknumber().checkdouble();
    }

    @Override
    public int optint(int defval) {
        return this.checknumber().checkint();
    }

    @Override
    public LuaInteger optinteger(LuaInteger defval) {
        return this.checknumber().checkinteger();
    }

    @Override
    public long optlong(long defval) {
        return this.checknumber().checklong();
    }

    @Override
    public LuaNumber optnumber(LuaNumber defval) {
        return this.checknumber().checknumber();
    }

    @Override
    public LuaString optstring(LuaString defval) {
        return this;
    }

    @Override
    public LuaValue tostring() {
        return this;
    }

    @Override
    public String optjstring(String defval) {
        return this.tojstring();
    }

    @Override
    public LuaString strvalue() {
        return this;
    }

    public LuaString substring(int beginIndex, int endIndex) {
        return new LuaString(this.m_bytes, this.m_offset + beginIndex, endIndex - beginIndex);
    }

    public int hashCode() {
        int h = this.m_length;
        int step = (this.m_length >> 5) + 1;
        int l1 = this.m_length;
        while (l1 >= step) {
            h ^= (h << 5) + (h >> 2) + (this.m_bytes[this.m_offset + l1 - 1] & 0xFF);
            l1 -= step;
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LuaString) {
            return this.raweq((LuaString)o);
        }
        return false;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return val.raweq(this) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaString s) {
        if (this == s) {
            return true;
        }
        if (s.m_length != this.m_length) {
            return false;
        }
        if (s.m_bytes == this.m_bytes && s.m_offset == this.m_offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        int i = 0;
        while (i < this.m_length) {
            if (s.m_bytes[s.m_offset + i] != this.m_bytes[this.m_offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(LuaString a, int i, LuaString b, int j, int n) {
        return LuaString.equals(a.m_bytes, a.m_offset + i, b.m_bytes, b.m_offset + j, n);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equals(byte[] a, int i, byte[] b, int j, int n) {
        if (a.length >= i + n && b.length >= j + n) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (a[i++] == b[j++]) continue;
            return false;
lbl5:
            // 2 sources

            ** while (--n >= 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    public void write(DataOutputStream writer, int i, int len) throws IOException {
        writer.write(this.m_bytes, this.m_offset + i, len);
    }

    @Override
    public LuaValue len() {
        return LuaInteger.valueOf(this.m_length);
    }

    @Override
    public int length() {
        return this.m_length;
    }

    public int luaByte(int index) {
        return this.m_bytes[this.m_offset + index] & 0xFF;
    }

    public int charAt(int index) {
        if (index < 0 || index >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(index);
    }

    @Override
    public String checkjstring() {
        return this.tojstring();
    }

    @Override
    public LuaString checkstring() {
        return this;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length);
    }

    public void copyInto(int strOffset, byte[] bytes, int arrayOffset, int len) {
        System.arraycopy(this.m_bytes, this.m_offset + strOffset, bytes, arrayOffset, len);
    }

    public int indexOfAny(LuaString accept) {
        int ilimit = this.m_offset + this.m_length;
        int jlimit = accept.m_offset + accept.m_length;
        int i = this.m_offset;
        while (i < ilimit) {
            int j = accept.m_offset;
            while (j < jlimit) {
                if (this.m_bytes[i] == accept.m_bytes[j]) {
                    return i - this.m_offset;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(byte b, int start) {
        int i = 0;
        int j = this.m_offset + start;
        while (i < this.m_length) {
            if (this.m_bytes[j++] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(LuaString s, int start) {
        int slen = s.length();
        int limit = this.m_offset + this.m_length - slen;
        int i = this.m_offset + start;
        while (i <= limit) {
            if (LuaString.equals(this.m_bytes, i, s.m_bytes, s.m_offset, slen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(LuaString s) {
        int limit;
        int slen = s.length();
        int i = limit = this.m_offset + this.m_length - slen;
        while (i >= this.m_offset) {
            if (LuaString.equals(this.m_bytes, i, s.m_bytes, s.m_offset, slen)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static String decodeAsUtf8(byte[] bytes, int offset, int length) {
        int i = offset;
        int j = offset + length;
        int n = 0;
        while (i < j) {
            switch (0xE0 & bytes[i++]) {
                case 224: {
                    ++i;
                }
                case 192: {
                    ++i;
                }
            }
            ++n;
        }
        char[] chars = new char[n];
        i = offset;
        j = offset + length;
        n = 0;
        while (i < j) {
            int b;
            chars[n++] = (char)((b = bytes[i++]) >= 0 || i >= j ? b : (b < -32 || i + 1 >= j ? (b & 0x3F) << 6 | bytes[i++] & 0x3F : (b & 0xF) << 12 | (bytes[i++] & 0x3F) << 6 | bytes[i++] & 0x3F));
        }
        return new String(chars);
    }

    public static int lengthAsUtf8(char[] chars) {
        int b;
        int i = b = chars.length;
        while (--i >= 0) {
            char c = chars[i];
            if (c < '\u0080') continue;
            b += c >= '\u0800' ? 2 : 1;
        }
        return b;
    }

    public static void encodeToUtf8(char[] chars, byte[] bytes, int off) {
        int n = chars.length;
        int i = 0;
        int j = off;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                bytes[j++] = (byte)c;
            } else if (c < '\u0800') {
                bytes[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[j++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytes[j++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[j++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
    }

    public boolean isValidUtf8() {
        boolean e = false;
        int i = this.m_offset;
        int j = this.m_offset + this.m_length;
        int n = 0;
        while (i < j) {
            byte c;
            if (!((c = this.m_bytes[i++]) >= 0 || (c & 0xE0) == 192 && i < j && (this.m_bytes[i++] & 0xC0) == 128 || (c & 0xF0) == 224 && i + 1 < j && (this.m_bytes[i++] & 0xC0) == 128 && (this.m_bytes[i++] & 0xC0) == 128)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public LuaValue tonumber(int base) {
        double d = this.scannumber(base);
        return Double.isNaN(d) ? NIL : LuaString.valueOf(d);
    }

    public double scannumber(int base) {
        if (base >= 2 && base <= 36) {
            double l;
            int i = this.m_offset;
            int j = this.m_offset + this.m_length;
            while (i < j && this.m_bytes[i] == 32) {
                ++i;
            }
            while (i < j && this.m_bytes[j - 1] == 32) {
                --j;
            }
            if (i >= j) {
                return Double.NaN;
            }
            if (!(base != 10 && base != 16 || this.m_bytes[i] != 48 || i + 1 >= j || this.m_bytes[i + 1] != 120 && this.m_bytes[i + 1] != 88)) {
                base = 16;
                i += 2;
            }
            return Double.isNaN(l = this.scanlong(base, i, j)) && base == 10 ? this.scandouble(i, j) : l;
        }
        return Double.NaN;
    }

    private double scanlong(int base, int start, int end) {
        long x = 0L;
        boolean neg = this.m_bytes[start] == 45;
        int i = neg ? start + 1 : start;
        while (i < end) {
            int digit = this.m_bytes[i] - (base <= 10 || this.m_bytes[i] >= 48 && this.m_bytes[i] <= 57 ? 48 : (this.m_bytes[i] >= 65 && this.m_bytes[i] <= 90 ? 55 : 87));
            if (digit < 0 || digit >= base) {
                return Double.NaN;
            }
            x = x * (long)base + (long)digit;
            ++i;
        }
        return neg ? -x : x;
    }

    private double scandouble(int start, int end) {
        if (end > start + 64) {
            end = start + 64;
        }
        int i = start;
        while (i < end) {
            switch (this.m_bytes[i]) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    break;
                }
                default: {
                    return Double.NaN;
                }
            }
            ++i;
        }
        char[] c = new char[end - start];
        int i2 = start;
        while (i2 < end) {
            c[i2 - start] = (char)this.m_bytes[i2];
            ++i2;
        }
        try {
            return Double.parseDouble(new String(c));
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }
}

