/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.util.Vector;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.WeakTable;

public class LuaTable
extends LuaValue {
    private static final int MIN_HASH_CAPACITY = 2;
    private static final LuaString N = LuaTable.valueOf("n");
    protected LuaValue[] array;
    protected LuaValue[] hashKeys;
    protected LuaValue[] hashValues;
    protected int hashEntries;
    protected LuaValue m_metatable;

    public LuaTable() {
        this.array = NOVALS;
        this.hashKeys = NOVALS;
        this.hashValues = NOVALS;
    }

    public LuaTable(int narray, int nhash) {
        this.presize(narray, nhash);
    }

    public LuaTable(LuaValue[] named, LuaValue[] unnamed, Varargs lastarg) {
        int nn = named != null ? named.length : 0;
        int nu = unnamed != null ? unnamed.length : 0;
        int nl = lastarg != null ? lastarg.narg() : 0;
        this.presize(nu + nl, nn - (nn >> 1));
        int i = 0;
        while (i < nu) {
            this.rawset(i + 1, unnamed[i]);
            ++i;
        }
        if (lastarg != null) {
            i = 1;
            int n = lastarg.narg();
            while (i <= n) {
                this.rawset(nu + i, lastarg.arg(i));
                ++i;
            }
        }
        i = 0;
        while (i < nn) {
            if (!named[i + 1].isnil()) {
                this.rawset(named[i], named[i + 1]);
            }
            i += 2;
        }
    }

    public LuaTable(Varargs varargs) {
        this(varargs, 1);
    }

    public LuaTable(Varargs varargs, int firstarg) {
        int nskip = firstarg - 1;
        int n = Math.max(varargs.narg() - nskip, 0);
        this.presize(n, 1);
        this.set(N, (LuaValue)LuaTable.valueOf(n));
        int i = 1;
        while (i <= n) {
            this.set(i, varargs.arg(i + nskip));
            ++i;
        }
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public String typename() {
        return "table";
    }

    @Override
    public boolean istable() {
        return true;
    }

    @Override
    public LuaTable checktable() {
        return this;
    }

    @Override
    public LuaTable opttable(LuaTable defval) {
        return this;
    }

    @Override
    public void presize(int narray) {
        if (narray > this.array.length) {
            this.array = LuaTable.resize(this.array, narray);
        }
    }

    public void presize(int narray, int nhash) {
        if (nhash > 0 && nhash < 2) {
            nhash = 2;
        }
        this.array = narray > 0 ? new LuaValue[narray] : NOVALS;
        this.hashKeys = nhash > 0 ? new LuaValue[nhash] : NOVALS;
        this.hashValues = nhash > 0 ? new LuaValue[nhash] : NOVALS;
        this.hashEntries = 0;
    }

    private static LuaValue[] resize(LuaValue[] old, int n) {
        LuaValue[] v = new LuaValue[n];
        System.arraycopy(old, 0, v, 0, old.length);
        return v;
    }

    protected int getArrayLength() {
        return this.array.length;
    }

    protected int getHashLength() {
        return this.hashValues.length;
    }

    @Override
    public LuaValue getmetatable() {
        return this.m_metatable;
    }

    @Override
    public LuaValue setmetatable(LuaValue metatable) {
        LuaValue mode;
        this.m_metatable = metatable;
        if (this.m_metatable != null && (mode = this.m_metatable.rawget(MODE)).isstring()) {
            String m = mode.tojstring();
            boolean k = m.indexOf(107) >= 0;
            boolean v = m.indexOf(118) >= 0;
            return this.changemode(k, v);
        }
        return this;
    }

    protected LuaTable changemode(boolean weakkeys, boolean weakvalues) {
        if (weakkeys || weakvalues) {
            return new WeakTable(weakkeys, weakvalues, this);
        }
        return this;
    }

    @Override
    public LuaValue get(int key) {
        LuaValue v = this.rawget(key);
        return v.isnil() && this.m_metatable != null ? LuaTable.gettable(this, LuaTable.valueOf(key)) : v;
    }

    @Override
    public LuaValue get(LuaValue key) {
        LuaValue v = this.rawget(key);
        return v.isnil() && this.m_metatable != null ? LuaTable.gettable(this, key) : v;
    }

    @Override
    public LuaValue rawget(int key) {
        if (key > 0 && key <= this.array.length) {
            return this.array[key - 1] != null ? this.array[key - 1] : NIL;
        }
        return this.hashget(LuaInteger.valueOf(key));
    }

    @Override
    public LuaValue rawget(LuaValue key) {
        int ikey;
        if (key.isinttype() && (ikey = key.toint()) > 0 && ikey <= this.array.length) {
            return this.array[ikey - 1] != null ? this.array[ikey - 1] : NIL;
        }
        return this.hashget(key);
    }

    protected LuaValue hashget(LuaValue key) {
        if (this.hashEntries > 0) {
            LuaValue v = this.hashValues[this.hashFindSlot(key)];
            return v != null ? v : NIL;
        }
        return NIL;
    }

    @Override
    public void set(int key, LuaValue value) {
        if (this.m_metatable == null || !this.rawget(key).isnil() || !LuaTable.settable(this, LuaInteger.valueOf(key), value)) {
            this.rawset(key, value);
        }
    }

    @Override
    public void set(LuaValue key, LuaValue value) {
        key.checkvalidkey();
        if (this.m_metatable == null || !this.rawget(key).isnil() || !LuaTable.settable(this, key, value)) {
            this.rawset(key, value);
        }
    }

    @Override
    public void rawset(int key, LuaValue value) {
        if (!this.arrayset(key, value)) {
            this.hashset(LuaInteger.valueOf(key), value);
        }
    }

    @Override
    public void rawset(LuaValue key, LuaValue value) {
        if (!key.isinttype() || !this.arrayset(key.toint(), value)) {
            this.hashset(key, value);
        }
    }

    private boolean arrayset(int key, LuaValue value) {
        if (key > 0 && key <= this.array.length) {
            this.array[key - 1] = value.isnil() ? null : value;
            return true;
        }
        if (key == this.array.length + 1 && !value.isnil()) {
            this.expandarray();
            this.array[key - 1] = value;
            return true;
        }
        return false;
    }

    private void expandarray() {
        int n = this.array.length;
        int m = Math.max(2, n * 2);
        this.array = LuaTable.resize(this.array, m);
        int i = n;
        while (i < m) {
            LuaInteger k = LuaInteger.valueOf(i + 1);
            LuaValue v = this.hashget(k);
            if (!v.isnil()) {
                this.hashset(k, NIL);
                this.array[i] = v;
            }
            ++i;
        }
    }

    public LuaValue remove(int pos) {
        LuaValue v;
        if (pos == 0) {
            pos = this.length();
        }
        LuaValue r = v = this.rawget(pos);
        while (!r.isnil()) {
            r = this.rawget(pos + 1);
            this.rawset(pos++, r);
        }
        return v.isnil() ? NONE : v;
    }

    public void insert(int pos, LuaValue value) {
        if (pos == 0) {
            pos = this.length() + 1;
        }
        while (!value.isnil()) {
            LuaValue v = this.rawget(pos);
            this.rawset(pos++, value);
            value = v;
        }
    }

    public LuaValue concat(LuaString sep, int i, int j) {
        Buffer sb = new Buffer();
        if (i <= j) {
            sb.append(this.get(i).checkstring());
            while (++i <= j) {
                sb.append(sep);
                sb.append(this.get(i).checkstring());
            }
        }
        return sb.tostring();
    }

    @Override
    public LuaValue getn() {
        int n = this.getArrayLength();
        while (n > 0) {
            if (!this.rawget(n).isnil()) {
                return LuaInteger.valueOf(n);
            }
            --n;
        }
        return ZERO;
    }

    @Override
    public int length() {
        int a = this.getArrayLength();
        int n = a + 1;
        int m = 0;
        while (!this.rawget(n).isnil()) {
            m = n;
            n += a + this.getHashLength() + 1;
        }
        while (n > m + 1) {
            int k = (n + m) / 2;
            if (!this.rawget(k).isnil()) {
                m = k;
                continue;
            }
            n = k;
        }
        return m;
    }

    @Override
    public LuaValue len() {
        return LuaInteger.valueOf(this.length());
    }

    public int maxn() {
        int n = 0;
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] != null) {
                n = i + 1;
            }
            ++i;
        }
        i = 0;
        while (i < this.hashKeys.length) {
            int key;
            LuaValue v = this.hashKeys[i];
            if (v != null && v.isinttype() && (key = v.toint()) > n) {
                n = key;
            }
            ++i;
        }
        return n;
    }

    @Override
    public Varargs next(LuaValue key) {
        int i = 0;
        if (!key.isnil()) {
            if (key.isinttype() && (i = key.toint()) > 0 && i <= this.array.length) {
                if (this.array[i - 1] == null) {
                    LuaTable.error("invalid key to 'next'");
                }
            } else {
                if (this.hashKeys.length == 0) {
                    LuaTable.error("invalid key to 'next'");
                }
                if (this.hashKeys[i = this.hashFindSlot(key)] == null) {
                    LuaTable.error("invalid key to 'next'");
                }
                i += 1 + this.array.length;
            }
        }
        while (i < this.array.length) {
            if (this.array[i] != null) {
                return LuaTable.varargsOf(LuaInteger.valueOf(i + 1), (Varargs)this.array[i]);
            }
            ++i;
        }
        i -= this.array.length;
        while (i < this.hashKeys.length) {
            if (this.hashKeys[i] != null) {
                return LuaTable.varargsOf(this.hashKeys[i], (Varargs)this.hashValues[i]);
            }
            ++i;
        }
        return NIL;
    }

    @Override
    public Varargs inext(LuaValue key) {
        int k = key.checkint() + 1;
        LuaValue v = this.rawget(k);
        return v.isnil() ? NONE : LuaTable.varargsOf(LuaInteger.valueOf(k), (Varargs)v);
    }

    public LuaValue foreach(LuaValue func) {
        Varargs n;
        LuaValue k = NIL;
        while (!(k = (n = this.next(k)).arg1()).isnil()) {
            LuaValue v = func.call(k, n.arg(2));
            if (v.isnil()) continue;
            return v;
        }
        return NIL;
    }

    public LuaValue foreachi(LuaValue func) {
        LuaValue v;
        int k = 0;
        while (!(v = this.rawget(++k)).isnil()) {
            LuaValue r = func.call(LuaTable.valueOf(k), v);
            if (r.isnil()) continue;
            return r;
        }
        return NIL;
    }

    public void hashset(LuaValue key, LuaValue value) {
        if (value.isnil()) {
            this.hashRemove(key);
        } else {
            int slot;
            if (this.hashKeys.length == 0) {
                this.hashKeys = new LuaValue[2];
                this.hashValues = new LuaValue[2];
            }
            if (this.hashFillSlot(slot = this.hashFindSlot(key), value)) {
                return;
            }
            this.hashKeys[slot] = key;
            this.hashValues[slot] = value;
            if (this.checkLoadFactor()) {
                this.rehash();
            }
        }
    }

    public int hashFindSlot(LuaValue key) {
        LuaValue k;
        int i = (key.hashCode() & Integer.MAX_VALUE) % this.hashKeys.length;
        while ((k = this.hashKeys[i]) != null && !k.raweq(key)) {
            i = (i + 1) % this.hashKeys.length;
        }
        return i;
    }

    private boolean hashFillSlot(int slot, LuaValue value) {
        this.hashValues[slot] = value;
        if (this.hashKeys[slot] != null) {
            return true;
        }
        ++this.hashEntries;
        return false;
    }

    private void hashRemove(LuaValue key) {
        if (this.hashKeys.length > 0) {
            int slot = this.hashFindSlot(key);
            this.hashClearSlot(slot);
        }
    }

    protected void hashClearSlot(int i) {
        if (this.hashKeys[i] != null) {
            int j = i;
            int n = this.hashKeys.length;
            while (this.hashKeys[j = (j + 1) % n] != null) {
                int k = (this.hashKeys[j].hashCode() & Integer.MAX_VALUE) % n;
                if ((j <= i || k > i && k <= j) && (j >= i || k > i || k <= j)) continue;
                this.hashKeys[i] = this.hashKeys[j];
                this.hashValues[i] = this.hashValues[j];
                i = j;
            }
            --this.hashEntries;
            this.hashKeys[i] = null;
            this.hashValues[i] = null;
            if (this.hashEntries == 0) {
                this.hashKeys = NOVALS;
                this.hashValues = NOVALS;
            }
        }
    }

    private boolean checkLoadFactor() {
        int hashCapacity = this.hashKeys.length;
        return this.hashEntries >= hashCapacity - (hashCapacity >> 3);
    }

    private void rehash() {
        int oldCapacity = this.hashKeys.length;
        int newCapacity = oldCapacity + (oldCapacity >> 2) + 2;
        LuaValue[] oldKeys = this.hashKeys;
        LuaValue[] oldValues = this.hashValues;
        this.hashKeys = new LuaValue[newCapacity];
        this.hashValues = new LuaValue[newCapacity];
        int i = 0;
        while (i < oldCapacity) {
            LuaValue k = oldKeys[i];
            if (k != null) {
                LuaValue v = oldValues[i];
                int slot = this.hashFindSlot(k);
                this.hashKeys[slot] = k;
                this.hashValues[slot] = v;
            }
            ++i;
        }
    }

    public void sort(LuaValue comparator) {
        int n = this.array.length;
        while (n > 0 && this.array[n - 1] == null) {
            --n;
        }
        if (n > 1) {
            this.heapSort(n, comparator);
        }
    }

    private void heapSort(int count, LuaValue cmpfunc) {
        this.heapify(count, cmpfunc);
        int end = count - 1;
        while (end > 0) {
            this.swap(end, 0);
            this.siftDown(0, --end, cmpfunc);
        }
    }

    private void heapify(int count, LuaValue cmpfunc) {
        int start = count / 2 - 1;
        while (start >= 0) {
            this.siftDown(start, count - 1, cmpfunc);
            --start;
        }
    }

    private void siftDown(int start, int end, LuaValue cmpfunc) {
        int root = start;
        while (root * 2 + 1 <= end) {
            int child = root * 2 + 1;
            if (child < end && this.compare(child, child + 1, cmpfunc)) {
                ++child;
            }
            if (this.compare(root, child, cmpfunc)) {
                this.swap(root, child);
                root = child;
                continue;
            }
            return;
        }
    }

    private boolean compare(int i, int j, LuaValue cmpfunc) {
        LuaValue a = this.array[i];
        LuaValue b = this.array[j];
        if (a == null || b == null) {
            return false;
        }
        if (!cmpfunc.isnil()) {
            return cmpfunc.call(a, b).toboolean();
        }
        return a.lt_b(b);
    }

    private void swap(int i, int j) {
        LuaValue a = this.array[i];
        this.array[i] = this.array[j];
        this.array[j] = a;
    }

    public int keyCount() {
        LuaValue k = LuaValue.NIL;
        int i = 0;
        Varargs n;
        while (!(k = (n = this.next(k)).arg1()).isnil()) {
            ++i;
        }
        return i;
    }

    public LuaValue[] keys() {
        Varargs n;
        Vector<LuaValue> l = new Vector<LuaValue>();
        LuaValue k = LuaValue.NIL;
        while (!(k = (n = this.next(k)).arg1()).isnil()) {
            l.addElement(k);
        }
        Object[] a = new LuaValue[l.size()];
        l.copyInto(a);
        return a;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return this.eq_b(val) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        if (this == val) {
            return true;
        }
        if (this.m_metatable == null || !val.istable()) {
            return false;
        }
        LuaValue valmt = val.getmetatable();
        return valmt != null && LuaValue.eqmtcall(this, this.m_metatable, val, valmt);
    }
}

