/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.DebugLib;

public class LuaThread
extends LuaValue
implements Runnable {
    public static LuaValue s_metatable;
    private static final int STATUS_SUSPENDED = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_NORMAL = 2;
    private static final int STATUS_DEAD = 3;
    private static final int STATUS_ERROR = 4;
    private static final String[] STATUS_NAMES;
    private int status = 0;
    private Thread thread;
    private LuaValue env;
    private LuaValue func;
    private Varargs args;
    public LuaValue err;
    public static final int MAX_CALLSTACK = 256;
    public final LuaFunction[] callstack = new LuaFunction[256];
    public int calls = 0;
    private static final LuaThread mainthread;
    private static LuaThread running_thread;
    public Object debugState;

    static {
        STATUS_NAMES = new String[]{"suspended", "running", "normal", "dead"};
        running_thread = mainthread = new LuaThread();
    }

    LuaThread() {
    }

    public LuaThread(LuaValue func, LuaValue env) {
        this.env = env;
        this.func = func;
    }

    @Override
    public int type() {
        return 8;
    }

    @Override
    public String typename() {
        return "thread";
    }

    @Override
    public boolean isthread() {
        return true;
    }

    @Override
    public LuaThread optthread(LuaThread defval) {
        return this;
    }

    @Override
    public LuaThread checkthread() {
        return this;
    }

    @Override
    public LuaValue getmetatable() {
        return s_metatable;
    }

    @Override
    public LuaValue getfenv() {
        return this.env;
    }

    @Override
    public void setfenv(LuaValue env) {
        this.env = env;
    }

    public String getStatus() {
        return STATUS_NAMES[this.status];
    }

    public static LuaThread getRunning() {
        return running_thread;
    }

    public static boolean isMainThread(LuaThread r) {
        return r == mainthread;
    }

    public static void setGlobals(LuaValue globals) {
        LuaThread.running_thread.env = globals;
    }

    public static LuaValue getGlobals() {
        LuaValue e = LuaThread.running_thread.env;
        return e != null ? e : LuaValue.error("LuaThread.setGlobals() not initialized");
    }

    public static final void onCall(LuaFunction function) {
        LuaThread.running_thread.callstack[LuaThread.running_thread.calls++] = function;
        if (DebugLib.DEBUG_ENABLED) {
            DebugLib.debugOnCall(running_thread, LuaThread.running_thread.calls, function);
        }
    }

    public static final void onReturn() {
        LuaThread.running_thread.callstack[--LuaThread.running_thread.calls] = null;
        if (DebugLib.DEBUG_ENABLED) {
            DebugLib.debugOnReturn(running_thread, LuaThread.running_thread.calls);
        }
    }

    public static int getCallstackDepth() {
        return LuaThread.running_thread.calls;
    }

    public static final LuaFunction getCallstackFunction(int level) {
        return level > 0 && level <= LuaThread.running_thread.calls ? LuaThread.running_thread.callstack[LuaThread.running_thread.calls - level] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LuaThread luaThread = this;
        synchronized (luaThread) {
            block8: {
                try {
                    try {
                        this.args = this.func.invoke(this.args);
                        this.status = 3;
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        this.args = LuaThread.valueOf(msg != null ? msg : t.toString());
                        this.status = 4;
                        this.notify();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.notify();
                    throw throwable;
                }
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Varargs yield(Varargs args) {
        LuaThread luaThread = this;
        synchronized (luaThread) {
            if (this.status != 1) {
                LuaThread.error(this + " not running");
            }
            this.status = 0;
            this.args = args;
            this.notify();
            try {
                this.wait();
                this.status = 1;
                return this.args;
            }
            catch (InterruptedException e) {
                this.status = 3;
                LuaThread.error("thread interrupted");
                return NONE;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Varargs resume(Varargs args) {
        LuaThread luaThread = this;
        synchronized (luaThread) {
            Varargs varargs;
            LuaThread prior;
            block14: {
                if (this.status == 3) {
                    return LuaThread.varargsOf(FALSE, (Varargs)LuaThread.valueOf("cannot resume dead coroutine"));
                }
                prior = running_thread;
                prior.status = 2;
                running_thread = this;
                this.status = 1;
                this.args = args;
                if (this.thread == null) {
                    this.thread = new Thread(this);
                    this.thread.start();
                }
                this.notify();
                this.wait();
                if (this.status != 4) break block14;
                this.status = 3;
                Varargs varargs2 = LuaThread.varargsOf(FALSE, this.args);
                running_thread = prior;
                prior.status = 1;
                return varargs2;
            }
            try {
                varargs = LuaThread.varargsOf(TRUE, this.args);
                running_thread = prior;
                prior.status = 1;
            }
            catch (Throwable t) {
                try {
                    Varargs varargs3;
                    this.status = 3;
                    try {
                        varargs3 = LuaThread.varargsOf(FALSE, (Varargs)LuaThread.valueOf("thread: " + t));
                        this.notify();
                    }
                    catch (Throwable throwable) {
                        this.notify();
                        throw throwable;
                    }
                    return varargs3;
                }
                finally {
                    running_thread = prior;
                    prior.status = 1;
                }
            }
            return varargs;
        }
    }
}

