/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;

public class Print
extends Lua {
    private static final String STRING_FOR_NULL = "null";
    public static PrintStream ps = System.out;
    public static final String[] OPNAMES;

    static {
        String[] stringArray = new String[39];
        stringArray[0] = "MOVE";
        stringArray[1] = "LOADK";
        stringArray[2] = "LOADBOOL";
        stringArray[3] = "LOADNIL";
        stringArray[4] = "GETUPVAL";
        stringArray[5] = "GETGLOBAL";
        stringArray[6] = "GETTABLE";
        stringArray[7] = "SETGLOBAL";
        stringArray[8] = "SETUPVAL";
        stringArray[9] = "SETTABLE";
        stringArray[10] = "NEWTABLE";
        stringArray[11] = "SELF";
        stringArray[12] = "ADD";
        stringArray[13] = "SUB";
        stringArray[14] = "MUL";
        stringArray[15] = "DIV";
        stringArray[16] = "MOD";
        stringArray[17] = "POW";
        stringArray[18] = "UNM";
        stringArray[19] = "NOT";
        stringArray[20] = "LEN";
        stringArray[21] = "CONCAT";
        stringArray[22] = "JMP";
        stringArray[23] = "EQ";
        stringArray[24] = "LT";
        stringArray[25] = "LE";
        stringArray[26] = "TEST";
        stringArray[27] = "TESTSET";
        stringArray[28] = "CALL";
        stringArray[29] = "TAILCALL";
        stringArray[30] = "RETURN";
        stringArray[31] = "FORLOOP";
        stringArray[32] = "FORPREP";
        stringArray[33] = "TFORLOOP";
        stringArray[34] = "SETLIST";
        stringArray[35] = "CLOSE";
        stringArray[36] = "CLOSURE";
        stringArray[37] = "VARARG";
        OPNAMES = stringArray;
    }

    static void printString(PrintStream ps, LuaString s) {
        ps.print('\"');
        int i = 0;
        int n = s.m_length;
        while (i < n) {
            byte c = s.m_bytes[s.m_offset + i];
            if (c >= 32 && c <= 126 && c != 34 && c != 92) {
                ps.print((char)c);
            } else {
                switch (c) {
                    case 34: {
                        ps.print("\\\"");
                        break;
                    }
                    case 92: {
                        ps.print("\\\\");
                        break;
                    }
                    case 7: {
                        ps.print("\\a");
                        break;
                    }
                    case 8: {
                        ps.print("\\b");
                        break;
                    }
                    case 12: {
                        ps.print("\\f");
                        break;
                    }
                    case 9: {
                        ps.print("\\t");
                        break;
                    }
                    case 13: {
                        ps.print("\\r");
                        break;
                    }
                    case 10: {
                        ps.print("\\n");
                        break;
                    }
                    case 11: {
                        ps.print("\\v");
                        break;
                    }
                    default: {
                        ps.print('\\');
                        ps.print(Integer.toString(0x4E7 & c).substring(1));
                    }
                }
            }
            ++i;
        }
        ps.print('\"');
    }

    static void printValue(PrintStream ps, LuaValue v) {
        switch (v.type()) {
            case 4: {
                Print.printString(ps, (LuaString)v);
                break;
            }
            default: {
                ps.print(v.tojstring());
            }
        }
    }

    static void printConstant(PrintStream ps, Prototype f, int i) {
        Print.printValue(ps, f.k[i]);
    }

    public static void printCode(Prototype f) {
        int[] code = f.code;
        int n = code.length;
        int pc = 0;
        while (pc < n) {
            Print.printOpCode(f, pc);
            ps.println();
            ++pc;
        }
    }

    public static void printOpCode(Prototype f, int pc) {
        Print.printOpCode(ps, f, pc);
    }

    public static void printOpCode(PrintStream ps, Prototype f, int pc) {
        int[] code = f.code;
        int i = code[pc];
        int o = Print.GET_OPCODE(i);
        int a = Print.GETARG_A(i);
        int b = Print.GETARG_B(i);
        int c = Print.GETARG_C(i);
        int bx = Print.GETARG_Bx(i);
        int sbx = Print.GETARG_sBx(i);
        int line = Print.getline(f, pc);
        ps.print("  " + (pc + 1) + "  ");
        if (line > 0) {
            ps.print("[" + line + "]  ");
        } else {
            ps.print("[-]  ");
        }
        ps.print(String.valueOf(OPNAMES[o]) + "  ");
        switch (Print.getOpMode(o)) {
            case 0: {
                ps.print(a);
                if (Print.getBMode(o) != 0) {
                    ps.print(" " + (Print.ISK(b) ? -1 - Print.INDEXK(b) : b));
                }
                if (Print.getCMode(o) == 0) break;
                ps.print(" " + (Print.ISK(c) ? -1 - Print.INDEXK(c) : c));
                break;
            }
            case 1: {
                if (Print.getBMode(o) == 3) {
                    ps.print(String.valueOf(a) + " " + (-1 - bx));
                    break;
                }
                ps.print(String.valueOf(a) + " " + bx);
                break;
            }
            case 2: {
                if (o == 22) {
                    ps.print(sbx);
                    break;
                }
                ps.print(String.valueOf(a) + " " + sbx);
            }
        }
        switch (o) {
            case 1: {
                ps.print("  ; ");
                Print.printConstant(ps, f, bx);
                break;
            }
            case 4: 
            case 8: {
                ps.print("  ; ");
                if (f.upvalues.length > b) {
                    Print.printValue(ps, f.upvalues[b]);
                    break;
                }
                ps.print("-");
                break;
            }
            case 5: 
            case 7: {
                ps.print("  ; ");
                Print.printConstant(ps, f, bx);
                break;
            }
            case 6: 
            case 11: {
                if (!Print.ISK(c)) break;
                ps.print("  ; ");
                Print.printConstant(ps, f, Print.INDEXK(c));
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                if (!Print.ISK(b) && !Print.ISK(c)) break;
                ps.print("  ; ");
                if (Print.ISK(b)) {
                    Print.printConstant(ps, f, Print.INDEXK(b));
                } else {
                    ps.print("-");
                }
                ps.print(" ");
                if (Print.ISK(c)) {
                    Print.printConstant(ps, f, Print.INDEXK(c));
                    break;
                }
                ps.print("-");
                break;
            }
            case 22: 
            case 31: 
            case 32: {
                ps.print("  ; to " + (sbx + pc + 2));
                break;
            }
            case 36: {
                ps.print("  ; " + f.p[bx].getClass().getName());
                break;
            }
            case 34: {
                if (c == 0) {
                    ps.print("  ; " + code[++pc]);
                    break;
                }
                ps.print("  ; " + c);
                break;
            }
            case 37: {
                ps.print("  ; is_vararg=" + f.is_vararg);
                break;
            }
        }
    }

    private static int getline(Prototype f, int pc) {
        return pc > 0 && f.lineinfo != null && pc < f.lineinfo.length ? f.lineinfo[pc] : -1;
    }

    static void printHeader(Prototype f) {
        String s = String.valueOf(f.source);
        s = s.startsWith("@") || s.startsWith("=") ? s.substring(1) : ("\u001bLua".equals(s) ? "(bstring)" : "(string)");
        String a = f.linedefined == 0 ? "main" : "function";
        ps.print("\n%" + a + " <" + s + ":" + f.linedefined + "," + f.lastlinedefined + "> (" + f.code.length + " instructions, " + f.code.length * 4 + " bytes at " + Print.id(f) + ")\n");
        ps.print(String.valueOf(f.numparams) + " param, " + f.maxstacksize + " slot, " + f.upvalues.length + " upvalue, ");
        ps.print(String.valueOf(f.locvars.length) + " local, " + f.k.length + " constant, " + f.p.length + " function\n");
    }

    static void printConstants(Prototype f) {
        int n = f.k.length;
        ps.print("constants (" + n + ") for " + Print.id(f) + ":\n");
        int i = 0;
        while (i < n) {
            ps.print("  " + (i + 1) + "  ");
            Print.printValue(ps, f.k[i]);
            ps.print("\n");
            ++i;
        }
    }

    static void printLocals(Prototype f) {
        int n = f.locvars.length;
        ps.print("locals (" + n + ") for " + Print.id(f) + ":\n");
        int i = 0;
        while (i < n) {
            ps.println("  " + i + "  " + f.locvars[i].varname + " " + (f.locvars[i].startpc + 1) + " " + (f.locvars[i].endpc + 1));
            ++i;
        }
    }

    static void printUpValues(Prototype f) {
        int n = f.upvalues.length;
        ps.print("upvalues (" + n + ") for " + Print.id(f) + ":\n");
        int i = 0;
        while (i < n) {
            ps.print("  " + i + "  " + f.upvalues[i] + "\n");
            ++i;
        }
    }

    public static void print(Prototype p) {
        Print.printFunction(p, true);
    }

    public static void printFunction(Prototype f, boolean full) {
        int n = f.p.length;
        Print.printHeader(f);
        Print.printCode(f);
        if (full) {
            Print.printConstants(f);
            Print.printLocals(f);
            Print.printUpValues(f);
        }
        int i = 0;
        while (i < n) {
            Print.printFunction(f.p[i], full);
            ++i;
        }
    }

    private static void format(String s, int maxcols) {
        int n = s.length();
        if (n > maxcols) {
            ps.print(s.substring(0, maxcols));
        } else {
            ps.print(s);
            int i = maxcols - n;
            while (--i >= 0) {
                ps.print(' ');
            }
        }
    }

    private static String id(Prototype f) {
        return "Proto";
    }

    private void _assert(boolean b) {
        if (!b) {
            throw new NullPointerException("_assert failed");
        }
    }

    public static void printState(LuaClosure cl, int pc, LuaValue[] stack, int top, Varargs varargs) {
        PrintStream previous = ps;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ps = new PrintStream(baos);
        Print.printOpCode(cl.p, pc);
        ps.flush();
        ps.close();
        ps = previous;
        Print.format(baos.toString(), 50);
        ps.print('[');
        int i = 0;
        while (i < stack.length) {
            LuaValue v = stack[i];
            if (v == null) {
                ps.print(STRING_FOR_NULL);
            } else {
                switch (v.type()) {
                    case 4: {
                        LuaString s = v.checkstring();
                        ps.print(s.length() < 48 ? s.tojstring() : String.valueOf(s.substring(0, 32).tojstring()) + "...+" + (s.length() - 32) + "b");
                        break;
                    }
                    case 6: {
                        ps.print(v instanceof LuaClosure ? ((LuaClosure)v).p.toString() : v.tojstring());
                        break;
                    }
                    case 7: {
                        Object o = v.touserdata();
                        if (o != null) {
                            String n = o.getClass().getName();
                            n = n.substring(n.lastIndexOf(46) + 1);
                            ps.print(String.valueOf(n) + ": " + Integer.toHexString(o.hashCode()));
                            break;
                        }
                        ps.print(v.toString());
                        break;
                    }
                    default: {
                        ps.print(v.tojstring());
                    }
                }
            }
            if (i + 1 == top) {
                ps.print(']');
            }
            ps.print(" | ");
            ++i;
        }
        ps.print(varargs);
        ps.println();
    }
}

