/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.TwoArgFunction;

public class WeakTable
extends LuaTable {
    private boolean weakkeys;
    private boolean weakvalues;

    public WeakTable(boolean weakkeys, boolean weakvalues) {
        this(weakkeys, weakvalues, 0, 0);
    }

    protected WeakTable(boolean weakkeys, boolean weakvalues, int narray, int nhash) {
        super(narray, nhash);
        this.weakkeys = weakkeys;
        this.weakvalues = weakvalues;
    }

    protected WeakTable(boolean weakkeys, boolean weakvalues, LuaTable source) {
        this(weakkeys, weakvalues, source.getArrayLength(), source.getHashLength());
        Varargs n;
        LuaValue k = NIL;
        while (!(k = (n = source.next(k)).arg1()).isnil()) {
            this.rawset(k, n.arg(2));
        }
        this.m_metatable = source.m_metatable;
    }

    @Override
    public void presize(int narray) {
        super.presize(narray);
    }

    @Override
    public void presize(int narray, int nhash) {
        super.presize(narray, nhash);
    }

    @Override
    protected int getArrayLength() {
        return super.getArrayLength();
    }

    @Override
    protected int getHashLength() {
        return super.getHashLength();
    }

    @Override
    protected LuaTable changemode(boolean weakkeys, boolean weakvalues) {
        this.weakkeys = weakkeys;
        this.weakvalues = weakvalues;
        return this;
    }

    LuaValue weaken(LuaValue value) {
        switch (value.type()) {
            case 5: 
            case 6: 
            case 8: {
                return new WeakValue(value);
            }
            case 7: {
                return new WeakUserdata(value);
            }
        }
        return value;
    }

    @Override
    public void rawset(int key, LuaValue value) {
        if (this.weakvalues) {
            value = this.weaken(value);
        }
        super.rawset(key, value);
    }

    @Override
    public void rawset(LuaValue key, LuaValue value) {
        if (this.weakvalues) {
            value = this.weaken(value);
        }
        if (this.weakkeys) {
            switch (key.type()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    key = value = new WeakEntry(this, key, value);
                    break;
                }
            }
        }
        super.rawset(key, value);
    }

    @Override
    public LuaValue rawget(int key) {
        return super.rawget(key).strongvalue();
    }

    @Override
    public LuaValue rawget(LuaValue key) {
        return super.rawget(key).strongvalue();
    }

    @Override
    protected LuaValue hashget(LuaValue key) {
        if (this.hashEntries > 0) {
            int i = this.hashFindSlot(key);
            if (this.hashEntries == 0) {
                return NIL;
            }
            LuaValue v = this.hashValues[i];
            return v != null ? v : NIL;
        }
        return NIL;
    }

    @Override
    public int hashFindSlot(LuaValue key) {
        LuaValue k;
        int i = (key.hashCode() & Integer.MAX_VALUE) % this.hashKeys.length;
        while ((k = this.hashKeys[i]) != null) {
            if (k.isweaknil()) {
                this.hashClearSlot(i);
                if (this.hashEntries != 0) continue;
                return 0;
            }
            if (k.raweq(key)) {
                return i;
            }
            i = (i + 1) % this.hashKeys.length;
        }
        return i;
    }

    @Override
    public int maxn() {
        return super.maxn();
    }

    @Override
    public Varargs next(LuaValue key) {
        LuaValue vs;
        LuaValue ks;
        while (true) {
            Varargs n;
            LuaValue k;
            if ((k = (n = super.next(key)).arg1()).isnil()) {
                return NIL;
            }
            ks = k.strongkey();
            vs = n.arg(2).strongvalue();
            if (!ks.isnil() && !vs.isnil()) break;
            super.rawset(ks, NIL);
        }
        return WeakTable.varargsOf(ks, (Varargs)vs);
    }

    @Override
    public void sort(final LuaValue comparator) {
        super.sort(new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                return comparator.call(arg1.strongvalue(), arg2.strongvalue());
            }
        });
    }

    static final class WeakEntry
    extends LuaValue {
        final LuaValue weakkey;
        LuaValue weakvalue;
        final int keyhash;

        private WeakEntry(WeakTable table, LuaValue key, LuaValue weakvalue) {
            this.weakkey = table.weaken(key);
            this.keyhash = key.hashCode();
            this.weakvalue = weakvalue;
        }

        @Override
        public LuaValue strongkey() {
            return this.weakkey.strongvalue();
        }

        @Override
        public LuaValue strongvalue() {
            LuaValue key = this.weakkey.strongvalue();
            if (key.isnil()) {
                this.weakvalue = NIL;
                return this.weakvalue;
            }
            return this.weakvalue.strongvalue();
        }

        @Override
        public int type() {
            return -1;
        }

        @Override
        public String typename() {
            this.illegal("typename", "weak entry");
            return null;
        }

        @Override
        public String toString() {
            return "weak<" + this.weakkey.strongvalue() + "," + this.strongvalue() + ">";
        }

        public int hashCode() {
            return this.keyhash;
        }

        @Override
        public boolean raweq(LuaValue rhs) {
            return this.weakkey.raweq(rhs);
        }

        @Override
        public boolean isweaknil() {
            return this.weakkey.isweaknil() || this.weakvalue.isweaknil();
        }
    }

    static final class WeakUserdata
    extends WeakValue {
        private final WeakReference ob;
        private final LuaValue mt;

        private WeakUserdata(LuaValue value) {
            super(value);
            this.ob = new WeakReference<Object>(value.touserdata());
            this.mt = value.getmetatable();
        }

        @Override
        public LuaValue strongvalue() {
            Object u = this.ref.get();
            if (u != null) {
                return (LuaValue)u;
            }
            Object o = this.ob.get();
            return o != null ? WeakUserdata.userdataOf(o, this.mt) : NIL;
        }

        @Override
        public boolean raweq(LuaValue rhs) {
            if (!rhs.isuserdata()) {
                return false;
            }
            LuaValue v = (LuaValue)this.ref.get();
            if (v != null && v.raweq(rhs)) {
                return true;
            }
            return rhs.touserdata() == this.ob.get();
        }

        @Override
        public boolean isweaknil() {
            return this.ob.get() == null || this.ref.get() == null;
        }
    }

    static class WeakValue
    extends LuaValue {
        final WeakReference ref;

        protected WeakValue(LuaValue value) {
            this.ref = new WeakReference<LuaValue>(value);
        }

        @Override
        public int type() {
            this.illegal("type", "weak value");
            return 0;
        }

        @Override
        public String typename() {
            this.illegal("typename", "weak value");
            return null;
        }

        @Override
        public String toString() {
            return "weak<" + this.ref.get() + ">";
        }

        @Override
        public LuaValue strongvalue() {
            Object o = this.ref.get();
            return o != null ? (LuaValue)o : NIL;
        }

        @Override
        public boolean raweq(LuaValue rhs) {
            Object o = this.ref.get();
            return o != null && rhs.raweq((LuaValue)o);
        }

        @Override
        public boolean isweaknil() {
            return this.ref.get() == null;
        }
    }
}

