/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.util.Hashtable;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.IntPtr;
import org.luaj.vm2.compiler.LexState;
import org.luaj.vm2.compiler.LuaC;

public class FuncState
extends LuaC {
    Prototype f;
    Hashtable htable;
    FuncState prev;
    LexState ls;
    LuaC L;
    BlockCnt bl;
    int pc;
    int lasttarget;
    IntPtr jpc;
    int freereg;
    int nk;
    int np;
    short nlocvars;
    short nactvar;
    upvaldesc[] upvalues = new upvaldesc[60];
    short[] actvar = new short[200];

    FuncState() {
    }

    InstructionPtr getcodePtr(LexState.expdesc e) {
        return new InstructionPtr(this.f.code, e.u.s.info);
    }

    int getcode(LexState.expdesc e) {
        return this.f.code[e.u.s.info];
    }

    int codeAsBx(int o, int A, int sBx) {
        return this.codeABx(o, A, sBx + 131071);
    }

    void setmultret(LexState.expdesc e) {
        this.setreturns(e, -1);
    }

    LocVars getlocvar(int i) {
        return this.f.locvars[this.actvar[i]];
    }

    void checklimit(int v, int l, String msg) {
        if (v > l) {
            this.errorlimit(l, msg);
        }
    }

    void errorlimit(int limit, String what) {
        String msg = this.f.linedefined == 0 ? this.L.pushfstring("main function has more than " + limit + " " + what) : this.L.pushfstring("function at line " + this.f.linedefined + " has more than " + limit + " " + what);
        this.ls.lexerror(msg, 0);
    }

    int indexupvalue(LuaString name, LexState.expdesc v) {
        int i = 0;
        while (i < this.f.nups) {
            if (this.upvalues[i].k == v.k && this.upvalues[i].info == v.u.s.info) {
                FuncState._assert(this.f.upvalues[i] == name);
                return i;
            }
            ++i;
        }
        this.checklimit(this.f.nups + 1, 60, "upvalues");
        if (this.f.upvalues == null || this.f.nups + 1 > this.f.upvalues.length) {
            this.f.upvalues = FuncState.realloc(this.f.upvalues, this.f.nups * 2 + 1);
        }
        this.f.upvalues[this.f.nups] = name;
        FuncState._assert(v.k == 6 || v.k == 7);
        this.upvalues[this.f.nups] = new upvaldesc();
        this.upvalues[this.f.nups].k = (short)v.k;
        this.upvalues[this.f.nups].info = (short)v.u.s.info;
        return this.f.nups++;
    }

    int searchvar(LuaString n) {
        int i = this.nactvar - 1;
        while (i >= 0) {
            if (n == this.getlocvar((int)i).varname) {
                return i;
            }
            --i;
        }
        return -1;
    }

    void markupval(int level) {
        BlockCnt bl = this.bl;
        while (bl != null && bl.nactvar > level) {
            bl = bl.previous;
        }
        if (bl != null) {
            bl.upval = true;
        }
    }

    int singlevaraux(LuaString n, LexState.expdesc var, int base) {
        int v = this.searchvar(n);
        if (v >= 0) {
            var.init(6, v);
            if (base == 0) {
                this.markupval(v);
            }
            return 6;
        }
        if (this.prev == null) {
            var.init(8, 255);
            return 8;
        }
        if (this.prev.singlevaraux(n, var, 0) == 8) {
            return 8;
        }
        var.u.s.info = this.indexupvalue(n, var);
        var.k = 7;
        return 7;
    }

    void enterblock(BlockCnt bl, boolean isbreakable) {
        bl.breaklist.i = -1;
        bl.isbreakable = isbreakable;
        bl.nactvar = this.nactvar;
        bl.upval = false;
        bl.previous = this.bl;
        this.bl = bl;
        FuncState._assert(this.freereg == this.nactvar);
    }

    void leaveblock() {
        BlockCnt bl = this.bl;
        this.bl = bl.previous;
        this.ls.removevars(bl.nactvar);
        if (bl.upval) {
            this.codeABC(35, bl.nactvar, 0, 0);
        }
        FuncState._assert(!bl.isbreakable || !bl.upval);
        FuncState._assert(bl.nactvar == this.nactvar);
        this.freereg = this.nactvar;
        this.patchtohere(bl.breaklist.i);
    }

    void closelistfield(LexState.ConsControl cc) {
        if (cc.v.k == 0) {
            return;
        }
        this.exp2nextreg(cc.v);
        cc.v.k = 0;
        if (cc.tostore == 50) {
            this.setlist(cc.t.u.s.info, cc.na, cc.tostore);
            cc.tostore = 0;
        }
    }

    boolean hasmultret(int k) {
        return k == 13 || k == 14;
    }

    void lastlistfield(LexState.ConsControl cc) {
        if (cc.tostore == 0) {
            return;
        }
        if (this.hasmultret(cc.v.k)) {
            this.setmultret(cc.v);
            this.setlist(cc.t.u.s.info, cc.na, -1);
            --cc.na;
        } else {
            if (cc.v.k != 0) {
                this.exp2nextreg(cc.v);
            }
            this.setlist(cc.t.u.s.info, cc.na, cc.tostore);
        }
    }

    void nil(int from, int n) {
        if (this.pc > this.lasttarget) {
            if (this.pc == 0) {
                if (from >= this.nactvar) {
                    return;
                }
            } else {
                InstructionPtr previous = new InstructionPtr(this.f.code, this.pc - 1);
                if (FuncState.GET_OPCODE(previous.get()) == 3) {
                    int pfrom = FuncState.GETARG_A(previous.get());
                    int pto = FuncState.GETARG_B(previous.get());
                    if (pfrom <= from && from <= pto + 1) {
                        if (from + n - 1 > pto) {
                            FuncState.SETARG_B(previous, from + n - 1);
                        }
                        return;
                    }
                }
            }
        }
        this.codeABC(3, from, from + n - 1, 0);
    }

    int jump() {
        int jpc = this.jpc.i;
        this.jpc.i = -1;
        IntPtr j = new IntPtr(this.codeAsBx(22, 0, -1));
        this.concat(j, jpc);
        return j.i;
    }

    void ret(int first, int nret) {
        this.codeABC(30, first, nret + 1, 0);
    }

    int condjump(int op, int A, int B, int C) {
        this.codeABC(op, A, B, C);
        return this.jump();
    }

    void fixjump(int pc, int dest) {
        InstructionPtr jmp = new InstructionPtr(this.f.code, pc);
        int offset = dest - (pc + 1);
        FuncState._assert(dest != -1);
        if (Math.abs(offset) > 131071) {
            this.ls.syntaxerror("control structure too long");
        }
        FuncState.SETARG_sBx(jmp, offset);
    }

    int getlabel() {
        this.lasttarget = this.pc;
        return this.pc;
    }

    int getjump(int pc) {
        int offset = FuncState.GETARG_sBx(this.f.code[pc]);
        if (offset == -1) {
            return -1;
        }
        return pc + 1 + offset;
    }

    InstructionPtr getjumpcontrol(int pc) {
        InstructionPtr pi = new InstructionPtr(this.f.code, pc);
        if (pc >= 1 && FuncState.testTMode(FuncState.GET_OPCODE(pi.code[pi.idx - 1]))) {
            return new InstructionPtr(pi.code, pi.idx - 1);
        }
        return pi;
    }

    boolean need_value(int list) {
        while (list != -1) {
            int i = this.getjumpcontrol(list).get();
            if (FuncState.GET_OPCODE(i) != 27) {
                return true;
            }
            list = this.getjump(list);
        }
        return false;
    }

    boolean patchtestreg(int node, int reg) {
        InstructionPtr i = this.getjumpcontrol(node);
        if (FuncState.GET_OPCODE(i.get()) != 27) {
            return false;
        }
        if (reg != 255 && reg != FuncState.GETARG_B(i.get())) {
            FuncState.SETARG_A(i, reg);
        } else {
            i.set(FuncState.CREATE_ABC(26, FuncState.GETARG_B(i.get()), 0, Lua.GETARG_C(i.get())));
        }
        return true;
    }

    void removevalues(int list) {
        while (list != -1) {
            this.patchtestreg(list, 255);
            list = this.getjump(list);
        }
    }

    void patchlistaux(int list, int vtarget, int reg, int dtarget) {
        while (list != -1) {
            int next = this.getjump(list);
            if (this.patchtestreg(list, reg)) {
                this.fixjump(list, vtarget);
            } else {
                this.fixjump(list, dtarget);
            }
            list = next;
        }
    }

    void dischargejpc() {
        this.patchlistaux(this.jpc.i, this.pc, 255, this.pc);
        this.jpc.i = -1;
    }

    void patchlist(int list, int target) {
        if (target == this.pc) {
            this.patchtohere(list);
        } else {
            FuncState._assert(target < this.pc);
            this.patchlistaux(list, target, 255, target);
        }
    }

    void patchtohere(int list) {
        this.getlabel();
        this.concat(this.jpc, list);
    }

    void concat(IntPtr l1, int l2) {
        if (l2 == -1) {
            return;
        }
        if (l1.i == -1) {
            l1.i = l2;
        } else {
            int next;
            int list = l1.i;
            while ((next = this.getjump(list)) != -1) {
                list = next;
            }
            this.fixjump(list, l2);
        }
    }

    void checkstack(int n) {
        int newstack = this.freereg + n;
        if (newstack > this.f.maxstacksize) {
            if (newstack >= 250) {
                this.ls.syntaxerror("function or expression too complex");
            }
            this.f.maxstacksize = newstack;
        }
    }

    void reserveregs(int n) {
        this.checkstack(n);
        this.freereg += n;
    }

    void freereg(int reg) {
        if (!FuncState.ISK(reg) && reg >= this.nactvar) {
            --this.freereg;
            FuncState._assert(reg == this.freereg);
        }
    }

    void freeexp(LexState.expdesc e) {
        if (e.k == 12) {
            this.freereg(e.u.s.info);
        }
    }

    int addk(LuaValue v) {
        int idx;
        if (this.htable.containsKey(v)) {
            idx = (Integer)this.htable.get(v);
        } else {
            idx = this.nk;
            this.htable.put(v, new Integer(idx));
            Prototype f = this.f;
            if (f.k == null || this.nk + 1 >= f.k.length) {
                f.k = FuncState.realloc(f.k, this.nk * 2 + 1);
            }
            f.k[this.nk++] = v;
        }
        return idx;
    }

    int stringK(LuaString s) {
        return this.addk(s);
    }

    int numberK(LuaValue r) {
        int i;
        double d;
        if (r instanceof LuaDouble && (d = r.todouble()) == (double)(i = (int)d)) {
            r = LuaInteger.valueOf(i);
        }
        return this.addk(r);
    }

    int boolK(boolean b) {
        return this.addk(b ? LuaValue.TRUE : LuaValue.FALSE);
    }

    int nilK() {
        return this.addk(LuaValue.NIL);
    }

    void setreturns(LexState.expdesc e, int nresults) {
        if (e.k == 13) {
            FuncState.SETARG_C(this.getcodePtr(e), nresults + 1);
        } else if (e.k == 14) {
            FuncState.SETARG_B(this.getcodePtr(e), nresults + 1);
            FuncState.SETARG_A(this.getcodePtr(e), this.freereg);
            this.reserveregs(1);
        }
    }

    void setoneret(LexState.expdesc e) {
        if (e.k == 13) {
            e.k = 12;
            e.u.s.info = FuncState.GETARG_A(this.getcode(e));
        } else if (e.k == 14) {
            FuncState.SETARG_B(this.getcodePtr(e), 2);
            e.k = 11;
        }
    }

    void dischargevars(LexState.expdesc e) {
        switch (e.k) {
            case 6: {
                e.k = 12;
                break;
            }
            case 7: {
                e.u.s.info = this.codeABC(4, 0, e.u.s.info, 0);
                e.k = 11;
                break;
            }
            case 8: {
                e.u.s.info = this.codeABx(5, 0, e.u.s.info);
                e.k = 11;
                break;
            }
            case 9: {
                this.freereg(e.u.s.aux);
                this.freereg(e.u.s.info);
                e.u.s.info = this.codeABC(6, 0, e.u.s.info, e.u.s.aux);
                e.k = 11;
                break;
            }
            case 13: 
            case 14: {
                this.setoneret(e);
                break;
            }
        }
    }

    int code_label(int A, int b, int jump) {
        this.getlabel();
        return this.codeABC(2, A, b, jump);
    }

    void discharge2reg(LexState.expdesc e, int reg) {
        this.dischargevars(e);
        switch (e.k) {
            case 1: {
                this.nil(reg, 1);
                break;
            }
            case 2: 
            case 3: {
                this.codeABC(2, reg, e.k == 2 ? 1 : 0, 0);
                break;
            }
            case 4: {
                this.codeABx(1, reg, e.u.s.info);
                break;
            }
            case 5: {
                this.codeABx(1, reg, this.numberK(e.u.nval()));
                break;
            }
            case 11: {
                InstructionPtr pc = this.getcodePtr(e);
                FuncState.SETARG_A(pc, reg);
                break;
            }
            case 12: {
                if (reg == e.u.s.info) break;
                this.codeABC(0, reg, e.u.s.info, 0);
                break;
            }
            default: {
                FuncState._assert(e.k == 0 || e.k == 10);
                return;
            }
        }
        e.u.s.info = reg;
        e.k = 12;
    }

    void discharge2anyreg(LexState.expdesc e) {
        if (e.k != 12) {
            this.reserveregs(1);
            this.discharge2reg(e, this.freereg - 1);
        }
    }

    void exp2reg(LexState.expdesc e, int reg) {
        this.discharge2reg(e, reg);
        if (e.k == 10) {
            this.concat(e.t, e.u.s.info);
        }
        if (e.hasjumps()) {
            int p_f = -1;
            int p_t = -1;
            if (this.need_value(e.t.i) || this.need_value(e.f.i)) {
                int fj = e.k == 10 ? -1 : this.jump();
                p_f = this.code_label(reg, 0, 1);
                p_t = this.code_label(reg, 1, 0);
                this.patchtohere(fj);
            }
            int _final = this.getlabel();
            this.patchlistaux(e.f.i, _final, reg, p_f);
            this.patchlistaux(e.t.i, _final, reg, p_t);
        }
        e.t.i = -1;
        e.f.i = -1;
        e.u.s.info = reg;
        e.k = 12;
    }

    void exp2nextreg(LexState.expdesc e) {
        this.dischargevars(e);
        this.freeexp(e);
        this.reserveregs(1);
        this.exp2reg(e, this.freereg - 1);
    }

    int exp2anyreg(LexState.expdesc e) {
        this.dischargevars(e);
        if (e.k == 12) {
            if (!e.hasjumps()) {
                return e.u.s.info;
            }
            if (e.u.s.info >= this.nactvar) {
                this.exp2reg(e, e.u.s.info);
                return e.u.s.info;
            }
        }
        this.exp2nextreg(e);
        return e.u.s.info;
    }

    void exp2val(LexState.expdesc e) {
        if (e.hasjumps()) {
            this.exp2anyreg(e);
        } else {
            this.dischargevars(e);
        }
    }

    int exp2RK(LexState.expdesc e) {
        this.exp2val(e);
        switch (e.k) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.nk > 255) break;
                e.u.s.info = e.k == 1 ? this.nilK() : (e.k == 5 ? this.numberK(e.u.nval()) : this.boolK(e.k == 2));
                e.k = 4;
                return FuncState.RKASK(e.u.s.info);
            }
            case 4: {
                if (e.u.s.info > 255) break;
                return FuncState.RKASK(e.u.s.info);
            }
        }
        return this.exp2anyreg(e);
    }

    void storevar(LexState.expdesc var, LexState.expdesc ex) {
        switch (var.k) {
            case 6: {
                this.freeexp(ex);
                this.exp2reg(ex, var.u.s.info);
                return;
            }
            case 7: {
                int e = this.exp2anyreg(ex);
                this.codeABC(8, e, var.u.s.info, 0);
                break;
            }
            case 8: {
                int e = this.exp2anyreg(ex);
                this.codeABx(7, e, var.u.s.info);
                break;
            }
            case 9: {
                int e = this.exp2RK(ex);
                this.codeABC(9, var.u.s.info, var.u.s.aux, e);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        this.freeexp(ex);
    }

    void self(LexState.expdesc e, LexState.expdesc key) {
        this.exp2anyreg(e);
        this.freeexp(e);
        int func = this.freereg;
        this.reserveregs(2);
        this.codeABC(11, func, e.u.s.info, this.exp2RK(key));
        this.freeexp(key);
        e.u.s.info = func;
        e.k = 12;
    }

    void invertjump(LexState.expdesc e) {
        InstructionPtr pc = this.getjumpcontrol(e.u.s.info);
        FuncState._assert(FuncState.testTMode(FuncState.GET_OPCODE(pc.get())) && FuncState.GET_OPCODE(pc.get()) != 27 && Lua.GET_OPCODE(pc.get()) != 26);
        int a = FuncState.GETARG_A(pc.get());
        int nota = a != 0 ? 0 : 1;
        FuncState.SETARG_A(pc, nota);
    }

    int jumponcond(LexState.expdesc e, int cond) {
        int ie;
        if (e.k == 11 && FuncState.GET_OPCODE(ie = this.getcode(e)) == 19) {
            --this.pc;
            return this.condjump(26, FuncState.GETARG_B(ie), 0, cond != 0 ? 0 : 1);
        }
        this.discharge2anyreg(e);
        this.freeexp(e);
        return this.condjump(27, 255, e.u.s.info, cond);
    }

    void goiftrue(LexState.expdesc e) {
        int pc;
        this.dischargevars(e);
        switch (e.k) {
            case 2: 
            case 4: 
            case 5: {
                pc = -1;
                break;
            }
            case 3: {
                pc = this.jump();
                break;
            }
            case 10: {
                this.invertjump(e);
                pc = e.u.s.info;
                break;
            }
            default: {
                pc = this.jumponcond(e, 0);
            }
        }
        this.concat(e.f, pc);
        this.patchtohere(e.t.i);
        e.t.i = -1;
    }

    void goiffalse(LexState.expdesc e) {
        int pc;
        this.dischargevars(e);
        switch (e.k) {
            case 1: 
            case 3: {
                pc = -1;
                break;
            }
            case 2: {
                pc = this.jump();
                break;
            }
            case 10: {
                pc = e.u.s.info;
                break;
            }
            default: {
                pc = this.jumponcond(e, 1);
            }
        }
        this.concat(e.t, pc);
        this.patchtohere(e.f.i);
        e.f.i = -1;
    }

    void codenot(LexState.expdesc e) {
        this.dischargevars(e);
        switch (e.k) {
            case 1: 
            case 3: {
                e.k = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                e.k = 3;
                break;
            }
            case 10: {
                this.invertjump(e);
                break;
            }
            case 11: 
            case 12: {
                this.discharge2anyreg(e);
                this.freeexp(e);
                e.u.s.info = this.codeABC(19, 0, e.u.s.info, 0);
                e.k = 11;
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        int temp = e.f.i;
        e.f.i = e.t.i;
        e.t.i = temp;
        this.removevalues(e.f.i);
        this.removevalues(e.t.i);
    }

    void indexed(LexState.expdesc t, LexState.expdesc k) {
        t.u.s.aux = this.exp2RK(k);
        t.k = 9;
    }

    boolean constfolding(int op, LexState.expdesc e1, LexState.expdesc e2) {
        LuaValue r;
        if (!e1.isnumeral() || !e2.isnumeral()) {
            return false;
        }
        LuaValue v1 = e1.u.nval();
        LuaValue v2 = e2.u.nval();
        switch (op) {
            case 12: {
                r = v1.add(v2);
                break;
            }
            case 13: {
                r = v1.sub(v2);
                break;
            }
            case 14: {
                r = v1.mul(v2);
                break;
            }
            case 15: {
                r = v1.div(v2);
                break;
            }
            case 16: {
                r = v1.mod(v2);
                break;
            }
            case 17: {
                r = v1.pow(v2);
                break;
            }
            case 18: {
                r = v1.neg();
                break;
            }
            case 20: {
                return false;
            }
            default: {
                FuncState._assert(false);
                r = null;
            }
        }
        if (Double.isNaN(r.todouble())) {
            return false;
        }
        e1.u.setNval(r);
        return true;
    }

    void codearith(int op, LexState.expdesc e1, LexState.expdesc e2) {
        if (this.constfolding(op, e1, e2)) {
            return;
        }
        int o2 = op != 18 && op != 20 ? this.exp2RK(e2) : 0;
        int o1 = this.exp2RK(e1);
        if (o1 > o2) {
            this.freeexp(e1);
            this.freeexp(e2);
        } else {
            this.freeexp(e2);
            this.freeexp(e1);
        }
        e1.u.s.info = this.codeABC(op, 0, o1, o2);
        e1.k = 11;
    }

    void codecomp(int op, int cond, LexState.expdesc e1, LexState.expdesc e2) {
        int o1 = this.exp2RK(e1);
        int o2 = this.exp2RK(e2);
        this.freeexp(e2);
        this.freeexp(e1);
        if (cond == 0 && op != 23) {
            int temp = o1;
            o1 = o2;
            o2 = temp;
            cond = 1;
        }
        e1.u.s.info = this.condjump(op, cond, o1, o2);
        e1.k = 10;
    }

    void prefix(int op, LexState.expdesc e) {
        LexState.expdesc e2 = new LexState.expdesc();
        e2.init(5, 0);
        switch (op) {
            case 0: {
                if (e.k == 4) {
                    this.exp2anyreg(e);
                }
                this.codearith(18, e, e2);
                break;
            }
            case 1: {
                this.codenot(e);
                break;
            }
            case 2: {
                this.exp2anyreg(e);
                this.codearith(20, e, e2);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void infix(int op, LexState.expdesc v) {
        switch (op) {
            case 13: {
                this.goiftrue(v);
                break;
            }
            case 14: {
                this.goiffalse(v);
                break;
            }
            case 6: {
                this.exp2nextreg(v);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (v.isnumeral()) break;
                this.exp2RK(v);
                break;
            }
            default: {
                this.exp2RK(v);
            }
        }
    }

    void posfix(int op, LexState.expdesc e1, LexState.expdesc e2) {
        switch (op) {
            case 13: {
                FuncState._assert(e1.t.i == -1);
                this.dischargevars(e2);
                this.concat(e2.f, e1.f.i);
                e1.setvalue(e2);
                break;
            }
            case 14: {
                FuncState._assert(e1.f.i == -1);
                this.dischargevars(e2);
                this.concat(e2.t, e1.t.i);
                e1.setvalue(e2);
                break;
            }
            case 6: {
                this.exp2val(e2);
                if (e2.k == 11 && FuncState.GET_OPCODE(this.getcode(e2)) == 21) {
                    FuncState._assert(e1.u.s.info == FuncState.GETARG_B(this.getcode(e2)) - 1);
                    this.freeexp(e1);
                    FuncState.SETARG_B(this.getcodePtr(e2), e1.u.s.info);
                    e1.k = 11;
                    e1.u.s.info = e2.u.s.info;
                    break;
                }
                this.exp2nextreg(e2);
                this.codearith(21, e1, e2);
                break;
            }
            case 0: {
                this.codearith(12, e1, e2);
                break;
            }
            case 1: {
                this.codearith(13, e1, e2);
                break;
            }
            case 2: {
                this.codearith(14, e1, e2);
                break;
            }
            case 3: {
                this.codearith(15, e1, e2);
                break;
            }
            case 4: {
                this.codearith(16, e1, e2);
                break;
            }
            case 5: {
                this.codearith(17, e1, e2);
                break;
            }
            case 8: {
                this.codecomp(23, 1, e1, e2);
                break;
            }
            case 7: {
                this.codecomp(23, 0, e1, e2);
                break;
            }
            case 9: {
                this.codecomp(24, 1, e1, e2);
                break;
            }
            case 10: {
                this.codecomp(25, 1, e1, e2);
                break;
            }
            case 11: {
                this.codecomp(24, 0, e1, e2);
                break;
            }
            case 12: {
                this.codecomp(25, 0, e1, e2);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void fixline(int line) {
        this.f.lineinfo[this.pc - 1] = line;
    }

    int code(int instruction, int line) {
        Prototype f = this.f;
        this.dischargejpc();
        if (f.code == null || this.pc + 1 > f.code.length) {
            f.code = LuaC.realloc(f.code, this.pc * 2 + 1);
        }
        f.code[this.pc] = instruction;
        if (f.lineinfo == null || this.pc + 1 > f.lineinfo.length) {
            f.lineinfo = LuaC.realloc(f.lineinfo, this.pc * 2 + 1);
        }
        f.lineinfo[this.pc] = line;
        return this.pc++;
    }

    int codeABC(int o, int a, int b, int c) {
        FuncState._assert(FuncState.getOpMode(o) == 0);
        FuncState._assert(FuncState.getBMode(o) != 0 || b == 0);
        FuncState._assert(FuncState.getCMode(o) != 0 || c == 0);
        return this.code(FuncState.CREATE_ABC(o, a, b, c), this.ls.lastline);
    }

    int codeABx(int o, int a, int bc) {
        FuncState._assert(FuncState.getOpMode(o) == 1 || FuncState.getOpMode(o) == 2);
        FuncState._assert(FuncState.getCMode(o) == 0);
        return this.code(FuncState.CREATE_ABx(o, a, bc), this.ls.lastline);
    }

    void setlist(int base, int nelems, int tostore) {
        int c = (nelems - 1) / 50 + 1;
        int b = tostore == -1 ? 0 : tostore;
        FuncState._assert(tostore != 0);
        if (c <= 511) {
            this.codeABC(34, base, b, c);
        } else {
            this.codeABC(34, base, b, 0);
            this.code(c, this.ls.lastline);
        }
        this.freereg = base + 1;
    }

    static class BlockCnt {
        BlockCnt previous;
        IntPtr breaklist = new IntPtr();
        short nactvar;
        boolean upval;
        boolean isbreakable;

        BlockCnt() {
        }
    }

    class upvaldesc {
        short k;
        short info;

        upvaldesc() {
        }
    }
}

