/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.LexState;

public class LuaC
extends Lua
implements LoadState.LuaCompiler {
    public static final LuaC instance = new LuaC();
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVALUES = 60;
    static final int LUAI_MAXVARS = 200;
    static final int NO_REG = 255;
    static final int iABC = 0;
    static final int iABx = 1;
    static final int iAsBx = 2;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;
    public int nCcalls;
    Hashtable strings;

    public static void install() {
        LoadState.compiler = instance;
    }

    protected static void _assert(boolean b) {
        if (!b) {
            throw new LuaError("compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr i, int o) {
        i.set(i.get() & 0xFFFFFFC0 | o << 0 & 0x3F);
    }

    static void SETARG_A(InstructionPtr i, int u) {
        i.set(i.get() & 0xFFFFC03F | u << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr i, int u) {
        i.set(i.get() & 0x7FFFFF | u << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr i, int u) {
        i.set(i.get() & 0xFF803FFF | u << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr i, int u) {
        i.set(i.get() & 0x3FFF | u << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr i, int u) {
        LuaC.SETARG_Bx(i, u + 131071);
    }

    static int CREATE_ABC(int o, int a, int b, int c) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | b << 23 & 0xFF800000 | c << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int o, int a, int bc) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | bc << 14 & 0xFFFFC000;
    }

    static LuaValue[] realloc(LuaValue[] v, int n) {
        LuaValue[] a = new LuaValue[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static Prototype[] realloc(Prototype[] v, int n) {
        Prototype[] a = new Prototype[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static LuaString[] realloc(LuaString[] v, int n) {
        LuaString[] a = new LuaString[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static LocVars[] realloc(LocVars[] v, int n) {
        LocVars[] a = new LocVars[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static int[] realloc(int[] v, int n) {
        int[] a = new int[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static byte[] realloc(byte[] v, int n) {
        byte[] a = new byte[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    protected LuaC() {
    }

    private LuaC(Hashtable strings) {
        this.strings = strings;
    }

    @Override
    public LuaFunction load(InputStream stream, String name, LuaValue env) throws IOException {
        Prototype p = LuaC.compile(stream, name);
        return new LuaClosure(p, env);
    }

    public static Prototype compile(InputStream stream, String name) throws IOException {
        int firstByte = stream.read();
        return firstByte == 27 ? LoadState.loadBinaryChunk(firstByte, stream, name) : new LuaC(new Hashtable()).luaY_parser(firstByte, stream, name);
    }

    private Prototype luaY_parser(int firstByte, InputStream z, String name) {
        LexState lexstate = new LexState(this, z);
        FuncState funcstate = new FuncState();
        lexstate.setinput(this, firstByte, z, LuaValue.valueOf(name));
        lexstate.open_func(funcstate);
        funcstate.f.is_vararg = 2;
        funcstate.f.source = LuaValue.valueOf(name);
        lexstate.next();
        lexstate.chunk();
        lexstate.check(287);
        lexstate.close_func();
        LuaC._assert(funcstate.prev == null);
        LuaC._assert(funcstate.f.nups == 0);
        LuaC._assert(lexstate.fs == null);
        return funcstate.f;
    }

    public LuaString newTString(byte[] bytes, int offset, int len) {
        LuaString tmp = LuaString.valueOf(bytes, offset, len);
        LuaString v = (LuaString)this.strings.get(tmp);
        if (v == null) {
            byte[] copy = new byte[len];
            System.arraycopy(bytes, offset, copy, 0, len);
            v = LuaString.valueOf(copy);
            this.strings.put(v, v);
        }
        return v;
    }

    public String pushfstring(String string) {
        return string;
    }

    public LuaFunction load(Prototype p, String filename, LuaValue env) {
        return new LuaClosure(p, env);
    }
}

