/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class BaseLib
extends OneArgFunction
implements ResourceFinder {
    public static final String VERSION = "Luaj 2.0";
    public static BaseLib instance;
    public InputStream STDIN = null;
    public PrintStream STDOUT = System.out;
    public PrintStream STDERR = System.err;
    public static ResourceFinder FINDER;
    private LuaValue next;
    private LuaValue inext;
    private static final String[] LIB2_KEYS;
    private static final String[] LIBV_KEYS;

    static {
        LIB2_KEYS = new String[]{"collectgarbage", "error", "setfenv"};
        LIBV_KEYS = new String[]{"assert", "dofile", "getfenv", "getmetatable", "load", "loadfile", "loadstring", "pcall", "xpcall", "print", "select", "unpack", "type", "rawequal", "rawget", "rawset", "setmetatable", "tostring", "tonumber", "pairs", "ipairs", "next", "__inext"};
    }

    public BaseLib() {
        instance = this;
    }

    @Override
    public LuaValue call(LuaValue arg) {
        this.env.set("_G", this.env);
        this.env.set("_VERSION", VERSION);
        this.bind(this.env, BaseLib2.class, LIB2_KEYS);
        this.bind(this.env, BaseLibV.class, LIBV_KEYS);
        this.next = this.env.get("next");
        this.inext = this.env.get("__inext");
        int i = 0;
        while (i < LIBV_KEYS.length) {
            ((BaseLibV)this.env.get((String)BaseLib.LIBV_KEYS[i])).baselib = this;
            ++i;
        }
        if (FINDER == null) {
            FINDER = this;
        }
        return this.env;
    }

    @Override
    public InputStream findResource(String filename) {
        Class<?> c = this.getClass();
        return c.getResourceAsStream(filename.startsWith("/") ? filename : "/" + filename);
    }

    private static LuaValue getfenvobj(LuaValue arg) {
        if (arg.isfunction()) {
            return arg;
        }
        int level = arg.optint(1);
        arg.argcheck(level >= 0, 1, "level must be non-negative");
        if (level == 0) {
            return LuaThread.getRunning();
        }
        LuaFunction f = LuaThread.getCallstackFunction(level);
        arg.argcheck(f != null, 1, "invalid level");
        return f;
    }

    public static Varargs pcall(LuaValue func, Varargs args, LuaValue errfunc) {
        LuaThread thread = LuaThread.getRunning();
        LuaValue olderr = thread.err;
        try {
            thread.err = errfunc;
            Varargs varargs = BaseLib.varargsOf(LuaValue.TRUE, func.invoke(args));
            thread.err = olderr;
            return varargs;
        }
        catch (Throwable throwable) {
            String m;
            try {
                thread.err = olderr;
                throw throwable;
            }
            catch (LuaError le) {
                m = le.getMessage();
                return BaseLib.varargsOf(FALSE, (Varargs)(m != null ? BaseLib.valueOf(m) : NIL));
            }
            catch (Exception e) {
                m = e.getMessage();
                return BaseLib.varargsOf(FALSE, (Varargs)BaseLib.valueOf(m != null ? m : e.toString()));
            }
        }
    }

    public static Varargs loadFile(String filename) {
        InputStream is = FINDER.findResource(filename);
        if (is == null) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("cannot open " + filename + ": No such file or directory"));
        }
        try {
            Varargs varargs = BaseLib.loadStream(is, "@" + filename);
            return varargs;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Varargs loadStream(InputStream is, String chunkname) {
        try {
            if (is == null) {
                return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("not found: " + chunkname));
            }
            return LoadState.load(is, chunkname, LuaThread.getGlobals());
        }
        catch (Exception e) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf(e.getMessage()));
        }
    }

    public static final class BaseLib2
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            switch (this.opcode) {
                case 0: {
                    String s = arg1.checkjstring();
                    boolean result = false;
                    if ("collect".equals(s)) {
                        System.gc();
                        return ZERO;
                    }
                    if ("count".equals(s)) {
                        Runtime rt = Runtime.getRuntime();
                        long used = rt.totalMemory() - rt.freeMemory();
                        return BaseLib2.valueOf((double)used / 1024.0);
                    }
                    if ("step".equals(s)) {
                        System.gc();
                        return LuaValue.TRUE;
                    }
                    BaseLib2.argerror(1, "gc op");
                    return NIL;
                }
                case 1: {
                    throw new LuaError(arg1.isnil() ? null : arg1.tojstring(), arg2.optint(1));
                }
                case 2: {
                    LuaTable t = arg2.checktable();
                    LuaValue f = BaseLib.getfenvobj(arg1);
                    if (!f.isfunction() && !f.isclosure()) {
                        BaseLib2.error("'setfenv' cannot change environment of given object");
                    }
                    f.setfenv(t);
                    return f.isthread() ? NONE : f;
                }
            }
            return NIL;
        }
    }

    public static final class BaseLibV
    extends VarArgFunction {
        public BaseLib baselib;

        @Override
        public Varargs invoke(Varargs args) {
            switch (this.opcode) {
                case 0: {
                    if (!args.arg1().toboolean()) {
                        BaseLibV.error(args.narg() > 1 ? args.optjstring(2, "assertion failed!") : "assertion failed!");
                    }
                    return args;
                }
                case 1: {
                    Varargs v = args.isnil(1) ? BaseLib.loadStream(this.baselib.STDIN, "=stdin") : BaseLib.loadFile(args.checkjstring(1));
                    return v.isnil(1) ? BaseLibV.error(v.tojstring(2)) : v.arg1().invoke();
                }
                case 2: {
                    LuaValue f = BaseLib.getfenvobj(args.arg1());
                    LuaValue e = f.getfenv();
                    return e != null ? e : NIL;
                }
                case 3: {
                    LuaValue mt = args.checkvalue(1).getmetatable();
                    return mt != null ? mt.rawget(METATABLE).optvalue(mt) : NIL;
                }
                case 4: {
                    LuaValue func = args.checkfunction(1);
                    String chunkname = args.optjstring(2, "function");
                    return BaseLib.loadStream(new StringInputStream(func), chunkname);
                }
                case 5: {
                    return args.isnil(1) ? BaseLib.loadStream(this.baselib.STDIN, "stdin") : BaseLib.loadFile(args.checkjstring(1));
                }
                case 6: {
                    LuaString script = args.checkstring(1);
                    String chunkname = args.optjstring(2, "string");
                    return BaseLib.loadStream(script.toInputStream(), chunkname);
                }
                case 7: {
                    LuaValue func = args.checkvalue(1);
                    LuaThread.onCall(this);
                    try {
                        Varargs varargs = BaseLib.pcall(func, args.subargs(2), null);
                        return varargs;
                    }
                    finally {
                        LuaThread.onReturn();
                    }
                }
                case 8: {
                    LuaThread.onCall(this);
                    try {
                        Varargs chunkname = BaseLib.pcall(args.arg1(), NONE, args.checkvalue(2));
                        return chunkname;
                    }
                    finally {
                        LuaThread.onReturn();
                    }
                }
                case 9: {
                    LuaValue tostring = LuaThread.getGlobals().get("tostring");
                    int i = 1;
                    int n = args.narg();
                    while (i <= n) {
                        if (i > 1) {
                            this.baselib.STDOUT.write(9);
                        }
                        LuaString s = tostring.call(args.arg(i)).strvalue();
                        int z = s.indexOf((byte)0, 0);
                        this.baselib.STDOUT.write(s.m_bytes, s.m_offset, z >= 0 ? z : s.m_length);
                        ++i;
                    }
                    this.baselib.STDOUT.println();
                    return NONE;
                }
                case 10: {
                    int n = args.narg() - 1;
                    if (args.arg1().equals(BaseLibV.valueOf("#"))) {
                        return BaseLibV.valueOf(n);
                    }
                    int i = args.checkint(1);
                    if (i == 0 || i < -n) {
                        BaseLibV.argerror(1, "index out of range");
                    }
                    return args.subargs(i < 0 ? n + i + 2 : i + 1);
                }
                case 11: {
                    int na = args.narg();
                    LuaTable t = args.checktable(1);
                    int n = t.length();
                    int i = na >= 2 ? args.checkint(2) : 1;
                    int j = na >= 3 ? args.checkint(3) : n;
                    n = j - i + 1;
                    if (n < 0) {
                        return NONE;
                    }
                    if (n == 1) {
                        return t.get(i);
                    }
                    if (n == 2) {
                        return BaseLibV.varargsOf(t.get(i), (Varargs)t.get(j));
                    }
                    LuaValue[] v = new LuaValue[n];
                    int k = 0;
                    while (k < n) {
                        v[k] = t.get(i + k);
                        ++k;
                    }
                    return BaseLibV.varargsOf(v);
                }
                case 12: {
                    return BaseLibV.valueOf(args.checkvalue(1).typename());
                }
                case 13: {
                    return BaseLibV.valueOf(args.checkvalue(1) == args.checkvalue(2));
                }
                case 14: {
                    return args.checktable(1).rawget(args.checkvalue(2));
                }
                case 15: {
                    LuaTable t = args.checktable(1);
                    t.rawset(args.checknotnil(2), args.checkvalue(3));
                    return t;
                }
                case 16: {
                    LuaValue mt;
                    LuaValue t = args.arg1();
                    LuaValue mt0 = t.getmetatable();
                    if (mt0 != null && !mt0.rawget(METATABLE).isnil()) {
                        BaseLibV.error("cannot change a protected metatable");
                    }
                    return t.setmetatable((mt = args.checkvalue(2)).isnil() ? null : mt.checktable());
                }
                case 17: {
                    LuaValue arg = args.checkvalue(1);
                    LuaValue h = arg.metatag(TOSTRING);
                    if (!h.isnil()) {
                        return h.call(arg);
                    }
                    LuaValue v = arg.tostring();
                    if (!v.isnil()) {
                        return v;
                    }
                    return BaseLibV.valueOf(arg.tojstring());
                }
                case 18: {
                    LuaValue arg1 = args.checkvalue(1);
                    int base = args.optint(2, 10);
                    if (base == 10) {
                        return arg1.tonumber();
                    }
                    if (base < 2 || base > 36) {
                        BaseLibV.argerror(2, "base out of range");
                    }
                    return arg1.checkstring().tonumber(base);
                }
                case 19: {
                    return BaseLibV.varargsOf(this.baselib.next, args.checktable(1), NIL);
                }
                case 20: {
                    return BaseLibV.varargsOf(this.baselib.inext, args.checktable(1), ZERO);
                }
                case 21: {
                    return args.checktable(1).next(args.arg(2));
                }
                case 22: {
                    return args.checktable(1).inext(args.arg(2));
                }
            }
            return NONE;
        }
    }

    private static class StringInputStream
    extends InputStream {
        LuaValue func;
        byte[] bytes;
        int offset;

        StringInputStream(LuaValue func) {
            this.func = func;
        }

        @Override
        public int read() throws IOException {
            if (this.func == null) {
                return -1;
            }
            if (this.bytes == null) {
                LuaValue s = this.func.call();
                if (s.isnil()) {
                    this.func = null;
                    this.bytes = null;
                    return -1;
                }
                this.bytes = s.tojstring().getBytes();
                this.offset = 0;
            }
            if (this.offset >= this.bytes.length) {
                return -1;
            }
            return this.bytes[this.offset++];
        }
    }
}

