/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class CoroutineLib
extends VarArgFunction {
    private static final int INIT = 0;
    private static final int CREATE = 1;
    private static final int RESUME = 2;
    private static final int RUNNING = 3;
    private static final int STATUS = 4;
    private static final int YIELD = 5;
    private static final int WRAP = 6;
    private static final int WRAPPED = 7;

    private LuaTable init() {
        LuaTable t = new LuaTable();
        this.bind(t, CoroutineLib.class, new String[]{"create", "resume", "running", "status", "yield", "wrap"}, 1);
        this.env.set("coroutine", (LuaValue)t);
        PackageLib.instance.LOADED.set("coroutine", (LuaValue)t);
        return t;
    }

    @Override
    public Varargs invoke(Varargs args) {
        switch (this.opcode) {
            case 0: {
                return this.init();
            }
            case 1: {
                LuaValue func = args.checkfunction(1);
                return new LuaThread(func, LuaThread.getGlobals());
            }
            case 2: {
                LuaThread t = args.checkthread(1);
                return t.resume(args.subargs(2));
            }
            case 3: {
                LuaThread r = LuaThread.getRunning();
                return LuaThread.isMainThread(r) ? NIL : r;
            }
            case 4: {
                return CoroutineLib.valueOf(args.checkthread(1).getStatus());
            }
            case 5: {
                LuaThread r = LuaThread.getRunning();
                if (LuaThread.isMainThread(r)) {
                    CoroutineLib.error("main thread can't yield");
                }
                return r.yield(args);
            }
            case 6: {
                LuaValue func = args.checkfunction(1);
                LuaThread thread = new LuaThread(func, func.getfenv());
                CoroutineLib cl = new CoroutineLib();
                cl.setfenv(thread);
                cl.name = "wrapped";
                cl.opcode = 7;
                return cl;
            }
            case 7: {
                LuaThread t = (LuaThread)this.env;
                Varargs result = t.resume(args);
                if (result.arg1().toboolean()) {
                    return result.subargs(2);
                }
                CoroutineLib.error(result.arg(2).tojstring());
            }
        }
        return NONE;
    }
}

