/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class DebugLib
extends VarArgFunction {
    public static final boolean CALLS = System.getProperty("CALLS") != null;
    public static final boolean TRACE = System.getProperty("TRACE") != null;
    public static boolean DEBUG_ENABLED;
    static final String[] NAMES;
    private static final int INIT = 0;
    private static final int DEBUG = 1;
    private static final int GETFENV = 2;
    private static final int GETHOOK = 3;
    private static final int GETINFO = 4;
    private static final int GETLOCAL = 5;
    private static final int GETMETATABLE = 6;
    private static final int GETREGISTRY = 7;
    private static final int GETUPVALUE = 8;
    private static final int SETFENV = 9;
    private static final int SETHOOK = 10;
    private static final int SETLOCAL = 11;
    private static final int SETMETATABLE = 12;
    private static final int SETUPVALUE = 13;
    private static final int TRACEBACK = 14;
    private static final int MAXSTACK = 250;
    private static final LuaString LUA;
    private static final LuaString JAVA;
    private static final LuaString QMARK;
    private static final LuaString GLOBAL;
    private static final LuaString LOCAL;
    private static final LuaString METHOD;
    private static final LuaString UPVALUE;
    private static final LuaString FIELD;
    private static final LuaString CALL;
    private static final LuaString LINE;
    private static final LuaString COUNT;
    private static final LuaString RETURN;
    private static final LuaString TAILRETURN;
    private static final LuaString FUNC;
    private static final LuaString NUPS;
    private static final LuaString NAME;
    private static final LuaString NAMEWHAT;
    private static final LuaString WHAT;
    private static final LuaString SOURCE;
    private static final LuaString SHORT_SRC;
    private static final LuaString LINEDEFINED;
    private static final LuaString LASTLINEDEFINED;
    private static final LuaString CURRENTLINE;
    private static final LuaString ACTIVELINES;

    static {
        NAMES = new String[]{"debug", "getfenv", "gethook", "getinfo", "getlocal", "getmetatable", "getregistry", "getupvalue", "setfenv", "sethook", "setlocal", "setmetatable", "setupvalue", "traceback"};
        LUA = DebugLib.valueOf("Lua");
        JAVA = DebugLib.valueOf("Java");
        QMARK = DebugLib.valueOf("?");
        GLOBAL = DebugLib.valueOf("global");
        LOCAL = DebugLib.valueOf("local");
        METHOD = DebugLib.valueOf("method");
        UPVALUE = DebugLib.valueOf("upvalue");
        FIELD = DebugLib.valueOf("field");
        CALL = DebugLib.valueOf("call");
        LINE = DebugLib.valueOf("line");
        COUNT = DebugLib.valueOf("count");
        RETURN = DebugLib.valueOf("return");
        TAILRETURN = DebugLib.valueOf("tail return");
        FUNC = DebugLib.valueOf("func");
        NUPS = DebugLib.valueOf("nups");
        NAME = DebugLib.valueOf("name");
        NAMEWHAT = DebugLib.valueOf("namewhat");
        WHAT = DebugLib.valueOf("what");
        SOURCE = DebugLib.valueOf("source");
        SHORT_SRC = DebugLib.valueOf("short_src");
        LINEDEFINED = DebugLib.valueOf("linedefined");
        LASTLINEDEFINED = DebugLib.valueOf("lastlinedefined");
        CURRENTLINE = DebugLib.valueOf("currentline");
        ACTIVELINES = DebugLib.valueOf("activelines");
    }

    private LuaTable init() {
        DEBUG_ENABLED = true;
        LuaTable t = new LuaTable();
        this.bind(t, DebugLib.class, NAMES, 1);
        this.env.set("debug", (LuaValue)t);
        PackageLib.instance.LOADED.set("debug", (LuaValue)t);
        return t;
    }

    @Override
    public Varargs invoke(Varargs args) {
        switch (this.opcode) {
            case 0: {
                return this.init();
            }
            case 1: {
                return DebugLib._debug(args);
            }
            case 2: {
                return DebugLib._getfenv(args);
            }
            case 3: {
                return DebugLib._gethook(args);
            }
            case 4: {
                return DebugLib._getinfo(args, this);
            }
            case 5: {
                return DebugLib._getlocal(args);
            }
            case 6: {
                return DebugLib._getmetatable(args);
            }
            case 7: {
                return DebugLib._getregistry(args);
            }
            case 8: {
                return DebugLib._getupvalue(args);
            }
            case 9: {
                return DebugLib._setfenv(args);
            }
            case 10: {
                return DebugLib._sethook(args);
            }
            case 11: {
                return DebugLib._setlocal(args);
            }
            case 12: {
                return DebugLib._setmetatable(args);
            }
            case 13: {
                return DebugLib._setupvalue(args);
            }
            case 14: {
                return DebugLib._traceback(args);
            }
        }
        return NONE;
    }

    static DebugState getDebugState(LuaThread thread) {
        if (thread.debugState == null) {
            thread.debugState = new DebugState(thread);
        }
        return (DebugState)thread.debugState;
    }

    static DebugState getDebugState() {
        return DebugLib.getDebugState(LuaThread.getRunning());
    }

    public static void debugSetupCall(Varargs args, LuaValue[] stack) {
        DebugState ds = DebugLib.getDebugState();
        if (ds.inhook) {
            return;
        }
        ds.nextInfo().setargs(args, stack);
    }

    public static void debugOnCall(LuaThread thread, int calls, LuaFunction func) {
        DebugState ds = DebugLib.getDebugState();
        if (ds.inhook) {
            return;
        }
        DebugInfo di = ds.pushInfo(calls);
        di.setfunction(func);
        if (CALLS) {
            System.out.println("calling " + func);
        }
        if (ds.hookcall) {
            ds.callHookFunc(ds, CALL, LuaValue.NIL);
        }
    }

    public static void debugOnReturn(LuaThread thread, int calls) {
        DebugState ds = DebugLib.getDebugState(thread);
        if (ds.inhook) {
            return;
        }
        if (CALLS) {
            System.out.println("returning");
        }
        try {
            if (ds.hookrtrn) {
                ds.callHookFunc(ds, RETURN, LuaValue.NIL);
            }
        }
        finally {
            DebugLib.getDebugState().popInfo(calls);
        }
    }

    public static void debugBytecode(int pc, Varargs extras, int top) {
        int c;
        int newline;
        DebugState ds = DebugLib.getDebugState();
        if (ds.inhook) {
            return;
        }
        DebugInfo di = ds.getDebugInfo();
        if (TRACE) {
            Print.printState(di.closure, pc, di.stack, top, di.varargs);
        }
        di.bytecode(pc, extras, top);
        if (ds.hookcount > 0) {
            DebugState debugState = ds;
            int n = debugState.hookcodes + 1;
            debugState.hookcodes = n;
            if (n >= ds.hookcount) {
                ds.hookcodes = 0;
                ds.callHookFunc(ds, COUNT, LuaValue.NIL);
            }
        }
        if (ds.hookline && (newline = di.currentline()) != ds.line && (((c = di.closure.p.code[pc]) & 0x3F) != 22 || (c >>> 14) - 131071 >= 0)) {
            ds.line = newline;
            ds.callHookFunc(ds, LINE, LuaValue.valueOf(newline));
        }
    }

    static Varargs _debug(Varargs args) {
        return NONE;
    }

    static Varargs _gethook(Varargs args) {
        int a = 1;
        LuaThread thread = args.isthread(a) ? args.checkthread(a++) : LuaThread.getRunning();
        DebugState ds = DebugLib.getDebugState(thread);
        return DebugLib.varargsOf(ds.hookfunc, DebugLib.valueOf(String.valueOf(ds.hookcall ? "c" : "") + (ds.hookline ? "l" : "") + (ds.hookrtrn ? "r" : "")), DebugLib.valueOf(ds.hookcount));
    }

    static Varargs _sethook(Varargs args) {
        int a = 1;
        LuaThread thread = args.isthread(a) ? args.checkthread(a++) : LuaThread.getRunning();
        LuaFunction func = args.optfunction(a++, null);
        String str = args.optjstring(a++, "");
        int count = args.optint(a++, 0);
        boolean call = false;
        boolean line = false;
        boolean rtrn = false;
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case 'c': {
                    call = true;
                    break;
                }
                case 'l': {
                    line = true;
                    break;
                }
                case 'r': {
                    rtrn = true;
                }
            }
            ++i;
        }
        DebugLib.getDebugState(thread).sethook(func, call, line, rtrn, count);
        return NONE;
    }

    static Varargs _getfenv(Varargs args) {
        LuaValue object = args.arg1();
        LuaValue env = object.getfenv();
        return env != null ? env : LuaValue.NIL;
    }

    static Varargs _setfenv(Varargs args) {
        LuaValue object = args.arg1();
        LuaTable table = args.checktable(2);
        object.setfenv(table);
        return object;
    }

    protected static Varargs _getinfo(Varargs args, LuaValue level0func) {
        int level;
        int a = 1;
        LuaThread thread = args.isthread(a) ? args.checkthread(a++) : LuaThread.getRunning();
        LuaValue func = args.arg(a++);
        String what = args.optjstring(a++, "nSluf");
        DebugState ds = DebugLib.getDebugState(thread);
        DebugInfo di = null;
        di = func.isnumber() ? ((level = func.checkint()) > 0 ? ds.getDebugInfo(level - 1) : new DebugInfo(level0func)) : ds.findDebugInfo(func.checkfunction());
        if (di == null) {
            return NIL;
        }
        LuaTable info = new LuaTable();
        LuaClosure c = di.closure;
        int i = 0;
        int j = what.length();
        while (i < j) {
            switch (what.charAt(i)) {
                case 'S': {
                    if (c != null) {
                        Prototype p = c.p;
                        info.set(WHAT, (LuaValue)LUA);
                        info.set(SOURCE, (LuaValue)p.source);
                        info.set(SHORT_SRC, (LuaValue)DebugLib.valueOf(DebugLib.sourceshort(p)));
                        info.set(LINEDEFINED, (LuaValue)DebugLib.valueOf(p.linedefined));
                        info.set(LASTLINEDEFINED, (LuaValue)DebugLib.valueOf(p.lastlinedefined));
                        break;
                    }
                    String shortName = di.func.tojstring();
                    LuaString name = LuaString.valueOf("[Java] " + shortName);
                    info.set(WHAT, (LuaValue)JAVA);
                    info.set(SOURCE, (LuaValue)name);
                    info.set(SHORT_SRC, (LuaValue)DebugLib.valueOf(shortName));
                    info.set(LINEDEFINED, (LuaValue)LuaValue.MINUSONE);
                    info.set(LASTLINEDEFINED, (LuaValue)LuaValue.MINUSONE);
                    break;
                }
                case 'l': {
                    int line = di.currentline();
                    info.set(CURRENTLINE, (LuaValue)DebugLib.valueOf(line));
                    break;
                }
                case 'u': {
                    info.set(NUPS, (LuaValue)DebugLib.valueOf(c != null ? c.p.nups : 0));
                    break;
                }
                case 'n': {
                    LuaString[] kind = di.getfunckind();
                    info.set(NAME, (LuaValue)(kind != null ? kind[0] : QMARK));
                    info.set(NAMEWHAT, (LuaValue)(kind != null ? kind[1] : EMPTYSTRING));
                    break;
                }
                case 'f': {
                    info.set(FUNC, di.func);
                    break;
                }
                case 'L': {
                    LuaTable lines = new LuaTable();
                    info.set(ACTIVELINES, (LuaValue)lines);
                }
            }
            ++i;
        }
        return info;
    }

    public static String sourceshort(Prototype p) {
        String name = p.source.tojstring();
        if (name.startsWith("@") || name.startsWith("=")) {
            name = name.substring(1);
        } else if (name.startsWith("\u001b")) {
            name = "binary string";
        }
        return name;
    }

    static Varargs _getlocal(Varargs args) {
        LuaString name;
        int a = 1;
        LuaThread thread = args.isthread(a) ? args.checkthread(a++) : LuaThread.getRunning();
        int level = args.checkint(a++);
        int local = args.checkint(a++);
        DebugState ds = DebugLib.getDebugState(thread);
        DebugInfo di = ds.getDebugInfo(level - 1);
        LuaString luaString = name = di != null ? di.getlocalname(local) : null;
        if (name != null) {
            LuaValue value = di.stack[local - 1];
            return DebugLib.varargsOf(name, (Varargs)value);
        }
        return NIL;
    }

    static Varargs _setlocal(Varargs args) {
        LuaString name;
        int a = 1;
        LuaThread thread = args.isthread(a) ? args.checkthread(a++) : LuaThread.getRunning();
        int level = args.checkint(a++);
        int local = args.checkint(a++);
        LuaValue value = args.arg(a++);
        DebugState ds = DebugLib.getDebugState(thread);
        DebugInfo di = ds.getDebugInfo(level - 1);
        LuaString luaString = name = di != null ? di.getlocalname(local) : null;
        if (name != null) {
            di.stack[local - 1] = value;
            return name;
        }
        return NIL;
    }

    static LuaValue _getmetatable(Varargs args) {
        LuaValue object = args.arg(1);
        LuaValue mt = object.getmetatable();
        return mt != null ? mt : NIL;
    }

    static Varargs _setmetatable(Varargs args) {
        LuaValue object = args.arg(1);
        try {
            LuaTable mt = args.opttable(2, null);
            switch (object.type()) {
                case 0: {
                    LuaNil.s_metatable = mt;
                    break;
                }
                case 3: {
                    LuaNumber.s_metatable = mt;
                    break;
                }
                case 1: {
                    LuaBoolean.s_metatable = mt;
                    break;
                }
                case 4: {
                    LuaString.s_metatable = mt;
                    break;
                }
                case 6: {
                    LuaFunction.s_metatable = mt;
                    break;
                }
                case 8: {
                    LuaThread.s_metatable = mt;
                    break;
                }
                default: {
                    object.setmetatable(mt);
                }
            }
            return LuaValue.TRUE;
        }
        catch (LuaError e) {
            return DebugLib.varargsOf(FALSE, (Varargs)DebugLib.valueOf(e.toString()));
        }
    }

    static Varargs _getregistry(Varargs args) {
        return new LuaTable();
    }

    static LuaString findupvalue(LuaClosure c, int up) {
        if (c.upValues != null && up > 0 && up <= c.upValues.length) {
            if (c.p.upvalues != null && up <= c.p.upvalues.length) {
                return c.p.upvalues[up - 1];
            }
            return LuaString.valueOf("." + up);
        }
        return null;
    }

    static Varargs _getupvalue(Varargs args) {
        LuaClosure c;
        LuaString name;
        LuaValue func = args.checkfunction(1);
        int up = args.checkint(2);
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            return DebugLib.varargsOf(name, (Varargs)c.upValues[up - 1].getValue());
        }
        return NIL;
    }

    static LuaValue _setupvalue(Varargs args) {
        LuaClosure c;
        LuaString name;
        LuaValue func = args.checkfunction(1);
        int up = args.checkint(2);
        LuaValue value = args.arg(3);
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            c.upValues[up - 1].setValue(value);
            return name;
        }
        return NIL;
    }

    static LuaValue _traceback(Varargs args) {
        int a = 1;
        LuaThread thread = args.isthread(a) ? args.checkthread(a++) : LuaThread.getRunning();
        String message = args.optjstring(a++, null);
        int level = args.optint(a++, 1);
        String tb = DebugLib.traceback(thread, level - 1);
        return DebugLib.valueOf(message != null ? String.valueOf(message) + "\n" + tb : tb);
    }

    public static String traceback(int level) {
        return DebugLib.traceback(LuaThread.getRunning(), level);
    }

    public static String traceback(LuaThread thread, int level) {
        StringBuffer sb = new StringBuffer();
        DebugState ds = DebugLib.getDebugState(thread);
        sb.append("stack traceback:");
        DebugInfo di = ds.getDebugInfo(level);
        if (di != null) {
            sb.append("\n\t");
            sb.append(di.sourceline());
            sb.append(" in ");
            while ((di = ds.getDebugInfo(++level)) != null) {
                sb.append(di.tracename());
                sb.append("\n\t");
                sb.append(di.sourceline());
                sb.append(" in ");
            }
            sb.append("main chunk");
        }
        return sb.toString();
    }

    public static String fileline() {
        DebugState ds = DebugLib.getDebugState(LuaThread.getRunning());
        int i = 0;
        int n = ds.debugCalls;
        while (i < n) {
            DebugInfo di = ds.getDebugInfo(i);
            if (di != null && di.func.isclosure()) {
                return di.sourceline();
            }
            ++i;
        }
        return DebugLib.fileline(0);
    }

    public static String fileline(int level) {
        DebugState ds = DebugLib.getDebugState(LuaThread.getRunning());
        DebugInfo di = ds.getDebugInfo(level);
        return di != null ? di.sourceline() : null;
    }

    static void lua_assert(boolean x) {
        if (!x) {
            throw new RuntimeException("lua_assert failed");
        }
    }

    static LuaString[] getobjname(DebugInfo di, int stackpos) {
        if (di.closure != null) {
            Prototype p = di.closure.p;
            int pc = di.pc;
            LuaString name = p.getlocalname(stackpos + 1, pc);
            if (name != null) {
                return new LuaString[]{name, LOCAL};
            }
            int i = DebugLib.symbexec(p, pc, stackpos);
            DebugLib.lua_assert(pc != -1);
            switch (Lua.GET_OPCODE(i)) {
                case 5: {
                    int g = Lua.GETARG_Bx(i);
                    return new LuaString[]{p.k[g].strvalue(), GLOBAL};
                }
                case 0: {
                    int a = Lua.GETARG_A(i);
                    int b = Lua.GETARG_B(i);
                    if (b >= a) break;
                    return DebugLib.getobjname(di, b);
                }
                case 6: {
                    int k = Lua.GETARG_C(i);
                    name = DebugLib.kname(p, k);
                    return new LuaString[]{name, FIELD};
                }
                case 4: {
                    int u = Lua.GETARG_B(i);
                    name = u < p.upvalues.length ? p.upvalues[u] : QMARK;
                    return new LuaString[]{name, UPVALUE};
                }
                case 11: {
                    int k = Lua.GETARG_C(i);
                    name = DebugLib.kname(p, k);
                    return new LuaString[]{name, METHOD};
                }
            }
        }
        return null;
    }

    static LuaString kname(Prototype p, int c) {
        if (Lua.ISK(c) && p.k[Lua.INDEXK(c)].isstring()) {
            return p.k[Lua.INDEXK(c)].strvalue();
        }
        return QMARK;
    }

    static boolean checkreg(Prototype pt, int reg) {
        return reg < pt.maxstacksize;
    }

    static boolean precheck(Prototype pt) {
        if (pt.maxstacksize > 250) {
            return false;
        }
        DebugLib.lua_assert(pt.numparams + (pt.is_vararg & 1) <= pt.maxstacksize);
        DebugLib.lua_assert((pt.is_vararg & 4) == 0 || (pt.is_vararg & 1) != 0);
        if (pt.upvalues.length > pt.nups) {
            return false;
        }
        if (pt.lineinfo.length != pt.code.length && pt.lineinfo.length != 0) {
            return false;
        }
        return Lua.GET_OPCODE(pt.code[pt.code.length - 1]) == 30;
    }

    static boolean checkopenop(Prototype pt, int pc) {
        int i = pt.code[pc + 1];
        switch (Lua.GET_OPCODE(i)) {
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                return Lua.GETARG_B(i) == 0;
            }
        }
        return false;
    }

    static boolean checkArgMode(Prototype pt, int r, int mode) {
        switch (mode) {
            case 0: {
                if (r == 0) break;
                return false;
            }
            case 1: {
                break;
            }
            case 2: {
                DebugLib.checkreg(pt, r);
                break;
            }
            case 3: {
                if (!(Lua.ISK(r) ? Lua.INDEXK(r) >= pt.k.length : r >= pt.maxstacksize)) break;
                return false;
            }
        }
        return true;
    }

    static int symbexec(Prototype pt, int lastpc, int reg) {
        int last = pt.code.length - 1;
        if (!DebugLib.precheck(pt)) {
            return 0;
        }
        int pc = 0;
        while (pc < lastpc) {
            int dest;
            int i = pt.code[pc];
            int op = Lua.GET_OPCODE(i);
            int a = Lua.GETARG_A(i);
            int b = 0;
            int c = 0;
            if (op >= 38) {
                return 0;
            }
            if (!DebugLib.checkreg(pt, a)) {
                return 0;
            }
            switch (Lua.getOpMode(op)) {
                case 0: {
                    b = Lua.GETARG_B(i);
                    c = Lua.GETARG_C(i);
                    if (!DebugLib.checkArgMode(pt, b, Lua.getBMode(op))) {
                        return 0;
                    }
                    if (DebugLib.checkArgMode(pt, c, Lua.getCMode(op))) break;
                    return 0;
                }
                case 1: {
                    b = Lua.GETARG_Bx(i);
                    if (Lua.getBMode(op) != 3 || b < pt.k.length) break;
                    return 0;
                }
                case 2: {
                    int d;
                    b = Lua.GETARG_sBx(i);
                    if (Lua.getBMode(op) != 2) break;
                    dest = pc + 1 + b;
                    if (dest < 0 || dest >= pt.code.length) {
                        return 0;
                    }
                    if (dest <= 0 || Lua.GET_OPCODE(d = pt.code[dest - 1]) != 34 || Lua.GETARG_C(d) != 0) break;
                    return 0;
                }
            }
            if (Lua.testAMode(op) && a == reg) {
                last = pc;
            }
            if (Lua.testTMode(op)) {
                if (pc + 2 >= pt.code.length) {
                    return 0;
                }
                if (Lua.GET_OPCODE(pt.code[pc + 1]) != 22) {
                    return 0;
                }
            }
            switch (op) {
                case 2: {
                    if (c == 0 || pc + 2 < pt.code.length) break;
                    return 0;
                }
                case 3: {
                    if (a > reg || reg > b) break;
                    last = pc;
                    break;
                }
                case 4: 
                case 8: {
                    if (b < pt.nups) break;
                    return 0;
                }
                case 5: 
                case 7: {
                    if (pt.k[b].isstring()) break;
                    return 0;
                }
                case 11: {
                    if (!DebugLib.checkreg(pt, a + 1)) {
                        return 0;
                    }
                    if (reg != a + 1) break;
                    last = pc;
                    break;
                }
                case 21: {
                    if (b < c) break;
                    return 0;
                }
                case 33: {
                    if (c < 1) {
                        return 0;
                    }
                    if (!DebugLib.checkreg(pt, a + 2 + c)) {
                        return 0;
                    }
                    if (reg < a + 2) break;
                    last = pc;
                    break;
                }
                case 31: 
                case 32: {
                    if (!DebugLib.checkreg(pt, a + 3)) {
                        return 0;
                    }
                }
                case 22: {
                    dest = pc + 1 + b;
                    if (reg == 255 || pc >= dest || dest > lastpc) break;
                    pc += b;
                    break;
                }
                case 28: 
                case 29: {
                    if (b != 0 && !DebugLib.checkreg(pt, a + b - 1)) {
                        return 0;
                    }
                    if (--c == -1 ? !DebugLib.checkopenop(pt, pc) : c != 0 && !DebugLib.checkreg(pt, a + c - 1)) {
                        return 0;
                    }
                    if (reg < a) break;
                    last = pc;
                    break;
                }
                case 30: {
                    if (--b <= 0 || DebugLib.checkreg(pt, a + b - 1)) break;
                    return 0;
                }
                case 34: {
                    if (b > 0 && !DebugLib.checkreg(pt, a + b)) {
                        return 0;
                    }
                    if (c != 0) break;
                    ++pc;
                    break;
                }
                case 36: {
                    if (b >= pt.p.length) {
                        return 0;
                    }
                    int nup = pt.p[b].nups;
                    if (pc + nup >= pt.code.length) {
                        return 0;
                    }
                    int j = 1;
                    while (j <= nup) {
                        int op1 = Lua.GET_OPCODE(pt.code[pc + j]);
                        if (op1 != 4 && op1 != 0) {
                            return 0;
                        }
                        ++j;
                    }
                    if (reg == 255) break;
                    pc += nup;
                    break;
                }
                case 37: {
                    if ((pt.is_vararg & 2) == 0 || (pt.is_vararg & 4) != 0) {
                        return 0;
                    }
                    if (--b == -1 && !DebugLib.checkopenop(pt, pc)) {
                        return 0;
                    }
                    if (DebugLib.checkreg(pt, a + b - 1)) break;
                    return 0;
                }
            }
            ++pc;
        }
        return pt.code[last];
    }

    static class DebugInfo {
        LuaValue func;
        LuaClosure closure;
        LuaValue[] stack;
        Varargs varargs;
        Varargs extras;
        int pc;
        int top;

        private DebugInfo() {
            this.func = NIL;
        }

        private DebugInfo(LuaValue func) {
            this.pc = -1;
            this.setfunction(func);
        }

        void setargs(Varargs varargs, LuaValue[] stack) {
            this.varargs = varargs;
            this.stack = stack;
        }

        void setfunction(LuaValue func) {
            this.func = func;
            this.closure = func instanceof LuaClosure ? (LuaClosure)func : null;
        }

        void clear() {
            this.func = NIL;
            this.closure = null;
            this.stack = null;
            this.extras = null;
            this.varargs = null;
            this.top = 0;
            this.pc = 0;
        }

        public void bytecode(int pc, Varargs extras, int top) {
            this.pc = pc;
            this.top = top;
            this.extras = extras;
        }

        public int currentline() {
            if (this.closure == null) {
                return -1;
            }
            int[] li = this.closure.p.lineinfo;
            return li == null || this.pc < 0 || this.pc >= li.length ? -1 : li[this.pc];
        }

        public LuaString[] getfunckind() {
            if (this.closure == null || this.pc < 0) {
                return null;
            }
            int stackpos = this.closure.p.code[this.pc] >> 6 & 0xFF;
            return DebugLib.getobjname(this, stackpos);
        }

        public String sourceline() {
            if (this.closure == null) {
                return this.func.tojstring();
            }
            String s = this.closure.p.source.tojstring();
            int line = this.currentline();
            return String.valueOf(s.startsWith("@") || s.startsWith("=") ? s.substring(1) : s) + ":" + line;
        }

        public String tracename() {
            LuaString[] kind = this.getfunckind();
            if (kind == null) {
                return "function ?";
            }
            return "function " + kind[0].tojstring();
        }

        public LuaString getlocalname(int index) {
            if (this.closure == null) {
                return null;
            }
            return this.closure.p.getlocalname(index, this.pc);
        }

        public String tojstring() {
            return String.valueOf(this.tracename()) + " " + this.sourceline();
        }
    }

    static class DebugState {
        private final LuaThread thread;
        private int debugCalls = 0;
        private DebugInfo[] debugInfo = new DebugInfo[257];
        private LuaValue hookfunc;
        private boolean hookcall;
        private boolean hookline;
        private boolean hookrtrn;
        private boolean inhook;
        private int hookcount;
        private int hookcodes;
        private int line;

        DebugState(LuaThread thread) {
            this.thread = thread;
        }

        public DebugInfo nextInfo() {
            DebugInfo di = this.debugInfo[this.debugCalls];
            if (di == null) {
                this.debugInfo[this.debugCalls] = di = new DebugInfo();
            }
            return di;
        }

        public DebugInfo pushInfo(int calls) {
            while (this.debugCalls < calls) {
                this.nextInfo();
                ++this.debugCalls;
            }
            return this.debugInfo[this.debugCalls - 1];
        }

        public void popInfo(int calls) {
            while (this.debugCalls > calls) {
                this.debugInfo[--this.debugCalls].clear();
            }
        }

        void callHookFunc(DebugState ds, LuaString type, LuaValue arg) {
            if (this.inhook || this.hookfunc == null) {
                return;
            }
            this.inhook = true;
            try {
                try {
                    int n = this.debugCalls;
                    ds.nextInfo().setargs(arg, null);
                    ds.pushInfo(n + 1).setfunction(this.hookfunc);
                    try {
                        this.hookfunc.call(type, arg);
                    }
                    finally {
                        ds.popInfo(n);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.inhook = false;
                }
            }
            finally {
                this.inhook = false;
            }
        }

        public void sethook(LuaValue func, boolean call, boolean line, boolean rtrn, int count) {
            this.hookcount = count;
            this.hookcall = call;
            this.hookline = line;
            this.hookrtrn = rtrn;
            this.hookfunc = func;
        }

        DebugInfo getDebugInfo() {
            try {
                return this.debugInfo[this.debugCalls - 1];
            }
            catch (Throwable t) {
                if (this.debugCalls <= 0) {
                    DebugInfo debugInfo = new DebugInfo();
                    this.debugInfo[this.debugCalls++] = debugInfo;
                    return debugInfo;
                }
                return null;
            }
        }

        DebugInfo getDebugInfo(int level) {
            return level < 0 || level >= this.debugCalls ? null : this.debugInfo[this.debugCalls - level - 1];
        }

        public DebugInfo findDebugInfo(LuaValue func) {
            int i = this.debugCalls;
            while (--i >= 0) {
                if (this.debugInfo[i].func != func) continue;
                return this.debugInfo[i];
            }
            return new DebugInfo(func);
        }

        public String tojstring() {
            return DebugLib.traceback(this.thread, 0);
        }
    }
}

