/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.util.Random;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class MathLib
extends OneArgFunction {
    public static MathLib MATHLIB = null;
    private Random random;

    public MathLib() {
        MATHLIB = this;
    }

    @Override
    public LuaValue call(LuaValue arg) {
        LuaTable t = new LuaTable(0, 30);
        t.set("pi", Math.PI);
        t.set("huge", (LuaValue)LuaDouble.POSINF);
        this.bind(t, MathLib1.class, new String[]{"abs", "ceil", "cos", "deg", "exp", "floor", "rad", "sin", "sqrt", "tan"});
        this.bind(t, MathLib2.class, new String[]{"fmod", "ldexp", "pow"});
        this.bind(t, MathLibV.class, new String[]{"frexp", "max", "min", "modf", "randomseed", "random"});
        ((MathLibV)t.get((String)"randomseed")).mathlib = this;
        ((MathLibV)t.get((String)"random")).mathlib = this;
        this.env.set("math", (LuaValue)t);
        PackageLib.instance.LOADED.set("math", (LuaValue)t);
        return t;
    }

    public static LuaValue dpow(double a, double b) {
        return LuaDouble.valueOf(MATHLIB != null ? MATHLIB.dpow_lib(a, b) : MathLib.dpow_default(a, b));
    }

    public static double dpow_d(double a, double b) {
        return MATHLIB != null ? MATHLIB.dpow_lib(a, b) : MathLib.dpow_default(a, b);
    }

    public double dpow_lib(double a, double b) {
        return MathLib.dpow_default(a, b);
    }

    protected static double dpow_default(double a, double b) {
        double d;
        if (b < 0.0) {
            return 1.0 / MathLib.dpow_default(a, -b);
        }
        double p = 1.0;
        int whole = (int)b;
        double v = a;
        while (whole > 0) {
            if ((whole & 1) != 0) {
                p *= v;
            }
            whole >>= 1;
            v *= v;
        }
        b -= (double)whole;
        if (d > 0.0) {
            int frac = (int)(65536.0 * b);
            while ((frac & 0xFFFF) != 0) {
                a = Math.sqrt(a);
                if ((frac & 0x8000) != 0) {
                    p *= a;
                }
                frac <<= 1;
            }
        }
        return p;
    }

    public static final class MathLib1
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue arg) {
            switch (this.opcode) {
                case 0: {
                    return MathLib1.valueOf(Math.abs(arg.checkdouble()));
                }
                case 1: {
                    return MathLib1.valueOf(Math.ceil(arg.checkdouble()));
                }
                case 2: {
                    return MathLib1.valueOf(Math.cos(arg.checkdouble()));
                }
                case 3: {
                    return MathLib1.valueOf(Math.toDegrees(arg.checkdouble()));
                }
                case 4: {
                    return MathLib.dpow(Math.E, arg.checkdouble());
                }
                case 5: {
                    return MathLib1.valueOf(Math.floor(arg.checkdouble()));
                }
                case 6: {
                    return MathLib1.valueOf(Math.toRadians(arg.checkdouble()));
                }
                case 7: {
                    return MathLib1.valueOf(Math.sin(arg.checkdouble()));
                }
                case 8: {
                    return MathLib1.valueOf(Math.sqrt(arg.checkdouble()));
                }
                case 9: {
                    return MathLib1.valueOf(Math.tan(arg.checkdouble()));
                }
            }
            return NIL;
        }
    }

    public static final class MathLib2
    extends TwoArgFunction {
        protected MathLib mathlib;

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            switch (this.opcode) {
                case 0: {
                    double x = arg1.checkdouble();
                    double y = arg2.checkdouble();
                    double q = x / y;
                    double f = x - y * (q >= 0.0 ? Math.floor(q) : Math.ceil(q));
                    return MathLib2.valueOf(f);
                }
                case 1: {
                    double x = arg1.checkdouble();
                    double y = arg2.checkdouble() + 1023.5;
                    long e = (long)((1 & (int)y) != 0 ? Math.floor(y) : Math.ceil(y - 1.0));
                    return MathLib2.valueOf(x * Double.longBitsToDouble(e << 52));
                }
                case 2: {
                    return MathLib.dpow(arg1.checkdouble(), arg2.checkdouble());
                }
            }
            return NIL;
        }
    }

    public static final class MathLibV
    extends VarArgFunction {
        protected MathLib mathlib;

        @Override
        public Varargs invoke(Varargs args) {
            switch (this.opcode) {
                case 0: {
                    double x = args.checkdouble(1);
                    if (x == 0.0) {
                        return MathLibV.varargsOf(ZERO, (Varargs)ZERO);
                    }
                    long bits = Double.doubleToLongBits(x);
                    double m = (double)((bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (bits >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
                    double e = ((int)(bits >> 52) & 0x7FF) - 1022;
                    return MathLibV.varargsOf(MathLibV.valueOf(m), (Varargs)MathLibV.valueOf(e));
                }
                case 1: {
                    double m = args.checkdouble(1);
                    int i = 2;
                    int n = args.narg();
                    while (i <= n) {
                        m = Math.max(m, args.checkdouble(i));
                        ++i;
                    }
                    return MathLibV.valueOf(m);
                }
                case 2: {
                    double m = args.checkdouble(1);
                    int i = 2;
                    int n = args.narg();
                    while (i <= n) {
                        m = Math.min(m, args.checkdouble(i));
                        ++i;
                    }
                    return MathLibV.valueOf(m);
                }
                case 3: {
                    double x = args.checkdouble(1);
                    double intPart = x > 0.0 ? Math.floor(x) : Math.ceil(x);
                    double fracPart = x - intPart;
                    return MathLibV.varargsOf(MathLibV.valueOf(intPart), (Varargs)MathLibV.valueOf(fracPart));
                }
                case 4: {
                    long seed = args.checklong(1);
                    this.mathlib.random = new Random(seed);
                    return NONE;
                }
                case 5: {
                    if (this.mathlib.random == null) {
                        this.mathlib.random = new Random();
                    }
                    switch (args.narg()) {
                        case 0: {
                            return MathLibV.valueOf(this.mathlib.random.nextDouble());
                        }
                        case 1: {
                            int m = args.checkint(1);
                            if (m < 1) {
                                MathLibV.argerror(1, "interval is empty");
                            }
                            return MathLibV.valueOf(1 + this.mathlib.random.nextInt(m));
                        }
                    }
                    int m = args.checkint(1);
                    int n = args.checkint(2);
                    if (n < m) {
                        MathLibV.argerror(2, "interval is empty");
                    }
                    return MathLibV.valueOf(m + this.mathlib.random.nextInt(n + 1 - m));
                }
            }
            return NONE;
        }
    }
}

