/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.util.Date;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class OsLib
extends VarArgFunction {
    public static String TMP_PREFIX = ".luaj";
    public static String TMP_SUFFIX = "tmp";
    private static final int INIT = 0;
    private static final int CLOCK = 1;
    private static final int DATE = 2;
    private static final int DIFFTIME = 3;
    private static final int EXECUTE = 4;
    private static final int EXIT = 5;
    private static final int GETENV = 6;
    private static final int REMOVE = 7;
    private static final int RENAME = 8;
    private static final int SETLOCALE = 9;
    private static final int TIME = 10;
    private static final int TMPNAME = 11;
    private static final String[] NAMES = new String[]{"clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
    private static final long t0;
    private static long tmpnames;

    static {
        tmpnames = t0 = System.currentTimeMillis();
    }

    public LuaValue init() {
        LuaTable t = new LuaTable();
        this.bind(t, this.getClass(), NAMES, 1);
        this.env.set("os", (LuaValue)t);
        PackageLib.instance.LOADED.set("os", (LuaValue)t);
        return t;
    }

    @Override
    public Varargs invoke(Varargs args) {
        try {
            switch (this.opcode) {
                case 0: {
                    return this.init();
                }
                case 1: {
                    return OsLib.valueOf(this.clock());
                }
                case 2: {
                    String s = args.optjstring(1, null);
                    double t = args.optdouble(2, -1.0);
                    return OsLib.valueOf(this.date(s, t == -1.0 ? (double)System.currentTimeMillis() / 1000.0 : t));
                }
                case 3: {
                    return OsLib.valueOf(this.difftime(args.checkdouble(1), args.checkdouble(2)));
                }
                case 4: {
                    return OsLib.valueOf(this.execute(args.optjstring(1, null)));
                }
                case 5: {
                    this.exit(args.optint(1, 0));
                    return NONE;
                }
                case 6: {
                    String val = this.getenv(args.checkjstring(1));
                    return val != null ? OsLib.valueOf(val) : NIL;
                }
                case 7: {
                    this.remove(args.checkjstring(1));
                    return LuaValue.TRUE;
                }
                case 8: {
                    this.rename(args.checkjstring(1), args.checkjstring(2));
                    return LuaValue.TRUE;
                }
                case 9: {
                    String s = this.setlocale(args.optjstring(1, null), args.optjstring(2, "all"));
                    return s != null ? OsLib.valueOf(s) : NIL;
                }
                case 10: {
                    return OsLib.valueOf(this.time(args.arg1().isnil() ? null : args.checktable(1)));
                }
                case 11: {
                    return OsLib.valueOf(this.tmpname());
                }
            }
            return NONE;
        }
        catch (IOException e) {
            return OsLib.varargsOf(NIL, (Varargs)OsLib.valueOf(e.getMessage()));
        }
    }

    protected double clock() {
        return (double)(System.currentTimeMillis() - t0) / 1000.0;
    }

    protected double difftime(double t2, double t1) {
        return t2 - t1;
    }

    protected String date(String format, double time) {
        return new Date((long)(time * 1000.0)).toString();
    }

    protected int execute(String command) {
        return 0;
    }

    protected void exit(int code) {
        System.exit(code);
    }

    protected String getenv(String varname) {
        return System.getProperty(varname);
    }

    protected void remove(String filename) throws IOException {
        throw new IOException("not implemented");
    }

    protected void rename(String oldname, String newname) throws IOException {
        throw new IOException("not implemented");
    }

    protected String setlocale(String locale, String category) {
        return "C";
    }

    protected long time(LuaTable table) {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String tmpname() {
        Class<OsLib> clazz = OsLib.class;
        synchronized (OsLib.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return String.valueOf(TMP_PREFIX) + tmpnames++ + TMP_SUFFIX;
        }
    }
}

