/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.InputStream;
import java.io.PrintStream;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.BaseLib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class PackageLib
extends OneArgFunction {
    public static String DEFAULT_LUA_PATH = "?.lua";
    public InputStream STDIN = null;
    public PrintStream STDOUT = System.out;
    public LuaTable LOADED;
    public LuaTable PACKAGE;
    public static PackageLib instance;
    public LuaValue preload_loader;
    public LuaValue lua_loader;
    public LuaValue java_loader;
    private static final LuaString _M;
    private static final LuaString _NAME;
    private static final LuaString _PACKAGE;
    private static final LuaString _DOT;
    private static final LuaString _LOADERS;
    private static final LuaString _LOADED;
    private static final LuaString _LOADLIB;
    private static final LuaString _PRELOAD;
    private static final LuaString _PATH;
    private static final LuaString _SEEALL;
    private static final LuaString _SENTINEL;
    private static final int OP_MODULE = 0;
    private static final int OP_REQUIRE = 1;
    private static final int OP_LOADLIB = 2;
    private static final int OP_SEEALL = 3;
    private static final int OP_PRELOAD_LOADER = 4;
    private static final int OP_LUA_LOADER = 5;
    private static final int OP_JAVA_LOADER = 6;

    static {
        _M = PackageLib.valueOf("_M");
        _NAME = PackageLib.valueOf("_NAME");
        _PACKAGE = PackageLib.valueOf("_PACKAGE");
        _DOT = PackageLib.valueOf(".");
        _LOADERS = PackageLib.valueOf("loaders");
        _LOADED = PackageLib.valueOf("loaded");
        _LOADLIB = PackageLib.valueOf("loadlib");
        _PRELOAD = PackageLib.valueOf("preload");
        _PATH = PackageLib.valueOf("path");
        _SEEALL = PackageLib.valueOf("seeall");
        _SENTINEL = PackageLib.valueOf("\u0001");
    }

    public PackageLib() {
        instance = this;
    }

    @Override
    public LuaValue call(LuaValue arg) {
        this.env.set("require", (LuaValue)new PkgLib1(this.env, "require", 1, this));
        this.env.set("module", (LuaValue)new PkgLibV(this.env, "module", 0, this));
        LuaValue[] luaValueArray = new LuaValue[12];
        luaValueArray[0] = _LOADED;
        this.LOADED = PackageLib.tableOf();
        luaValueArray[1] = this.LOADED;
        luaValueArray[2] = _PRELOAD;
        luaValueArray[3] = PackageLib.tableOf();
        luaValueArray[4] = _PATH;
        luaValueArray[5] = PackageLib.valueOf(DEFAULT_LUA_PATH);
        luaValueArray[6] = _LOADLIB;
        luaValueArray[7] = new PkgLibV(this.env, "loadlib", 2, this);
        luaValueArray[8] = _SEEALL;
        luaValueArray[9] = new PkgLib1(this.env, "seeall", 3, this);
        luaValueArray[10] = _LOADERS;
        this.preload_loader = new PkgLibV(this.env, "preload_loader", 4, this);
        this.lua_loader = new PkgLibV(this.env, "lua_loader", 5, this);
        this.java_loader = new PkgLibV(this.env, "java_loader", 6, this);
        luaValueArray[11] = PackageLib.listOf(new LuaValue[]{this.preload_loader, this.lua_loader, this.java_loader});
        this.PACKAGE = PackageLib.tableOf(luaValueArray);
        this.env.set("package", (LuaValue)this.PACKAGE);
        this.LOADED.set("package", (LuaValue)this.PACKAGE);
        return this.env;
    }

    public void setIsLoaded(String name, LuaTable value) {
        this.LOADED.set(name, (LuaValue)value);
    }

    public void setLuaPath(String newLuaPath) {
        this.PACKAGE.set(_PATH, (LuaValue)PackageLib.valueOf(newLuaPath));
    }

    @Override
    public String tojstring() {
        return "package";
    }

    public Varargs module(Varargs args) {
        LuaFunction f;
        LuaValue module;
        LuaString modname = args.checkstring(1);
        int n = args.narg();
        LuaValue value = this.LOADED.get(modname);
        if (!value.istable()) {
            LuaValue globals = LuaThread.getGlobals();
            module = PackageLib.findtable(globals, modname);
            if (module == null) {
                PackageLib.error("name conflict for module '" + modname + "'");
            }
            this.LOADED.set(modname, module);
        } else {
            module = (LuaTable)value;
        }
        LuaValue name = ((LuaValue)module).get(_NAME);
        if (name.isnil()) {
            PackageLib.modinit(module, modname);
        }
        if ((f = LuaThread.getCallstackFunction(1)) == null) {
            PackageLib.error("no calling function");
        }
        if (!f.isclosure()) {
            PackageLib.error("'module' not called from a Lua function");
        }
        f.setfenv(module);
        int i = 2;
        while (i <= n) {
            args.arg(i).call(module);
            ++i;
        }
        return NONE;
    }

    private static final LuaValue findtable(LuaValue table, LuaString fname) {
        int e = -1;
        do {
            LuaString key;
            LuaValue val;
            int b;
            if ((e = fname.indexOf(_DOT, b = e + 1)) < 0) {
                e = fname.m_length;
            }
            if ((val = table.rawget(key = fname.substring(b, e))).isnil()) {
                LuaTable field = new LuaTable();
                table.set(key, (LuaValue)field);
                table = field;
                continue;
            }
            if (!val.istable()) {
                return null;
            }
            table = val;
        } while (e < fname.m_length);
        return table;
    }

    private static final void modinit(LuaValue module, LuaString modname) {
        module.set(_M, module);
        int e = modname.lastIndexOf(_DOT);
        module.set(_NAME, (LuaValue)modname);
        module.set(_PACKAGE, (LuaValue)(e < 0 ? EMPTYSTRING : modname.substring(0, e + 1)));
    }

    public LuaValue require(LuaValue arg) {
        LuaString name = arg.checkstring();
        LuaValue loaded = this.LOADED.get(name);
        if (loaded.toboolean()) {
            if (loaded == _SENTINEL) {
                PackageLib.error("loop or previous error loading module '" + name + "'");
            }
            return loaded;
        }
        LuaTable tbl = this.PACKAGE.get(_LOADERS).checktable();
        StringBuffer sb = new StringBuffer();
        LuaValue chunk = null;
        int i = 1;
        while (true) {
            LuaValue loader;
            if ((loader = tbl.get(i)).isnil()) {
                PackageLib.error("module '" + name + "' not found: " + name + sb);
            }
            if ((chunk = loader.call(name)).isfunction()) break;
            if (chunk.isstring()) {
                sb.append(chunk.tojstring());
            }
            ++i;
        }
        this.LOADED.set(name, (LuaValue)_SENTINEL);
        LuaValue result = chunk.call(name);
        if (!result.isnil()) {
            this.LOADED.set(name, result);
        } else {
            result = this.LOADED.get(name);
            if (result == _SENTINEL) {
                result = LuaValue.TRUE;
                this.LOADED.set(name, result);
            }
        }
        return result;
    }

    public static Varargs loadlib(Varargs args) {
        args.checkstring(1);
        return PackageLib.varargsOf(NIL, PackageLib.valueOf("dynamic libraries not enabled"), PackageLib.valueOf("absent"));
    }

    LuaValue loader_preload(Varargs args) {
        LuaString name = args.checkstring(1);
        LuaTable preload = this.PACKAGE.get(_PRELOAD).checktable();
        LuaValue val = ((LuaValue)preload).get(name);
        return val.isnil() ? PackageLib.valueOf("\n\tno field package.preload['" + name + "']") : val;
    }

    LuaValue loader_Lua(Varargs args) {
        String name = args.checkjstring(1);
        Object is = null;
        LuaValue pp = this.PACKAGE.get(_PATH);
        if (!pp.isstring()) {
            return PackageLib.valueOf("package.path is not a string");
        }
        String path = pp.tojstring();
        int e = -1;
        int n = path.length();
        StringBuffer sb = null;
        name = name.replace('.', '/');
        while (e < n) {
            Varargs v;
            int b = e + 1;
            if ((e = path.indexOf(59, b)) < 0) {
                e = path.length();
            }
            String template = path.substring(b, e);
            int q = template.indexOf(63);
            String filename = template;
            if (q >= 0) {
                filename = String.valueOf(template.substring(0, q)) + name + template.substring(q + 1);
            }
            if ((v = BaseLib.loadFile(filename)).arg1().isfunction()) {
                return v.arg1();
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append("\n\t'" + filename + "': " + v.arg(2));
        }
        return PackageLib.valueOf(sb.toString());
    }

    LuaValue loader_Java(Varargs args) {
        String name = args.checkjstring(1);
        String classname = PackageLib.toClassname(name);
        Class<?> c = null;
        LuaValue v = null;
        try {
            c = Class.forName(classname);
            v = (LuaValue)c.newInstance();
            v.setfenv(this.env);
            return v;
        }
        catch (ClassNotFoundException cnfe) {
            return PackageLib.valueOf("\n\tno class '" + classname + "'");
        }
        catch (Exception e) {
            return PackageLib.valueOf("\n\tjava load failed on '" + classname + "', " + e);
        }
    }

    public static final String toClassname(String filename) {
        int n;
        int j = n = filename.length();
        if (filename.endsWith(".lua")) {
            j -= 4;
        }
        int k = 0;
        while (k < j) {
            int c = filename.charAt(k);
            if (!PackageLib.isClassnamePart((char)c) || c == 47 || c == 92) {
                StringBuffer sb = new StringBuffer(j);
                int i = 0;
                while (i < j) {
                    c = filename.charAt(i);
                    sb.append((char)(PackageLib.isClassnamePart((char)c) ? c : (c == 47 || c == 92 ? 46 : 95)));
                    ++i;
                }
                return sb.toString();
            }
            ++k;
        }
        return n == j ? filename : filename.substring(0, j);
    }

    private static final boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static final class PkgLib1
    extends OneArgFunction {
        PackageLib lib;

        public PkgLib1(LuaValue env, String name, int opcode, PackageLib lib) {
            this.env = env;
            this.name = name;
            this.opcode = opcode;
            this.lib = lib;
        }

        @Override
        public LuaValue call(LuaValue arg) {
            switch (this.opcode) {
                case 1: {
                    return this.lib.require(arg);
                }
                case 3: {
                    LuaTable t = arg.checktable();
                    LuaValue m = t.getmetatable();
                    if (m == null) {
                        m = PkgLib1.tableOf();
                        t.setmetatable(m);
                    }
                    m.set(INDEX, LuaThread.getGlobals());
                    return NONE;
                }
            }
            return NIL;
        }
    }

    public static final class PkgLibV
    extends VarArgFunction {
        PackageLib lib;

        public PkgLibV(LuaValue env, String name, int opcode, PackageLib lib) {
            this.env = env;
            this.name = name;
            this.opcode = opcode;
            this.lib = lib;
        }

        @Override
        public Varargs invoke(Varargs args) {
            switch (this.opcode) {
                case 0: {
                    return this.lib.module(args);
                }
                case 2: {
                    return PackageLib.loadlib(args);
                }
                case 4: {
                    return this.lib.loader_preload(args);
                }
                case 5: {
                    return this.lib.loader_Lua(args);
                }
                case 6: {
                    return this.lib.loader_Java(args);
                }
            }
            return NONE;
        }
    }
}

