/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class TableLib
extends OneArgFunction {
    private LuaTable init() {
        LuaTable t = new LuaTable();
        this.bind(t, TableLib.class, new String[]{"getn", "maxn"}, 1);
        this.bind(t, TableLibV.class, new String[]{"remove", "concat", "insert", "sort", "foreach", "foreachi"});
        this.env.set("table", (LuaValue)t);
        PackageLib.instance.LOADED.set("table", (LuaValue)t);
        return t;
    }

    @Override
    public LuaValue call(LuaValue arg) {
        switch (this.opcode) {
            case 0: {
                return this.init();
            }
            case 1: {
                return arg.checktable().getn();
            }
            case 2: {
                return TableLib.valueOf(arg.checktable().maxn());
            }
        }
        return NIL;
    }

    public static final class TableLibV
    extends VarArgFunction {
        @Override
        public Varargs invoke(Varargs args) {
            switch (this.opcode) {
                case 0: {
                    LuaTable table = args.checktable(1);
                    int pos = args.narg() > 1 ? args.checkint(2) : 0;
                    return table.remove(pos);
                }
                case 1: {
                    LuaTable table = args.checktable(1);
                    return table.concat(args.optstring(2, LuaValue.EMPTYSTRING), args.optint(3, 1), args.isvalue(4) ? args.checkint(4) : table.length());
                }
                case 2: {
                    LuaTable table = args.checktable(1);
                    int pos = args.narg() > 2 ? args.checkint(2) : 0;
                    LuaValue value = args.arg(args.narg() > 2 ? 3 : 2);
                    table.insert(pos, value);
                    return NONE;
                }
                case 3: {
                    LuaTable table = args.checktable(1);
                    LuaValue compare = args.isnoneornil(2) ? NIL : args.checkfunction(2);
                    table.sort(compare);
                    return NONE;
                }
                case 4: {
                    return args.checktable(1).foreach(args.checkfunction(2));
                }
                case 5: {
                    return args.checktable(1).foreachi(args.checkfunction(2));
                }
            }
            return NONE;
        }
    }
}

