/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptableObject {
    static final long serialVersionUID = 7331366857676127338L;
    private static final Object ARRAY_TAG = "Array";
    private static final Integer NEGATIVE_ONE = new Integer(-1);
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int MAX_PROTOTYPE_ID = 21;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_unshift = -11;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_some = -21;
    private long length;
    private Object[] dense;
    private boolean denseOnly;
    private static int maximumInitialCapacity = 10000;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final double GROW_FACTOR = 1.5;
    private static final int MAX_PRE_GROW_SIZE = 0x55555554;

    static void init(Scriptable scope, boolean sealed) {
        NativeArray obj = new NativeArray(0L);
        obj.exportAsJSClass(21, scope, sealed);
    }

    static int getMaximumInitialCapacity() {
        return maximumInitialCapacity;
    }

    static void setMaximumInitialCapacity(int maximumInitialCapacity) {
        NativeArray.maximumInitialCapacity = maximumInitialCapacity;
    }

    public NativeArray(long lengthArg) {
        boolean bl = this.denseOnly = lengthArg <= (long)maximumInitialCapacity;
        if (this.denseOnly) {
            int intLength = (int)lengthArg;
            if (intLength < 10) {
                intLength = 10;
            }
            this.dense = new Object[intLength];
            Arrays.fill(this.dense, Scriptable.NOT_FOUND);
        }
        this.length = lengthArg;
    }

    public NativeArray(Object[] array) {
        this.denseOnly = true;
        this.dense = array;
        this.length = array.length;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        if (s.equals("length")) {
            return NativeArray.instanceIdInfo(6, 1);
        }
        return super.findInstanceIdInfo(s);
    }

    @Override
    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "length";
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void setInstanceIdValue(int id, Object value) {
        if (id == 1) {
            this.setLength(value);
            return;
        }
        super.setInstanceIdValue(id, value);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -5, "join", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -6, "reverse", 1);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -7, "sort", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -8, "push", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -9, "pop", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -10, "shift", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -11, "unshift", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -12, "splice", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -13, "concat", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -14, "slice", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -15, "indexOf", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -16, "lastIndexOf", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -17, "every", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -18, "filter", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -19, "forEach", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -20, "map", 2);
        this.addIdFunctionProperty(ctor, ARRAY_TAG, -21, "some", 2);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 1;
                s = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s = "toSource";
                break;
            }
            case 5: {
                arity = 1;
                s = "join";
                break;
            }
            case 6: {
                arity = 0;
                s = "reverse";
                break;
            }
            case 7: {
                arity = 1;
                s = "sort";
                break;
            }
            case 8: {
                arity = 1;
                s = "push";
                break;
            }
            case 9: {
                arity = 1;
                s = "pop";
                break;
            }
            case 10: {
                arity = 1;
                s = "shift";
                break;
            }
            case 11: {
                arity = 1;
                s = "unshift";
                break;
            }
            case 12: {
                arity = 1;
                s = "splice";
                break;
            }
            case 13: {
                arity = 1;
                s = "concat";
                break;
            }
            case 14: {
                arity = 1;
                s = "slice";
                break;
            }
            case 15: {
                arity = 1;
                s = "indexOf";
                break;
            }
            case 16: {
                arity = 1;
                s = "lastIndexOf";
                break;
            }
            case 17: {
                arity = 1;
                s = "every";
                break;
            }
            case 18: {
                arity = 1;
                s = "filter";
                break;
            }
            case 19: {
                arity = 1;
                s = "forEach";
                break;
            }
            case 20: {
                arity = 1;
                s = "map";
                break;
            }
            case 21: {
                arity = 1;
                s = "some";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, id, s, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ARRAY_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        block20: while (true) {
            switch (id) {
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    thisObj = ScriptRuntime.toObject(scope, args[0]);
                    Object[] newArgs = new Object[args.length - 1];
                    int i = 0;
                    while (i < newArgs.length) {
                        newArgs[i] = args[i + 1];
                        ++i;
                    }
                    args = newArgs;
                    id = -id;
                    continue block20;
                }
                case 1: {
                    boolean inNewExpr;
                    boolean bl = inNewExpr = thisObj == null;
                    if (!inNewExpr) {
                        return f.construct(cx, scope, args);
                    }
                    return NativeArray.jsConstructor(cx, scope, args);
                }
                case 2: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, cx.hasFeature(4), false);
                }
                case 3: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, false, true);
                }
                case 4: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, true, false);
                }
                case 5: {
                    return NativeArray.js_join(cx, thisObj, args);
                }
                case 6: {
                    return NativeArray.js_reverse(cx, thisObj, args);
                }
                case 7: {
                    return NativeArray.js_sort(cx, scope, thisObj, args);
                }
                case 8: {
                    return NativeArray.js_push(cx, thisObj, args);
                }
                case 9: {
                    return NativeArray.js_pop(cx, thisObj, args);
                }
                case 10: {
                    return NativeArray.js_shift(cx, thisObj, args);
                }
                case 11: {
                    return NativeArray.js_unshift(cx, thisObj, args);
                }
                case 12: {
                    return NativeArray.js_splice(cx, scope, thisObj, args);
                }
                case 13: {
                    return NativeArray.js_concat(cx, scope, thisObj, args);
                }
                case 14: {
                    return this.js_slice(cx, thisObj, args);
                }
                case 15: {
                    return this.indexOfHelper(cx, thisObj, args, false);
                }
                case 16: {
                    return this.indexOfHelper(cx, thisObj, args, true);
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    return this.iterativeMethod(cx, id, scope, thisObj, args);
                }
            }
            break;
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (!this.denseOnly && this.isGetterOrSetter(null, index, false)) {
            return super.get(index, start);
        }
        if (this.dense != null && index >= 0 && index < this.dense.length) {
            return this.dense[index];
        }
        return super.get(index, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (!this.denseOnly && this.isGetterOrSetter(null, index, false)) {
            return super.has(index, start);
        }
        if (this.dense != null && index >= 0 && index < this.dense.length) {
            return this.dense[index] != NOT_FOUND;
        }
        return super.has(index, start);
    }

    private static long toArrayIndex(String id) {
        long index;
        double d = ScriptRuntime.toNumber(id);
        if (d == d && (double)(index = ScriptRuntime.toUint32(d)) == d && index != 0xFFFFFFFFL && Long.toString(index).equals(id)) {
            return index;
        }
        return -1L;
    }

    @Override
    public void put(String id, Scriptable start, Object value) {
        long index;
        super.put(id, start, value);
        if (start == this && (index = NativeArray.toArrayIndex(id)) >= this.length) {
            this.length = index + 1L;
            this.denseOnly = false;
        }
    }

    private boolean ensureCapacity(int capacity) {
        if (capacity > this.dense.length) {
            if (capacity > 0x55555554) {
                this.denseOnly = false;
                return false;
            }
            capacity = Math.max(capacity, (int)((double)this.dense.length * 1.5));
            Object[] newDense = new Object[capacity];
            System.arraycopy(this.dense, 0, newDense, 0, this.dense.length);
            Arrays.fill(newDense, this.dense.length, newDense.length, Scriptable.NOT_FOUND);
            this.dense = newDense;
        }
        return true;
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (!(start != this || this.isSealed() || this.dense == null || index < 0 || !this.denseOnly && this.isGetterOrSetter(null, index, true))) {
            if (index < this.dense.length) {
                this.dense[index] = value;
                if (this.length <= (long)index) {
                    this.length = (long)index + 1L;
                }
                return;
            }
            if (this.denseOnly && (double)index < (double)this.dense.length * 1.5 && this.ensureCapacity(index + 1)) {
                this.dense[index] = value;
                this.length = (long)index + 1L;
                return;
            }
            this.denseOnly = false;
        }
        super.put(index, start, value);
        if (start == this && this.length <= (long)index) {
            this.length = (long)index + 1L;
        }
    }

    @Override
    public void delete(int index) {
        if (!(this.dense == null || index < 0 || index >= this.dense.length || this.isSealed() || !this.denseOnly && this.isGetterOrSetter(null, index, true))) {
            this.dense[index] = NOT_FOUND;
        } else {
            super.delete(index);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] superIds = super.getIds();
        if (this.dense == null) {
            return superIds;
        }
        int N = this.dense.length;
        long currentLength = this.length;
        if ((long)N > currentLength) {
            N = (int)currentLength;
        }
        if (N == 0) {
            return superIds;
        }
        int superLength = superIds.length;
        Object[] ids = new Object[N + superLength];
        int presentCount = 0;
        int i = 0;
        while (i != N) {
            if (this.dense[i] != NOT_FOUND) {
                ids[presentCount] = new Integer(i);
                ++presentCount;
            }
            ++i;
        }
        if (presentCount != N) {
            Object[] tmp = new Object[presentCount + superLength];
            System.arraycopy(ids, 0, tmp, 0, presentCount);
            ids = tmp;
        }
        System.arraycopy(superIds, 0, ids, presentCount, superLength);
        return ids;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        Context cx;
        if (hint == ScriptRuntime.NumberClass && (cx = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(hint);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args) {
        if (args.length == 0) {
            return new NativeArray(0L);
        }
        if (cx.getLanguageVersion() == 120) {
            return new NativeArray(args);
        }
        Object arg0 = args[0];
        if (args.length > 1 || !(arg0 instanceof Number)) {
            return new NativeArray(args);
        }
        long len = ScriptRuntime.toUint32(arg0);
        if ((double)len != ((Number)arg0).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(len);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    void setDenseOnly(boolean denseOnly) {
        if (denseOnly && !this.denseOnly) {
            throw new IllegalArgumentException();
        }
        this.denseOnly = denseOnly;
    }

    private void setLength(Object val) {
        double d = ScriptRuntime.toNumber(val);
        long longVal = ScriptRuntime.toUint32(d);
        if ((double)longVal != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (this.denseOnly) {
            if (longVal < this.length) {
                Arrays.fill(this.dense, (int)longVal, this.dense.length, NOT_FOUND);
                this.length = longVal;
                return;
            }
            if (longVal < 0x55555554L && (double)longVal < (double)this.length * 1.5 && this.ensureCapacity((int)longVal)) {
                this.length = longVal;
                return;
            }
            this.denseOnly = false;
        }
        if (longVal < this.length) {
            if (this.length - longVal > 4096L) {
                Object[] e = this.getIds();
                int i = 0;
                while (i < e.length) {
                    Object id = e[i];
                    if (id instanceof String) {
                        String strId = (String)id;
                        long index = NativeArray.toArrayIndex(strId);
                        if (index >= longVal) {
                            this.delete(strId);
                        }
                    } else {
                        int index = (Integer)id;
                        if ((long)index >= longVal) {
                            this.delete(index);
                        }
                    }
                    ++i;
                }
            } else {
                long i = longVal;
                while (i < this.length) {
                    NativeArray.deleteElem(this, i);
                    ++i;
                }
            }
        }
        this.length = longVal;
    }

    static long getLengthProperty(Context cx, Scriptable obj) {
        if (obj instanceof NativeString) {
            return ((NativeString)obj).getLength();
        }
        if (obj instanceof NativeArray) {
            return ((NativeArray)obj).getLength();
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getObjectProp(obj, "length", cx));
    }

    private static Object setLengthProperty(Context cx, Scriptable target, long length) {
        return ScriptRuntime.setObjectProp(target, "length", (Object)ScriptRuntime.wrapNumber(length), cx);
    }

    private static void deleteElem(Scriptable target, long index) {
        int i = (int)index;
        if ((long)i == index) {
            target.delete(i);
        } else {
            target.delete(Long.toString(index));
        }
    }

    private static Object getElem(Context cx, Scriptable target, long index) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            return ScriptRuntime.getObjectProp(target, id, cx);
        }
        return ScriptRuntime.getObjectIndex(target, (int)index, cx);
    }

    private static void setElem(Context cx, Scriptable target, long index, Object value) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            ScriptRuntime.setObjectProp(target, id, value, cx);
        } else {
            ScriptRuntime.setObjectIndex(target, (int)index, value, cx);
        }
    }

    private static String toStringHelper(Context cx, Scriptable scope, Scriptable thisObj, boolean toSource, boolean toLocale) {
        boolean iterating;
        boolean toplevel;
        String separator;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        StringBuilder result = new StringBuilder(256);
        if (toSource) {
            result.append('[');
            separator = ", ";
        } else {
            separator = ",";
        }
        boolean haslast = false;
        long i = 0L;
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        try {
            if (!iterating) {
                cx.iterating.put(thisObj, 0);
                i = 0L;
                while (i < length) {
                    Object elem;
                    if (i > 0L) {
                        result.append(separator);
                    }
                    if ((elem = NativeArray.getElem(cx, thisObj, i)) == null || elem == Undefined.instance) {
                        haslast = false;
                    } else {
                        haslast = true;
                        if (toSource) {
                            result.append(ScriptRuntime.uneval(cx, scope, elem));
                        } else if (elem instanceof String) {
                            String s = (String)elem;
                            if (toSource) {
                                result.append('\"');
                                result.append(ScriptRuntime.escapeString(s));
                                result.append('\"');
                            } else {
                                result.append(s);
                            }
                        } else {
                            if (toLocale) {
                                Callable fun = ScriptRuntime.getPropFunctionAndThis(elem, "toLocaleString", cx);
                                Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
                                elem = fun.call(cx, scope, funThis, ScriptRuntime.emptyArgs);
                            }
                            result.append(ScriptRuntime.toString(elem));
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (toplevel) {
                cx.iterating = null;
            }
        }
        if (toSource) {
            if (!haslast && i > 0L) {
                result.append(", ]");
            } else {
                result.append(']');
            }
        }
        return result.toString();
    }

    private static String js_join(Context cx, Scriptable thisObj, Object[] args) {
        String str;
        String separator;
        int length;
        long llength = NativeArray.getLengthProperty(cx, thisObj);
        if (llength != (long)(length = (int)llength)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(llength));
        }
        String string = separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < length) {
                    Object temp;
                    if (i != 0) {
                        sb.append(separator);
                    }
                    if (i < na.dense.length && (temp = na.dense[i]) != null && temp != Undefined.instance && temp != Scriptable.NOT_FOUND) {
                        sb.append(ScriptRuntime.toString(temp));
                    }
                    ++i;
                }
                return sb.toString();
            }
        }
        if (length == 0) {
            return "";
        }
        String[] buf = new String[length];
        int total_size = 0;
        int i = 0;
        while (i != length) {
            Object temp = NativeArray.getElem(cx, thisObj, i);
            if (temp != null && temp != Undefined.instance) {
                str = ScriptRuntime.toString(temp);
                total_size += str.length();
                buf[i] = str;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder(total_size += (length - 1) * separator.length());
        int i2 = 0;
        while (i2 != length) {
            if (i2 != 0) {
                sb.append(separator);
            }
            if ((str = buf[i2]) != null) {
                sb.append(str);
            }
            ++i2;
        }
        return sb.toString();
    }

    private static Scriptable js_reverse(Context cx, Scriptable thisObj, Object[] args) {
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                int i = 0;
                int j = (int)na.length - 1;
                while (i < j) {
                    Object temp = na.dense[i];
                    na.dense[i] = na.dense[j];
                    na.dense[j] = temp;
                    ++i;
                    --j;
                }
                return thisObj;
            }
        }
        long len = NativeArray.getLengthProperty(cx, thisObj);
        long half = len / 2L;
        long i = 0L;
        while (i < half) {
            long j = len - i - 1L;
            Object temp1 = NativeArray.getElem(cx, thisObj, i);
            Object temp2 = NativeArray.getElem(cx, thisObj, j);
            NativeArray.setElem(cx, thisObj, i, temp2);
            NativeArray.setElem(cx, thisObj, j, temp1);
            ++i;
        }
        return thisObj;
    }

    private static Scriptable js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] cmpBuf;
        Object compare;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (length <= 1L) {
            return thisObj;
        }
        if (args.length > 0 && Undefined.instance != args[0]) {
            compare = args[0];
            cmpBuf = new Object[2];
        } else {
            compare = null;
            cmpBuf = null;
        }
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                int ilength = (int)length;
                NativeArray.heapsort(cx, scope, na.dense, ilength, compare, cmpBuf);
                return thisObj;
            }
        }
        if (length >= Integer.MAX_VALUE) {
            NativeArray.heapsort_extended(cx, scope, thisObj, length, compare, cmpBuf);
        } else {
            int ilength = (int)length;
            Object[] working = new Object[ilength];
            int i = 0;
            while (i != ilength) {
                working[i] = NativeArray.getElem(cx, thisObj, i);
                ++i;
            }
            NativeArray.heapsort(cx, scope, working, ilength, compare, cmpBuf);
            i = 0;
            while (i != ilength) {
                NativeArray.setElem(cx, thisObj, i, working[i]);
                ++i;
            }
        }
        return thisObj;
    }

    private static boolean isBigger(Context cx, Scriptable scope, Object x, Object y, Object cmp, Object[] cmpBuf) {
        Scriptable funThis;
        if (cmp == null) {
            if (cmpBuf != null) {
                Kit.codeBug();
            }
        } else if (cmpBuf == null || cmpBuf.length != 2) {
            Kit.codeBug();
        }
        Object undef = Undefined.instance;
        Object notfound = Scriptable.NOT_FOUND;
        if (y == undef || y == notfound) {
            return false;
        }
        if (x == undef || x == notfound) {
            return true;
        }
        if (cmp == null) {
            String b;
            String a = ScriptRuntime.toString(x);
            return a.compareTo(b = ScriptRuntime.toString(y)) > 0;
        }
        cmpBuf[0] = x;
        cmpBuf[1] = y;
        Callable fun = ScriptRuntime.getValueFunctionAndThis(cmp, cx);
        Object ret = fun.call(cx, scope, funThis = ScriptRuntime.lastStoredScriptable(cx), cmpBuf);
        double d = ScriptRuntime.toNumber(ret);
        return d > 0.0;
    }

    private static void heapsort(Context cx, Scriptable scope, Object[] array, int length, Object cmp, Object[] cmpBuf) {
        Object pivot;
        if (length <= 1) {
            Kit.codeBug();
        }
        int i = length / 2;
        while (i != 0) {
            pivot = array[--i];
            NativeArray.heapify(cx, scope, pivot, array, i, length, cmp, cmpBuf);
        }
        i = length;
        while (i != 1) {
            pivot = array[--i];
            array[i] = array[0];
            NativeArray.heapify(cx, scope, pivot, array, 0, i, cmp, cmpBuf);
        }
    }

    private static void heapify(Context cx, Scriptable scope, Object pivot, Object[] array, int i, int end, Object cmp, Object[] cmpBuf) {
        int child;
        while ((child = i * 2 + 1) < end) {
            Object nextVal;
            Object childVal = array[child];
            if (child + 1 < end && NativeArray.isBigger(cx, scope, nextVal = array[child + 1], childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            array[i] = childVal;
            i = child;
        }
        array[i] = pivot;
    }

    private static void heapsort_extended(Context cx, Scriptable scope, Scriptable target, long length, Object cmp, Object[] cmpBuf) {
        Object pivot;
        if (length <= 1L) {
            Kit.codeBug();
        }
        long i = length / 2L;
        while (i != 0L) {
            pivot = NativeArray.getElem(cx, target, --i);
            NativeArray.heapify_extended(cx, scope, pivot, target, i, length, cmp, cmpBuf);
        }
        i = length;
        while (i != 1L) {
            pivot = NativeArray.getElem(cx, target, --i);
            NativeArray.setElem(cx, target, i, NativeArray.getElem(cx, target, 0L));
            NativeArray.heapify_extended(cx, scope, pivot, target, 0L, i, cmp, cmpBuf);
        }
    }

    private static void heapify_extended(Context cx, Scriptable scope, Object pivot, Scriptable target, long i, long end, Object cmp, Object[] cmpBuf) {
        long child;
        while ((child = i * 2L + 1L) < end) {
            Object nextVal;
            Object childVal = NativeArray.getElem(cx, target, child);
            if (child + 1L < end && NativeArray.isBigger(cx, scope, nextVal = NativeArray.getElem(cx, target, child + 1L), childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            NativeArray.setElem(cx, target, i, childVal);
            i = child;
        }
        NativeArray.setElem(cx, target, i, pivot);
    }

    private static Object js_push(Context cx, Scriptable thisObj, Object[] args) {
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.ensureCapacity((int)na.length + args.length)) {
                int i = 0;
                while (i < args.length) {
                    na.dense[(int)na.length++] = args[i];
                    ++i;
                }
                return ScriptRuntime.wrapNumber(na.length);
            }
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        int i = 0;
        while (i < args.length) {
            NativeArray.setElem(cx, thisObj, length + (long)i, args[i]);
            ++i;
        }
        Object lengthObj = NativeArray.setLengthProperty(cx, thisObj, length += (long)args.length);
        if (cx.getLanguageVersion() == 120) {
            return args.length == 0 ? Undefined.instance : args[args.length - 1];
        }
        return lengthObj;
    }

    private static Object js_pop(Context cx, Scriptable thisObj, Object[] args) {
        long length;
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.length > 0L) {
                --na.length;
                Object result = na.dense[(int)na.length];
                na.dense[(int)na.length] = NOT_FOUND;
                return result;
            }
        }
        Object result = (length = NativeArray.getLengthProperty(cx, thisObj)) > 0L ? NativeArray.getElem(cx, thisObj, --length) : Undefined.instance;
        NativeArray.setLengthProperty(cx, thisObj, length);
        return result;
    }

    private static Object js_shift(Context cx, Scriptable thisObj, Object[] args) {
        Object result;
        long length;
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.length > 0L) {
                --na.length;
                Object result2 = na.dense[0];
                System.arraycopy(na.dense, 1, na.dense, 0, (int)na.length);
                na.dense[(int)na.length] = NOT_FOUND;
                return result2;
            }
        }
        if ((length = NativeArray.getLengthProperty(cx, thisObj)) > 0L) {
            long i = 0L;
            result = NativeArray.getElem(cx, thisObj, i);
            if (--length > 0L) {
                i = 1L;
                while (i <= length) {
                    Object temp = NativeArray.getElem(cx, thisObj, i);
                    NativeArray.setElem(cx, thisObj, i - 1L, temp);
                    ++i;
                }
            }
        } else {
            result = Undefined.instance;
        }
        NativeArray.setLengthProperty(cx, thisObj, length);
        return result;
    }

    private static Object js_unshift(Context cx, Scriptable thisObj, Object[] args) {
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly && na.ensureCapacity((int)na.length + args.length)) {
                System.arraycopy(na.dense, 0, na.dense, args.length, (int)na.length);
                int i = 0;
                while (i < args.length) {
                    na.dense[i] = args[i];
                    ++i;
                }
                na.length += (long)args.length;
                return ScriptRuntime.wrapNumber(na.length);
            }
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        int argc = args.length;
        if (args.length > 0) {
            if (length > 0L) {
                long last = length - 1L;
                while (last >= 0L) {
                    Object temp = NativeArray.getElem(cx, thisObj, last);
                    NativeArray.setElem(cx, thisObj, last + (long)argc, temp);
                    --last;
                }
            }
            int i = 0;
            while (i < args.length) {
                NativeArray.setElem(cx, thisObj, i, args[i]);
                ++i;
            }
            return NativeArray.setLengthProperty(cx, thisObj, length += (long)args.length);
        }
        return ScriptRuntime.wrapNumber(length);
    }

    private static Object js_splice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object temp;
        long last;
        Object result;
        long count;
        NativeArray na = null;
        boolean denseMode = false;
        if (thisObj instanceof NativeArray) {
            na = (NativeArray)thisObj;
            denseMode = na.denseOnly;
        }
        scope = NativeArray.getTopLevelScope(scope);
        int argc = args.length;
        if (argc == 0) {
            return ScriptRuntime.newObject(cx, scope, "Array", null);
        }
        long length = NativeArray.getLengthProperty(cx, thisObj);
        long begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
        --argc;
        if (args.length == 1) {
            count = length - begin;
        } else {
            double dcount = ScriptRuntime.toInteger(args[1]);
            count = dcount < 0.0 ? 0L : (dcount > (double)(length - begin) ? length - begin : (long)dcount);
            --argc;
        }
        long end = begin + count;
        if (count != 0L) {
            if (count == 1L && cx.getLanguageVersion() == 120) {
                result = NativeArray.getElem(cx, thisObj, begin);
            } else if (denseMode) {
                int intLen = (int)(end - begin);
                Object[] copy = new Object[intLen];
                System.arraycopy(na.dense, (int)begin, copy, 0, intLen);
                result = cx.newArray(scope, copy);
            } else {
                Scriptable resultArray = ScriptRuntime.newObject(cx, scope, "Array", null);
                long last2 = begin;
                while (last2 != end) {
                    Object temp2 = NativeArray.getElem(cx, thisObj, last2);
                    NativeArray.setElem(cx, resultArray, last2 - begin, temp2);
                    ++last2;
                }
                result = resultArray;
            }
        } else {
            result = cx.getLanguageVersion() == 120 ? Undefined.instance : ScriptRuntime.newObject(cx, scope, "Array", null);
        }
        long delta = (long)argc - count;
        if (denseMode && length + delta < Integer.MAX_VALUE && na.ensureCapacity((int)(length + delta))) {
            System.arraycopy(na.dense, (int)end, na.dense, (int)(begin + (long)argc), (int)(length - end));
            if (argc > 0) {
                System.arraycopy(args, 2, na.dense, (int)begin, argc);
            }
            if (delta < 0L) {
                Arrays.fill(na.dense, (int)(length + delta), (int)length, NOT_FOUND);
            }
            na.length = length + delta;
            return result;
        }
        if (delta > 0L) {
            last = length - 1L;
            while (last >= end) {
                temp = NativeArray.getElem(cx, thisObj, last);
                NativeArray.setElem(cx, thisObj, last + delta, temp);
                --last;
            }
        } else if (delta < 0L) {
            last = end;
            while (last < length) {
                temp = NativeArray.getElem(cx, thisObj, last);
                NativeArray.setElem(cx, thisObj, last + delta, temp);
                ++last;
            }
        }
        int argoffset = args.length - argc;
        int i = 0;
        while (i < argc) {
            NativeArray.setElem(cx, thisObj, begin + (long)i, args[i + argoffset]);
            ++i;
        }
        NativeArray.setLengthProperty(cx, thisObj, length + delta);
        return result;
    }

    private static Scriptable js_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Scriptable arg;
        scope = NativeArray.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(cx, scope, "Array");
        Scriptable result = ctor.construct(cx, scope, ScriptRuntime.emptyArgs);
        if (thisObj instanceof NativeArray && result instanceof NativeArray) {
            NativeArray denseThis = (NativeArray)thisObj;
            NativeArray denseResult = (NativeArray)result;
            if (denseThis.denseOnly && denseResult.denseOnly) {
                boolean canUseDense = true;
                int length = (int)denseThis.length;
                int i = 0;
                while (i < args.length && canUseDense) {
                    if (args[i] instanceof NativeArray) {
                        arg = (NativeArray)args[i];
                        canUseDense = ((NativeArray)arg).denseOnly;
                        length = (int)((long)length + ((NativeArray)arg).length);
                    } else {
                        ++length;
                    }
                    ++i;
                }
                if (canUseDense && denseResult.ensureCapacity(length)) {
                    System.arraycopy(denseThis.dense, 0, denseResult.dense, 0, (int)denseThis.length);
                    int cursor = (int)denseThis.length;
                    int i2 = 0;
                    while (i2 < args.length && canUseDense) {
                        if (args[i2] instanceof NativeArray) {
                            NativeArray arg2 = (NativeArray)args[i2];
                            System.arraycopy(arg2.dense, 0, denseResult.dense, cursor, (int)arg2.length);
                            cursor += (int)arg2.length;
                        } else {
                            denseResult.dense[cursor++] = args[i2];
                        }
                        ++i2;
                    }
                    denseResult.length = length;
                    return result;
                }
            }
        }
        long slot = 0L;
        if (ScriptRuntime.instanceOf(thisObj, ctor, cx)) {
            long length = NativeArray.getLengthProperty(cx, thisObj);
            slot = 0L;
            while (slot < length) {
                Object temp = NativeArray.getElem(cx, thisObj, slot);
                NativeArray.setElem(cx, result, slot, temp);
                ++slot;
            }
        } else {
            NativeArray.setElem(cx, result, slot++, thisObj);
        }
        int i = 0;
        while (i < args.length) {
            if (ScriptRuntime.instanceOf(args[i], ctor, cx)) {
                arg = (Scriptable)args[i];
                long length = NativeArray.getLengthProperty(cx, arg);
                long j = 0L;
                while (j < length) {
                    Object temp = NativeArray.getElem(cx, arg, j);
                    NativeArray.setElem(cx, result, slot, temp);
                    ++j;
                    ++slot;
                }
            } else {
                NativeArray.setElem(cx, result, slot++, args[i]);
            }
            ++i;
        }
        return result;
    }

    private Scriptable js_slice(Context cx, Scriptable thisObj, Object[] args) {
        long end;
        long begin;
        Scriptable scope = NativeArray.getTopLevelScope(this);
        Scriptable result = ScriptRuntime.newObject(cx, scope, "Array", null);
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (args.length == 0) {
            begin = 0L;
            end = length;
        } else {
            begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
            end = args.length == 1 ? length : NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[1]), length);
        }
        long slot = begin;
        while (slot < end) {
            Object temp = NativeArray.getElem(cx, thisObj, slot);
            NativeArray.setElem(cx, result, slot - begin, temp);
            ++slot;
        }
        return result;
    }

    private static long toSliceIndex(double value, long length) {
        long result = value < 0.0 ? (value + (double)length < 0.0 ? 0L : (long)(value + (double)length)) : (value > (double)length ? length : (long)value);
        return result;
    }

    private Object indexOfHelper(Context cx, Scriptable thisObj, Object[] args, boolean isLast) {
        long start;
        Object compareTo = args.length > 0 ? args[0] : Undefined.instance;
        long length = NativeArray.getLengthProperty(cx, thisObj);
        if (isLast) {
            if (args.length < 2) {
                start = length - 1L;
            } else {
                start = ScriptRuntime.toInt32(ScriptRuntime.toNumber(args[1]));
                if (start >= length) {
                    start = length - 1L;
                } else if (start < 0L) {
                    start += length;
                }
            }
        } else if (args.length < 2) {
            start = 0L;
        } else {
            start = ScriptRuntime.toInt32(ScriptRuntime.toNumber(args[1]));
            if (start < 0L && (start += length) < 0L) {
                start = 0L;
            }
        }
        if (thisObj instanceof NativeArray) {
            NativeArray na = (NativeArray)thisObj;
            if (na.denseOnly) {
                if (isLast) {
                    int i = (int)start;
                    while (i >= 0) {
                        if (na.dense[i] != Scriptable.NOT_FOUND && ScriptRuntime.shallowEq(na.dense[i], compareTo)) {
                            return new Long(i);
                        }
                        --i;
                    }
                } else {
                    int i = (int)start;
                    while ((long)i < length) {
                        if (na.dense[i] != Scriptable.NOT_FOUND && ScriptRuntime.shallowEq(na.dense[i], compareTo)) {
                            return new Long(i);
                        }
                        ++i;
                    }
                }
                return NEGATIVE_ONE;
            }
        }
        if (isLast) {
            long i = start;
            while (i >= 0L) {
                if (ScriptRuntime.shallowEq(NativeArray.getElem(cx, thisObj, i), compareTo)) {
                    return new Long(i);
                }
                --i;
            }
        } else {
            long i = start;
            while (i < length) {
                if (ScriptRuntime.shallowEq(NativeArray.getElem(cx, thisObj, i), compareTo)) {
                    return new Long(i);
                }
                ++i;
            }
        }
        return NEGATIVE_ONE;
    }

    private Object iterativeMethod(Context cx, int id, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object callbackArg;
        Object object = callbackArg = args.length > 0 ? args[0] : Undefined.instance;
        if (callbackArg == null || !(callbackArg instanceof Function)) {
            throw ScriptRuntime.notFunctionError(ScriptRuntime.toString(callbackArg));
        }
        Function f = (Function)callbackArg;
        Scriptable parent = ScriptableObject.getTopLevelScope(f);
        Scriptable thisArg = args.length < 2 || args[1] == null || args[1] == Undefined.instance ? parent : ScriptRuntime.toObject(cx, scope, args[1]);
        long length = NativeArray.getLengthProperty(cx, thisObj);
        Scriptable array = ScriptRuntime.newObject(cx, scope, "Array", null);
        long j = 0L;
        long i = 0L;
        while (i < length) {
            Object elem;
            Object[] innerArgs = new Object[3];
            Object object2 = elem = i > Integer.MAX_VALUE ? ScriptableObject.getProperty(thisObj, Long.toString(i)) : ScriptableObject.getProperty(thisObj, (int)i);
            if (elem != Scriptable.NOT_FOUND) {
                innerArgs[0] = elem;
                innerArgs[1] = new Long(i);
                innerArgs[2] = thisObj;
                Object result = f.call(cx, parent, thisArg, innerArgs);
                switch (id) {
                    case 17: {
                        if (ScriptRuntime.toBoolean(result)) break;
                        return Boolean.FALSE;
                    }
                    case 18: {
                        if (!ScriptRuntime.toBoolean(result)) break;
                        NativeArray.setElem(cx, array, j++, innerArgs[0]);
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 20: {
                        NativeArray.setElem(cx, array, i, result);
                        break;
                    }
                    case 21: {
                        if (!ScriptRuntime.toBoolean(result)) break;
                        return Boolean.TRUE;
                    }
                }
            }
            ++i;
        }
        switch (id) {
            case 17: {
                return Boolean.TRUE;
            }
            case 18: 
            case 20: {
                return array;
            }
            case 21: {
                return Boolean.FALSE;
            }
        }
        return Undefined.instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'm') {
                    if (s.charAt(2) != 'p' || s.charAt(1) != 'a') break;
                    return 20;
                }
                if (c != 'p' || s.charAt(2) != 'p' || s.charAt(1) != 'o') break;
                return 9;
            }
            case 4: {
                switch (s.charAt(2)) {
                    case 'i': {
                        X = "join";
                        id = 5;
                        break block0;
                    }
                    case 'm': {
                        X = "some";
                        id = 21;
                        break block0;
                    }
                    case 'r': {
                        X = "sort";
                        id = 7;
                        break block0;
                    }
                    case 's': {
                        X = "push";
                        id = 8;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(1);
                if (c == 'h') {
                    X = "shift";
                    id = 10;
                    break;
                }
                if (c == 'l') {
                    X = "slice";
                    id = 14;
                    break;
                }
                if (c != 'v') break;
                X = "every";
                id = 17;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "concat";
                    id = 13;
                    break;
                }
                if (c == 'f') {
                    X = "filter";
                    id = 18;
                    break;
                }
                if (c != 's') break;
                X = "splice";
                id = 12;
                break;
            }
            case 7: {
                switch (s.charAt(0)) {
                    case 'f': {
                        X = "forEach";
                        id = 19;
                        break block0;
                    }
                    case 'i': {
                        X = "indexOf";
                        id = 15;
                        break block0;
                    }
                    case 'r': {
                        X = "reverse";
                        id = 6;
                        break block0;
                    }
                    case 'u': {
                        X = "unshift";
                        id = 11;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 4;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "constructor";
                    id = 1;
                    break;
                }
                if (c != 'l') break;
                X = "lastIndexOf";
                id = 16;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 3;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

